<?PHP
/*
* @package direct-project-innovation-initiative
* @subpackage views
*/ 

if(isset($user)){
	$total_mailboxes = $user->mailboxes;
	$mailboxes= array_slice($total_mailboxes, 0, $limit, true); //reduce the array to just $limit
	$additional_mailbox_count = count($total_mailboxes) - count($mailboxes);
}


?><!doctype html>
<html lang="en">
	<head>
		<title><?PHP echo PORTAL_TITLE_PREFIX.'New Message Count' ?></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
		<link rel="icon" href="/favicon.ico" type="image/x-icon" />
		<?php echo css_link_tag('css/custom-theme/bootstrap-scoped/css/bootstrap-scoped.min.css') ?>
		<style>
			.dsm-widget-outer { margin: 0; }
			.dsm-widget { border: 1px solid #0f4c7d; font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 12px;  background-color: #fff }
			.dsm-widget h1 { margin: 0; font-size: 1.5em; }
			.dsm-widget h2 { margin: 0; font-size: 1.2em; }
			.dsm-widget p { margin: 0; font-size: 0.9em; }
			.dsm-widget header, .dsm-widget main, .dsm-widget footer { display: block; padding: 10px;}
			.dsm-widget main, .dsm-widget footer { margin: 0.5em 0; padding: 10px 15%; text-align: center;}
			.dsm-widget .btn { width: 100%; margin: 5px auto; }
			
			.dsm-widget header { margin-bottom: 1em; background: #0f4c7d url('/images/themes/banners/background_va.png') 0px 0px no-repeat; }
			.dsm-widget header h1 { padding-left: 25px; background-image: url('/images/themes/logos/va_logo.png'); background-size: 18px 18px; background-repeat: no-repeat; color: #fff; }
			.dsm-widget main ul { width: 100%; padding: 10px 0; list-style-type: none;}
			.dsm-widget main li { width: 100%; display: block; float: left;}
			.dsm-widget main p { clear: both; }

			/* keep message count on the right using negative margin magic.  Note that this assumes that the message count will be no more than 50px, about 5 digits. */
			/* if message count is larger, the count will appear but spill out of its parent container, which will look odd.  Talk to Margaret if you have questions on how this works. */
			.dsm-widget .btn.mailbox { padding: 6px 50px; }
			.dsm-widget .mailbox, .mailbox .mailbox-name, .mailbox .badge-container { display: block; float: left; }
			.dsm-widget .mailbox .badge-container { width: 50px; margin-right: -100%; text-align: center;}
			.dsm-widget .mailbox .mailbox-name { width: 100%; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;}
			/* end negative margin responsive magic */
		</style>
		
</head>
<body class="dsm-widget-outer bootstrap">
	<div class="dsm-widget">
		<header><h1>VA Direct Messaging</h1></header>
		<main>
		<?php if(!empty($feedback_message)): ?>
			<?php echo $feedback_message ?>
		<?php else: ?>
			<h2>Mailbox (Unread Messages):</h2>
			<ul>
			<?php foreach($mailboxes as $id => $mailbox): ?>
				<li data-mailbox-id="<?php echo $id ?>">
					<a href="<?php echo site_url('inbox/change_mailbox_group/'.rawurlencode($mailbox['name'])) ?>" title="<?php echo $user->mailbox_names[$mailbox['name']] ?>" target="_blank" class="btn btn-info mailbox">
						<span class="mailbox-name"><?php echo $user->mailbox_names[$mailbox['name']] ?></span><span class="sr-only">: </span>
						<div class="badge-container">
							<span class="badge"> <?php echo $mailbox['unseen_message_count'] ?></span><span class="sr-only"> New Messages</span>
						</div>
					</a>
				</li>
			<?php endforeach ?>
			</ul>
			<?php if(!empty($additional_mailbox_count)): ?>
				<p><?php echo $additional_mailbox_count ?> more <?php echo ($additional_mailbox_count > 1) ? 'mailboxes are' : 'mailbox is' ?>  <?php ?> available on the full web portal.</p>
			<?php endif ?>
		<?php endif ?>
		</main>
		<footer>
			<?php echo link_to(site_url(), 'Full VA Direct Web Portal', array('target' => '_blank', 'class' => 'btn btn-primary')) ?>
		</footer>
	</div>
	<!-- Per JavaScript Upgrade, DSMEP2-355 -->
	<script type="text/javascript" src="/jscripts/jquery/jquery-3.3.1.min.js"></script>
	<script type="text/javascript" src="/jscripts/jquery-plugins/jquery-migrate-3.0.1.js"></script>
	<!--<script type="text/javascript" src="/jscripts/jquery.min.js"></script>-->
	<script>
		$().ready(function() {			
			if($('*[data-mailbox-id]').length) { //only check for mailboxes if we're displaying mailboxes
				window.setInterval( function(){$.ajax({	url: '/ajax/widgets/mailboxes',
												dataType: 'json',
												error: function() { location.reload(); }, //if we don't get a 200 response back, refresh the widget - the user may no longer be authorized
												success: function(data) {
													$.each($('*[data-mailbox-id]'), function(key, container) {
														id = $(container).attr('data-mailbox-id');
														$('*[data-mailbox-id="' + id + '"] .badge').text(data[id]['unseen_message_count']);
													});
												}				
									})}, 60000);
			}
		});
	</script>
</body>
</html> 