<?php

$defaults = array(
    'send_automatic_replies' => 0,
    'send_within_time_period' => 0,
    'start_date' => '',
    'start_time' => '',
    'end_date' => '',
    'end_time' => '',
    'content' => ''
);

foreach($defaults as $var => $default_value){
	if(!isset($$var)) {
	    $$var = $default_value;
    }
}

$this->load->view('header/header_settings');
$this->load->view('message_modal');
echo $this->load->view('settings/_tabs.php', array(), TRUE);

?>
<div class="content_settings">
    <div id="content">
        <div class="settings account-settings">
            <div class="content-header">
                <h2>Automatic Replies (Out of Office)</h2>
				<div class="pull-right"><span class="req">*</span> indicates required field.</span></div>
				<div style="clear: both;">
				<p>Use automatic replies to let others know that you are out of the office or not available to respond to messages.</p>
				</div>
            </div>

            <?php if(!empty($validation_errors)): ?>
            <div class="bootstrap">
                <div class="alert alert-danger">
                    <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                        <span aria-hidden='true'>&times;</span>
                    </button>
                    <?php echo implode_nonempty('<br>', $validation_errors); ?>
                </div>
            </div>
			<?php elseif( !empty($success_message) ): ?>
			<div class="bootstrap">
				<div class="alert alert-success alert-dismissable" role="alert">
					<button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                        <span aria-hidden='true'>&times;</span>
                    </button>
					<?php echo $success_message ?>
				</div>
			</div>
            <?php endif ?>

            <div class="bootstrap">
                <div class="form-dialog">
                    <?php echo form_open('/settings/automatic_replies', 'class="form-horizontal" role="form"'); ?>
                    <div class="form-group">
                        <?php echo form_label("Do not send automatic replies","send_automatic_replies_no"); ?>
                        <?php echo form_radio('send_automatic_replies', 0, empty($send_automatic_replies)); ?>
                    </div>
                    <div class="form-group">
                            <?php echo form_label("Send automatic replies","send_automatic_replies_yes"); ?>
                            <?php echo form_radio('send_automatic_replies', 1, (!empty($send_automatic_replies))); ?>
                    </div>

                    <fieldset class="automatic-reply-fields"<?php if(empty($send_automatic_replies)): ?> style="display: none;"<?php endif ?>>

                        <legend class="sr-only">Send Automatic Replies</legend>

                        <div class="form-group">
                            <?php echo form_label("Only send automatic replies within this time period:","send_within_time_period"); ?>
                            <?php echo form_checkbox('send_within_time_period', 1, (!empty($send_within_time_period))); ?>
                        </div>

						<div class="auto-reply-date-group">
							<div class="form-group text-input-form-group">
								<?php echo form_label("Start Date","start-date", array("class" => "control-label text-input-control-label")); ?>
								<div class="form-control-container text-input-form-control-container">
									<input type="text" name="start_date" id="start-date"
									   value="<?php echo $start_date;?>" maxlength="14"
									   class="form-control date-field calendar-field">
								</div>
							</div>
							<div class="form-group dropdown-form-group">
								<label for="start-time" class="control-label dropdown-control-label">Start Time</label>
								<span class="form-control-container dropdown-form-control-container">
									<?php
									echo form_dropdown(
										'start_time',
										$time_options,
										$start_time,
										'id="start-time" ' .
										'class="form-control date-field"'
									);
									?>
								</span>
							</div>
						</div>
						<div class='auto-reply-date-group'>
							<div class="form-group text-input-form-group">
								<?php echo form_label("End <br/> Date","end-date", array("class" => "control-label text-input-control-label")); ?>
								<div class="form-control-container text-input-form-control-container">
									<input type="text" name="end_date" id="end-date"
									   value="<?php echo $end_date;?>" size="14" maxlength="14"
									   class="form-control date-field calendar-field">
								</div>
							</div>
							<div class="form-group dropdown-form-group">
								<label for="end-time" class="control-label dropdown-control-label">End Time</label>
								<span class="form-control-container dropdown-form-control-container">
									<?php
									echo form_dropdown(
										'end_time',
										$time_options,
										$end_time,
										'id="end-time" ' .
										'class="form-control date-field"'
									);
									?>
								</span>
							</div>
						</div>
						<div class="clearfix"></div>
                        <div class="form-group">
                            <label for="content-field">Reply with this message:</label>
                            <?php
                            echo form_textarea(
                                    'content',
                                    $content,
                                    'id="content-field" ' .
                                    'class="form-control rich-text-editor"'
                                );
                            ?>
                        </div>
                    </fieldset>
                    <button class="minimal minimal-short" type="submit" id="save">Save</button>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $this->load->view("footer", array(), TRUE); ?>
<script>
$( window ).load(function(){

    function manageHiddenFields(){
        if($('input[name="send_automatic_replies"]:checked').val() != '1'){
            $('.automatic-reply-fields').hide();
            return;
        }

        if($('.automatic-reply-fields').css('display') == 'none'){
            $('#tinyeditorframe').height(100);
            $('.automatic-reply-fields').show();
        }

        if($('input[name="send_within_time_period"]').is(':checked')){
            $('.date-field').prop('disabled', false);
        }else{
            $('.date-field').prop('disabled', true);
        }
    }

    //make sure that fields get disabled every time we click on a radio button or checkbox
    $('input[type="radio"], input[type="checkbox"]').click(function() {
      manageHiddenFields();
    });

    manageHiddenFields();

    $('textarea.rich-text-editor').closest('form').submit(function( event ) {
        $('.rich-text-editor').val(editor.getEditorContent());
    });

    // init calendar fields
    $('.calendar-field').datetimepicker({
		currentText: "Today",
		dateFormat: 'D mm/dd/yy',
		showTime: false,
		minDate: new Date(),
		showTimepicker: false
	});

	$('#start-date')
		.find("ui-datepicker-buttonpane")
		.removeClass("ui-priority-secondary")
		.addClass("ui-priority-primary");

	$('#automaticreplies').focus();
    $('.calendar-field').css({"position": "relative","z-index": 999999});
});
</script>
<script type="text/javascript" src="/jscripts/dpii.admin.compose.js"></script>
</body>
</html>
