<?php

	$CI = get_instance();

	$this->load->view('header/header_settings');
	$this->load->view('message_modal');
	echo $this->load->view('settings/_tabs.php', array(), TRUE);

?>
<div class="content_settings">
        <div id="content" tabindex="0">
            <div class="settings account-settings">
                <div class="content-header">
                    <h2>Application Settings</h2>
                    <div class="pull-right"><span class="req">*</span> indicates required field.</span></div>
                </div>
                <div class="bootstrap">
                    <?php if(!empty($error_message)): ?>
                        <?php echo dismissable_alert($error_message, 'danger') ?>
                    <?php endif?>
                    <?php if(!empty($success_message)): ?>
                        <?php echo dismissable_alert($success_message, 'success') ?>
                    <?php endif?>
                    <?php if(!empty($this->session->flashdata('m'))) echo $this->session->flashdata('m'); ?>
                    <?php if(!empty($error_message)) echo dismissable_alert($error_message, 'danger'); ?>

                    <h3>Locale Settings</h3>
					<div class="form-dialog">
						<?php echo form_open(current_url(), array('class' => 'form-horizontal')); ?>
						<div class="form-group dropdown-form-group">
							<label for="country" class="control-label dropdown-control-label align-input-left" title"Country">Country<span class="req">*</span></label>
							<span class="form-control-container dropdown-form-control-container">
								<?php echo form_dropdown('country', $countries, $country, 'id="country" class="form-control dropdown-field" onchange="updateTimezoneList(this);"'); ?>
							</span>
						</div>
						<div class="form-group dropdown-form-group">
							<label for="timezone" class="control-label dropdown-control-label align-input-left" title="Timezone">Timezone<span class="req">*</span></label>
							<span class="form-control-container dropdown-form-control-container">
								<?php echo form_dropdown('timezone', $timezone_options, $timezone, 'id="timezone" class="form-control dropdown-field"'); ?>
							</span>
						</div>
						<button type="submit" class="minimal minimal-short">Update Information</button>
						<?php echo form_close(); ?>
					</div>
				</div>
				<div>
				    <h3>API Service Permission Settings</h3>
                    <p>This application makes use of the VLER Health Direct API.  In order to use this application, you must authorize the API to allow this application to access services on your behalf.  We recommend that you leave all services selected in order to ensure that you have full access to the features of this application.</p>
                    <button class="minimal" type="button"
						style="margin-top: 10px; padding-left: 5px; padding-right: 5px;"
						id="change_service_permission">Change Service Permissions</button>
                    <br style="display: block; clear: both;" />
                </div>
            </div>
        </div>
</div>
<?PHP $this->load->view("footer"); ?>
</body>
<script type="text/javascript">
    $().ready(function() {
        $('button#change_service_permission').click(function(){
            getWebservicePermission('<?php echo $CI->user->username ?>',0);
        });
    });
    $('#applicationsettings').focus();
</script>
</html>
