<?php

$CI = get_instance();

$tabs = array(
	'settings' => 'Account Settings',
	'settings/notifications' => 'Notification Settings',
	'settings/application' => 'Application Settings',
	'settings/automatic_replies' => 'Automatic Replies (Out of Office)'
);

?>
<div id="admin_menu">
	<div class="tabs">
	<?php foreach($tabs as $path => $description): ?>
	<?php 
		if(strpos(strtolower($description), 'replies') !== false){
			$attributes = array('id' => 'automaticreplies');
		} else {
			$attributes = array('id' => strtolower(str_replace(' ', '', $description)));
		}
	?>
		<div class="menuwrap">
			<div class="tab<?php if(current_url() == site_url($path)) echo ' active' ?>"><?php echo link_to($path, $description, $attributes) ?></div>
		</div>
	<?php endforeach ?>
	<?php if(isset($CI->help_video) && is_a($CI->help_video, 'Video')): ?>
		<?php echo $CI->help_video->tooltip_link() ?>
	<?php endif ?>
	</div>
</div>