<?php

$CI = get_instance();
$session_folder = Folder::find_from_session();
$anchor_class = 'mbox';

if($folder->id == $session_folder->id && !$is_multiple_folder_search) {
    $anchor_class = 'cur_mbox';
}

$name_with_message_count = $folder->name_for_display_with_message_count();
$folder_attributes = [
    'id' => 'folder_' . $folder->id,
    'class' => 'custom-folder',
    'data-id' => $folder->id,
    'data-depth' => $folder->depth,
    'data-max-child-depth' => $folder->max_child_depth
];

if(!$folder->has_children()) {
    $folder_attributes['class'] .= ' childless';
}

?>
<li <?php echo attributes_to_string($folder_attributes) ?>>
<?php if($folder->has_children()): ?>
	<a href="#" style="display: inline-block; float: left;" onclick="(event.preventDefault) ? event.preventDefault() : event.returnValue = false; toggleFolderTree($(this).children(':first'));">
		<img id="toggle_image_<?php echo $folder->id ?>" src="/images/caret-<?php echo ($folder->is_an_ancestor_of($session_folder)?'bottom':'right') ?>.png" alt="Expand Tree Icon"/>
	</a>
<?php endif ?>
	<img src="/images/closed_folder_yellow_icon.png" alt="Folder Icon" />
	<span id="<?php echo hash('sha256', $folder->name_for_display()) ?>" class="menu custom-folder-hash">&#9660;</span>
	<span class="custom_folder_name name-for-display" style="display: none;"><?php echo $folder->name_for_display() ?></span>
	<a id="anchor_<?php echo $folder->id ?>" title="<?php echo $name_with_message_count ?>" class="<?php echo $anchor_class  ?>" href="<?php echo site_url('inbox/change_mailbox/'.$folder->id) ?>">
		<?php echo  $name_with_message_count  ?>
	</a>
	<li id="accessible-menu-<?php echo $folder->id ?>" class="custom-mailbox-accessible-menu">
		<a id="archive_folder_<?php echo $folder->id ?>" class="hidden_context" href="/inbox/archive_folder/<?php echo $folder->id ?>">
			Archive Folder: <span class="name-for-display"><?php echo $folder->name_for_display() ?></span>
		</a>
		<a onclick="changeParent(<?php echo $folder->id ?>);" class="hidden_context" href="#">
			Change Parent Folder: <span class="name-for-display"><?php echo $folder->name_for_display() ?></span>
		</a>
		<?php echo form_hidden('old_value_'.$folder->id, $folder->name_for_display(), 'old_value_'.$folder->id) ?>
		<label id="rename_folder_label_<?php echo $folder->id ?>" for="rename_folder_<?php echo $folder->id ?>" class="hidden_context">Rename Folder</label>
		<input class="hidden_context" name="rename_folder_<?php echo $folder->id ?>" id="rename_folder_<?php echo $folder->id ?>" type="button" value="Rename Folder" onclick="renameFolder(<?php echo $folder->id ?>);">
	</li>
	<ul id="ul_<?php echo $folder->id ?>" <?php if(!$folder->has_children() || !$folder->is_an_ancestor_of($session_folder)): ?> style="display: none;"<?php endif ?>>
	<?php foreach($folder->child_folders as $child): ?>
		<?php echo $CI->load->view('inbox/folders/_custom_folder_menu_item', array('folder' => $child), TRUE) ?>
	<?php endforeach ?>
	</ul>
</li>
