<?php
/**
* Navigation for available actions when composing a message.
*
* This partial is called by the main template for viewing the inbox ({@link template.php}), and will be contained in the .menu div.  
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/

if(!isset($help_video)){
	require_library('video');
	try{ $help_video = new Video('how-to-use-va-direct'); } catch(Exception $e){ $this->error->warning($e->getMessage()); }
}
?>
<div class="button-container compose-buttons unit size1of1 line">
	<div class="buttons unit">
		<button type="submit" name="send" id="send_btn" class="minimal minimal-short" onclick="loadingScreen();">Send</button>
		<button type="submit" name="save" id="save_btn" class="minimal minimal-short" onclick="loadingScreen();">Save</button>
	<?php if(isset($message->id)): ?>
		<button type="button" name="discard" id="discard_btn" class="minimal minimal-short">Discard Draft</button>
	<?php endif ?>
		<a href="<?php echo site_url('inbox') ?>" class="cancel">Cancel</a>
	</div>
	
	<?php if(isset($help_video) && is_a($help_video, 'Video')): ?>
	<div class="unit">
		<?php echo $help_video->tooltip_link() ?>
	</div>
	<?php endif ?>
	<div class="action-buttons unit unit-right">
		
                <button type="button" class="minimal minimal-short minimal-image address-book" title="Global Address Book">
			<img src="/images/globaladdressbook.png" title="Global Address Book" alt="Global Address Book Icon" />
			<span class="hidden_context">Global Address Book</span>
		</button>
		<button type="button" class="minimal minimal-short minimal-image contact-list"  title="Personal Contact List">
			<img src="/images/contactlist.png" title="Personal Contacts List" alt="Personal Contacts List Icon" />
			<span class="hidden_context">Personal Contacts List</span>
		</button>
<?php /*
                <button type="button" class="minimal minimal-short minimal-image ps-address-book" title="Provider Search: For Use Only with Direct Messaging/eHealth Exchange" data-popup="width=700,height=600,scrollbars=yes" style="margin-left: 20px;">
			<img src="/images/addressbook.png" title="Provider Search: For Use Only with Direct Messaging/eHealth Exchange" alt="Provider Search: For Use Only with Direct Messaging/eHealth Exchange" />
			<span class="hidden_context">Provider Search Address Book</span>
		</button>
*/ ?>
	</div> 
</div>