<?php

if(!isset($validation_errors)) {
    $validation_errors = array();
}
$fields = array(
    'list_display_name' => 'Display Name',
    'list_description' => 'Description'
);
$max_lengths = Distribution_list_model::$form_field_limits;
?>
<div class="content-inner">
<div class="admin-panel-form">
<?php $success_message = '<strong>Success!</strong>&nbsp;&nbsp;Your Personal Distribution List has been updated.';?>
<div class='bootstrap'>
<div class='alert alert-success' id="dist_update_msg" hidden>
	<button type="button" class="close">&times;</button>
	 <?php echo $success_message; ?>
</div>
</div>
	<?php echo form_open($form, 'id = "edit_list"'); ?>
		<div class="fields-with-rail">
			<div class="required-message"><span class="req">*</span> indicates required field.</div>
			<table class="fields">
			<?php foreach($fields as $name => $description): ?>
				<tr>
					<td class="label-wrapper inline">
                        <label for="<?php echo $name ?>"><?php echo $description ?> <span class="req">*</span></label>
                    </td>
					<td>
						<?php
                            echo ajax_validated_form_input(
						        $name,
                                $form_data,
                                array(
                                    'maxlength' => $max_lengths[$name]
                                ),
                                (array_first_key($fields) == $name)
                            );
						?>
					</td>
					<td class="icon-wrapper">
						<img class="list_ajax_image" id="<?php echo $name ?>_image"
                             src="/images/ajax-loader.gif"
                             title="Processing User Action"
                             alt="Processing..."
                             style="display: none; " />
					</td>
				</tr>
			<?php endforeach ?>
			</table>

		</div>
		<hr>
		<div class="edit-pdl-wrapper">
			<div class="edit-pdl-results-wrapper">
				<span>Current Distribution List</span>
				<div class="edit-pdl-results-header actions ui-widget-header ui-helper-clearfix">
					<span class="pull-left" id="numCDL"><?php echo sizeof($curPDL) ?> Total Users</span>
						<a href="#" id="selectCDL" class="pull-right" data-type="sel">Select All</a>
				</div>
				<ul class="edit-pdl-results" id="list_members">
					<?php $curOptions = array(); // Used for invis select ?>
					<?php foreach($curPDL as $contact):?>
					<?php
						// Takes the ID from the end of the string, then removes the parenthesis
						$uuid = substr( strstr($contact, ')', FALSE), 1);
						// Replaces the parenthesis removed by substr()
						$contact_full = strstr($contact, ')', TRUE);
						$contact_full .= ')';
						$start = strpos($contact, '(');
						$end = strpos($contact, ')');
						$contact_email = substr($contact,$start+1,($end-1)-$start);
						$curOptions[$contact_email] = $contact_full.$uuid;
						?>
						<li class="pdl-user" id="pdl-user-cur-pdl-<?php echo $uuid?>">
                            <label for="cur-pdl-<?php echo $uuid?>">
                                <input id="cur-pdl-<?php echo $uuid?>"
                                 name="list_members[]"
                                 value="<?php echo $contact_email ?>"
                                 type="checkbox"
                                 data-uid="<?php echo $uuid ?>" >
                                 <?php echo $contact_full ?>
                             </label>
                        </li>
					<?php endforeach ?>
				</ul>
				<div class="edit-pdl-results-footer">
					<button class="pull-right" id="remove_sel">Remove Selected</button>
				</div>
			</div>

			<div class="edit-pdl-results-wrapper">
				<span>Search Results</span>
				<div class="edit-pdl-results-header actions ui-widget-header ui-helper-clearfix">
					<label class="hidden_context" for="list_search">Search For Contact</label>
					<input type="text" class="pull-left search empty ui-widget-content ui-corner-all" id="list_search" placeholder="Search For Contact" autocomplete="off" />
					<a href="#" id="selectGAB" class="pull-right" data-type="sel">Select All</a>
				</div>
				<ul class="edit-pdl-results" id="list_global">
					<?php foreach($user_options as $user):?>

					<?php
						// Takes the ID from the end of the string, then removes the parenthesis
						$uuid = substr( strstr($user, ')', FALSE), 1);
						// Replaces the parenthesis removed by substr()
						$user_full = strstr($user, ')', TRUE);
						$user_full .= ')';
						$start = strpos($user_full, '(');
						$user_email = substr($user_full,$start+1, -1);?>
						<li class="pdl-user" id="pdl-user-search-res-<?php echo $uuid?>">
                            <label for="search-res-<?php echo $uuid?>">
                                <input id="search-res-<?php echo $uuid?>"
                                 name="list_global[]"
                                 value="<?php echo $user_email?>"
                                 type="checkbox"
                                 data-uid="<?php echo $uuid ?>" >
                                 <?php echo trim($user_full) ?>
                             </label>
                        </li>
					<?php endforeach ?>
				</ul>
				<div class="edit-pdl-results-footer">
					<button class="pull-right" id="add_sel">Add Selected</button>
				</div>
			</div>
		</div>
		<select id="selected_users" name="selected_users[]" class="multiselect" multiple="multiple" style="display: none;">
		<?php foreach ($curOptions as $email => $info): ?>
			<?php
                $uuid = substr( strstr($info, ')', FALSE), 1);
                $info = strstr($info, ')', TRUE);
            ?>
			<option data-uid="<?php echo $uuid?>" value="<?php echo $email?>" selected><?php echo $info . ')'; ?></option>
		<?php endforeach ?>
		</select>
		<input id="list_id" name="list_id" type="hidden" value="<?PHP echo $this->security->xss_clean($list_id); ?>"/>
		<div class="button-container" id="pdl-btn-container">
			<?php echo $save_button ?>
			<?php echo $cancel_button ?>
		</div>
	<?php echo form_close(); ?>
</div>
</div>
<?php if($this->session->flashdata('dist_update_success')): ?>
<script>$('#dist_update_msg').fadeIn('slow'); </script>
<?php endif ?>
<script type="text/javascript" src="/jscripts/jquery.placeholder.js"></script>
<script>
	$().ready(function(){
		$('.close').on('click', function() {
			$('#dist_update_msg').fadeOut('slow');
		});

		var cdlLength = <?php echo sizeOf($curPDL)?>;
		var list_selected = [];
		// Set current PDL in invisible select
		$('#list_members input').each(function () {
				var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text());
				var contact = {
					id: $(this).attr('data-uid'),
					value: $(this).attr('value'),
					text: user_info
				};
				list_selected.push(contact);
			});
		$('#selectGAB').on('click', function(e) {
			e.preventDefault();
			if($(this).attr('data-type') === 'sel' ){
				$('#list_global input:checkbox').prop('checked', true);
				$(this).text('Deselect All');
				$(this).attr('data-type', 'desel');
			}else{
				$('#list_global input:checkbox').prop('checked', false);
				$(this).text('Select All');
				$(this).attr('data-type', 'sel');
			}
		});

		$('#selectCDL').on('click', function(e) {
			e.preventDefault();
			if($(this).attr('data-type') === 'sel' ){
				$('#list_members input:checkbox').prop('checked', true);
				$(this).text('Deselect All');
				$(this).attr('data-type', 'desel');
			}else{
				$('#list_members input:checkbox').prop('checked', false);
				$(this).text('Select All');
				$(this).attr('data-type', 'sel');
			}
		});

		$('#add_sel').on('click', function(e) {
			e.preventDefault();
			var selected = [];
			$('#list_global input:checked').each(function () {
			var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text());
				$('#pdl-user-'+$(this).attr('id') ).remove();
				var contact = {
					id: $(this).attr('data-uid'),
					value: $(this).attr('value'),
					text: user_info
				};
				list_selected.push(contact);
				selected.push(contact);
				cdlLength ++;
			});
			$('#numCDL').text( cdlLength +' Total Users');
			$.each(selected, function(i, val) {
				$('#list_members').append
						('<li class="pdl-user" id="pdl-user-cur-pdl-'+val.id+'">'	  +
						'<label for="cur-pdl-'+val.id+'">' +
						'<input id="cur-pdl-'+val.id+'" '  +
						'	 name="list_members[]" '  +
						'    value="'+val.value+'"'	  +
						'    data-uid="'+val.id+'"'   +
						'	 type="checkbox">'		  +
								val.text			  +
						'</label>'					  +
						'</li>');
                $('select#selected_users').append('<option value="' + val.value + '">' + val.text + '</option>');
			});
			$('#selectGAB').text('Select All');
			$('#selectGAB').attr('data-type', 'sel');
		});

		$('#remove_sel').on('click', function(e) {
			e.preventDefault();
			var selected = [];
			$('#list_members input:checked').each(function () {
				var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text());
				$('#pdl-user-'+$(this).attr('id') ).remove();
				var contact = {
					id: $(this).attr('data-uid'),
					value: $(this).attr('value'),
					text: user_info
				};
				selected.push(contact);
				list_selected = $.grep(list_selected, function(value) {
					return value.id != contact.id;
				});
				cdlLength --;
			});
			$('#numCDL').text( cdlLength +' Total Users');
			$.each(selected, function(i, val) {
				$('#list_global').append
						('<li class="pdl-user" id="pdl-user-search-res-'+val.id+'">'	  +
						'<label for="search-res-'+val.id+'">' +
						'<input id="search-res-'+val.id+'" '  +
						'	 name="list_global[]" '    +
						'    value="'+val.value+'"'	  +
						'    data-uid="'+val.id+'"'   +
						'	 type="checkbox">'		  +
								val.text			  +
						'</label>'					  +
						'</li>');
                $("select#selected_users option[value='" + val.value + "']").remove();
			});
			$('#selectCDL').text('Select All');
			$('#selectCDL').attr('data-type', 'sel');
		});

		$('#cancelBtn').on('click', function () {
			getPersonalAddressBook();
		});

		$('#saveBtn').on('click', function () {
			// Make sure the success message is hidden
			$('#dist_update_msg').hide();
			// Check current selected users with new selections
			$('#selected_users option').each(function() {
				var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text());
				var obj = {
					id: $(this).attr('data-uid'),
					value: $(this).attr('value'),
					text: $(this).html()
				}
				if(!objInArray(obj, list_selected)){
					$("#selected_users option[value='"+obj.value+"'").remove();
				}
			});
			$.each( $('#list_members input'), function (i, cur) {
				var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text());
				var curObj = {
					id: $(this).attr('data-uid'),
					value: $(this).attr('value'),
					text: user_info
				};
				if( objInArray(curObj, list_selected) && $("#selected_users option[value='"+curObj.value+"'").length < 1 ){
					$('#selected_users').append(
					"<option data-uid='"+ curObj.id +"' value='"+curObj.value+"' selected>"+curObj.text+"</option>" );
				}
			});
			updateList();
			$('#cancelBtn').text("Close");
		});

		function objInArray(obj, arr){
			var inArr = false;
			$.each(arr, function(i,cur) {
				if(cur.id === obj.id){
					inArr = true;
				}
			});
			return inArr;
		};

		$('#list_search').placeholder();
		$('#list_search').on('keyup', function (){
			var term = $(this).val().toLowerCase();
			$('#list_global input').each(function() {
				var user_info = $.trim($("label[for='"+$(this).attr('id') +"'").text()).toLowerCase();
				if (user_info.indexOf(term) >= 0){
					$('#pdl-user-'+$(this).attr('id')).show();
				}else {
					$('#pdl-user-'+$(this).attr('id')).hide();
				}
			});
		});

	});
</script>
