<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
*/
	$this->load->view('header/header_admin');
	$this->load->view('message_modal');
?>
		</div>
			<?PHP $this->load->view('adminpanel/admin_nav',array('item' => 'manage_groups')); ?>
			<div id="tabs">
				<div class="tab"><a href="/adminpanel/manage_groups/">Manage Groups</a></div>
				<div class="tab long-tab"><a href="/adminpanel/manage_groups/removed">Manage Removed Groups</a></div>
				<div class="tab active-tab"><a href="/adminpanel/manage_groups/create">Create Group</a></div>
			</div>
			<div id="content_wrapper">
				<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
				<div id="content">
					<div id="manage_groups">
						<h2><a href="/adminpanel/manage_groups/">Manage Groups</a> &#8594; <a href="/adminpanel/manage_groups/create/">Create Group</a></h2>
					<?php if(empty($facilities) && empty($services)): //if facilities and services are empty, we probably don't have access to the admin API, so user won't be able to create group and shouldn't have the permission that lets them create groups ?>						
						<p>This feature is currently unavailable.  Please try again in a few minutes, and if you continue to see this message, please contact the site administrator.</p>	
					<?php else: ?>
						<span style="position: absolute; margin-left: 450px; margin-top: 5px;"><span class="req">*</span> indicates required field.</span>
						<?PHP echo form_open(); ?>
							<table>
							<?php foreach(array('group_name', 'group_display_name', 'group_description') as $key => $field_name): ?>
								<tr>
									<td<?php if($key > 0): ?> style="vertical-align: bottom; padding-bottom: 5px;"><?php endif ?>
										<label for="<?php echo $field_name ?>"><?php echo humanize($field_name) ?> <span class="req">*</span></label>
									</td>
									<td>
									<?php if(!empty($validation_errors[$field_name])): ?>
										<div class="validation_error">
											<div class="validation_error message<?php if($key === 0): ?> absolute top<?php endif ?>">
												<a href="#"><?php echo $validation_errors[$field_name] ?></a>
											</div>								
									<?php endif ?>
										<input type="text" name="<?php echo $field_name ?>" id="<?php echo $field_name ?>" value="<?php echo element($field_name, $form_data) ?>" />
									<?php if(!empty($validation_errors[$field_name])): ?>
										</div>
									<?php endif ?>
									</td>
								</tr>
							<?php endforeach ?>
							<?php if(!empty($facilities)):?>
								<tr>
									<td>
										<?PHP echo form_label("Facility","facility_id");?><span class="req">*</span>
									</td>
									<td>
									<?php if(!empty($validation_errors['facility_id'])): ?>
										<div class="validation_error">
											<div class="validation_error message"><a href="#"><?php echo $validation_errors['facility_id'] ?></a></div>
									<?php endif ?>
										<?php echo form_dropdown('facility_id', 
																 array('' => '') + $facilities, 
																 element('facility_id', $form_data), 
																 'id="facility_id" data-placeholder="Choose a Facility" style="width: 100%;"'); ?>
			            			</td>
								</tr>
							<?php endif; ?>
							</table>
						<?php if(!empty($services)): ?>							
							<p>Select the permissions that webmail will have for this group.</p>
							<table class="log">
								<tbody>
								<tr>
									<th>Service</th>
									<th>
										<label for="select_all" class="hidden_context">Select All Permissions</label>
										<input style="width: 10px; float:center;" id="select_all" onclick="javascript:toggleSelectAll(this)" type="checkbox" checked="checked"/>
									</th>
									<th>Description</th>
								</tr>
							<?php foreach($services as $service):?>
									<tr>
										<td><label for="service_<?php echo $service->name; ?>" ><?php echo ucfirst($service->name);?></label></td>
										<td style="text-align: center;"><input style="width: 10px;" type="checkbox" id="service_<?php echo $service->name; ?>" name="service_<?php echo $service->name; ?>" checked="checked" value = "<?php echo $service->name; ?>"/> </td>
										<td><span><?php echo ($service->description);?></span></td>
									</tr>
								
							<?php endforeach ?>
							</tbody>
							</table>
						<?php endif ?>	
							<p>Note: The address for the group will be &lt;Group Name&gt;@<?PHP echo CLINICAL_DOMAIN; ?></p>
							<button name="create" class="minimal" type="submit" style="margin-top: 35px; padding-left: 5px; padding-right: 5px;">Create Group</button><br />
						<?PHP echo form_close(); ?>							
					<?php endif ?>
					</div>			
				</div>
			</div>
			<?PHP $this->load->view("footer"); ?>
		</div>
	</body>
<script>
	$('#facility_id').ready(function(){
		$('#facility_id').on('chosen:ready', function(){
			// MSIE version of the select box gradient
			$('.chosen-single').css('background', '-ms-linear-gradient(top,#ffffff 20%,#f6f6f6 50%,#eeeeee 52%,#f4f4f4 100%)');
		});
		$('#facility_id').chosen();
	});
</script>

