<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
*/

$CI = get_instance();
$items = array(
	'reports'            => 'Reports',
	'logs'               => 'Logs',
	'manage_users'       => 'Manage Users',
	'manage_groups'      => 'Manage Groups',
	'global_contacts'       => 'Contact List',
	'distribution_lists' => 'Distribution Lists',
	'themes'             => 'Themes',
	'archive_setting'    => 'Archive Settings',
	'announcements'      => 'Announcements',
	'message_all_users'  => 'Message All'
);

//remove any navigation items that the user does not have access to
foreach($items as $key => $value) {
	if (!$CI->has_permission($key)) {
		unset($items[$key]);
	}
}

			?>
			<div id="nav" style="text-align: center;">
				<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
				<a class="hidden_context hidden_link" name="menuContent" id="skipAdminMenu" href="#mainContent">Skip Menu</a>
				<div id="menu">
					<!-- Icons licensed under creative commons from Fat Cow web hosting (http://www.fatcow.com/) -->
					<div id="menu_container" class="menu_container left">
					<?php
						foreach($items as $key => $value){
							$classes = array('menu-item');
							if($key == $item) $classes[] = 'active-item';
							if($key == array_first_key($items)) $classes[] = 'left';
							if($key == array_last_key($items)) $classes[] = 'right';
							echo '<div class="'.implode(' ', $classes).'"><a href="/adminpanel/'.$key.'/" aria-label="Admin Panel Menu Link"><img src="/images/icons/icon_'.$key.'.png" alt="'.$value.' Icon" />'.$value.'</a></div>';
						}
					?>
					</div>
				</div>
			</div>