<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_model('api_entity');

#TODO - COUNT WON'T CURRENTLY WORK (THERE'S NO COUNT RESOURCE, SO WE'LL NEED TO JUST

class Folder extends API_entity {

    /**
     * @var string
     */
	static $create_resource = '/direct/folders/create';
    /**
     * @var string
     */
	static $delete_resource = '/direct/folders/archive';
    /**
     * @var string
     */
	static $find_resource = 'direct/folders';
    /**
     * @var string
     */
	static $find_one_resource = 'direct/folders';
    /**
     * @var string
     */
	static $rename_resource = '/direct/folders/rename';

	public function ancestor_ids(){
		$ancestor_ids = array();
		if($this->has_parent()){
			$parent = element($this->parent_id, get_instance()->mailbox->folders);
			$ancestor_ids[] = $this->parent_id;
			$ancestor_ids = array_merge($ancestor_ids, $parent->ancestor_ids());
		}
		return $ancestor_ids;
	}

	public function has_children(){
		return !$this->property_is_empty('child_folders');
	}

	public function has_parent(){
		return !$this->property_is_empty('parent_id');
	}

	public function indented_name_for_display(){
		 return str_repeat('&nbsp', 3 * $this->depth).$this->name_for_display();
	}

	public function is_an_ancestor_of($folder){
		return in_array($this->id, $folder->ancestor_ids);
	}

	public function is_current_location(){
		return $this->id == get_instance()->session->mailbox_location();
	}

	public function is_custom_folder(){
		return is_numeric($this->id);
	}

	public function is_a_descendant_of($folder){
		return in_array($folder->id, $this->ancestor_ids);
	}

	public function name_for_display(){
		if($this->is_custom_folder()){
			return strip_from_beginning(CUSTOM_MAILBOX_PREFIX, $this->name);
		}
		return $this->name;
	}

	/**
	* The name of the folder with the number of new messages in it.
	* For example, "Inbox (3)". Note for drafts, this will be the number of total messages in the folder, not just the number of new messages.
	* @return string
	*/
	public function name_for_display_with_message_count(){
		$name_with_message_count = $this->name_for_display();
		if(!empty($this->unseen_message_count()))
			$name_with_message_count = $name_with_message_count.' ('.$this->unseen_message_count().')';
		return $name_with_message_count;
	}

	public function can_become_parent_of($folder){
		return $folder->id != $this->id && ($this->depth + $folder->max_child_depth + 1) < NESTED_FOLDER_MAX_DEPTH;
	}

#TODO - To follow this model's paradigm properly, this should happen when the value of parent_id is changed for a folder instance and then saved.
#This needs to be refactored - this is a temporary stopgap so that we're at least not just calling on the API in a controller
	public function change_parent($parent_id){
		if(!is_null($parent_id) && !Folder::formatted_like_an_id($parent_id)) return $this->error->should_be_null_or_a_folder_id($parent_id);
		if(!$this->is_custom_folder()) return $this->error->should_be_a_custom_folder($this);

		if($parent_id == $this->parent_id) return true; //if the id is already set to this value, we're done

		//because the API still needs to get a parent id, even if it's empty,
		//and passing null just doesn't pass the API a parent id parameter
		//we set the parent id to an empty string here if it is null
		if(is_null($parent_id)) $parent_id = '';

		$CI = get_instance();
		$mailbox = $CI->mailbox->name;
		$folder_id = $this->id;


		Folder::api()->clear();
		if(!Folder::api()->call('/direct/folders/change_parent', compact('folder_id', 'parent_id', 'mailbox'), 'POST')){
			if(Folder::api()->http_status == 403){
				$this->session->set_service_permission_error_message('Manage', 'Failed to change folder parent because Manage Direct Service is disabled.');
    		}
			return false;
		}

		$this->load_field_values_from_db();

	   	$this->_run_after_update();
		$this->_run_after_create_and_update();

		return true;
	}

    /**
     * Rename the folder
     * @param $name
     * @return bool|false
     */
    public function rename($name){

		if (!$this->is->nonempty_string($name)) {
		    return $this->error->should_be_a_nonempty_string($name);
        }

		if (!$this->is_custom_folder()) {
		    return $this->error->should_be_a_custom_folder($this);
        }

		if ($this->name_for_display() == $name) {
		    return true;
        }

		$CI = get_instance();

		if(in_array($name, collect('name_for_display', $CI->mailbox->folders))) {
		    return $this->error->warning(
		        'Unable to rename ' . $this->describe() . ' to ' .
                $this->error->describe($name) .
                ' because there is already a folder with that name'
            );
        }

		$values_for_api = [
		    'mailbox' => $CI->mailbox->name,
            'folder' => $this->id,
            'name' => CUSTOM_MAILBOX_PREFIX . $name
        ];

		Folder::api()->clear();
		$success = Folder::api()->call(static::$rename_resource, $values_for_api, 'POST');
		if (!$success) {
			return $this->error->warning(
			    'Unable to rename ' . $this->describe() . ' to ' .
                $this->error->describe($name) . ' -- API says ' .
                $this->error->describe(Folder::api()->message())
            );
		}

		$this->load_field_values_from_db();
		$this->_run_after_update();
		$this->_run_after_create_and_update();

		return true;
	}

	//note that folders_to_populate_from *must* be keyed by primary key.
	protected function populate_child_folders($folders_to_populate_from){
		if(!is_array($folders_to_populate_from)) return $this->error->should_be_an_array_of_folder_entities($folders_to_populate_from);

		//make sure that each folder has references to its child folder _objects_ instead of the arrays they're initially populated with
		foreach($this->child_folders as $id => $data){
			if(array_key_exists($id, $folders_to_populate_from)){
				$this->_values['child_folders'][$id] = $folders_to_populate_from[$id];
			}
		}

		return true;
	}

	public function hierarchical_values(){
		$values = array_merge($this->values(array('id', 'name')),
							  array('name_for_display' => $this->name_for_display()),
							  $this->values());
		foreach($this->child_folders as $child_folder_id => $child_folder){
			$values['child_folders'][$child_folder_id] = $child_folder->hierarchical_values();
		}
		return $values;
	}

	/**
	* The number of new messages in this folder, as displayed in the inbox.
	* Note that for drafts, we display the total number of messages in the folder, so this method returns that value instead.
	* @return int
	*/
	public function unseen_message_count(){
		if($this->id == 'draft' && !$this->property_is_empty('total'))
			return $this->total;
		elseif(!$this->property_is_empty('new'))
			return $this->new;
	}

	public function descendants_in_hierarchical_order(){
		$descendants = array();
		foreach(Folder::sort_by_name($this->child_folders) as $child_folder_id => $child_folder){
			$descendants[$child_folder_id] = $child_folder;
			$descendants = $descendants + $child_folder->descendants_in_hierarchical_order;
		}
		return $descendants;
	}

	protected function _run_after_create_and_update(){
		get_instance()->mailbox->refresh_folders();
		return true;
	}

	protected function _values_for_save(){
		$values = parent::_values_for_save();
		$values['mailbox'] = get_instance()->mailbox->name;
		return $values;
	}

/////////////////////////
// STATIC
/////////////////////////

	//overrides parent because we don't have a count resource for folders
    public static function count($id_or_conditions = array()){
		return count(static::find($id_or_conditions));
    }

	public static function fields(){
		return array('id', 'name', 'parent_id');
    }

	public static function find($id_or_conditions = array(), $key_by = null){
		$results = parent::find($id_or_conditions, $key_by);

		//set up the results by primary key so that we can easily populate child folders, folder depth, etc.
		$primary_key = static::$primary_key;
		$results_by_primary_key = $results;
		if(!is_null($key_by) && $key_by != $primary_key){
			foreach($results as $folder){
				$results_by_primary_key[$folder->id] = $folder;
			}
		}

		//make sure the results are populated with references to their child folder entities, if that's possible with these results
		foreach($results as $result){
			$result->populate_child_folders($results_by_primary_key);
		}



		//since we don't actually have find_one behavior for folders, emulate this by checking to see if we have the primary key in the conditions

		$conditions = static::_conditions_for_find($id_or_conditions);
		if(!array_key_exists($primary_key, $conditions)) return $results;

		foreach($results as $key => $folder){
			if($folder->id == $conditions[$primary_key])
				return array($key => $folder);
		}

		return array(); //if none of the results matched the id, we have no results
    }

//not very efficient, but since we don't currently have a way of looking up just one folder or searching for a folder in the API
	public static function find_by_name($name, $key_by=null){
		$folders = static::find(array(), $key_by);
		foreach($folders as $folder){
			if($folder->name == $name) return $folder;
		}
	}

	public static function find_from_session(){
		$CI = get_instance();
		$folder_id = $CI->session->mailbox_location();
		if(empty($folder_id)) return false;

		if(Mailbox::is_an_entity($CI->mailbox))
			return element($folder_id, $CI->mailbox->folders);

		return static::find($folder_id);
	}

	public static function sort_by_name($folders){
		$system_folders = array_intersect_key($folders, array_flip(array('inbox', 'sent', 'draft', 'archived')));
		$custom_folders = array_diff_key($folders, array_flip(array('inbox', 'sent', 'draft', 'archived')));

		if(empty($system_folders)) $system_folders = array();
		if(empty($custom_folders)) $custom_folders = array();

		uasort($custom_folders, function( $a, $b) { return strnatcasecmp( $a->name_for_display, $b->name_for_display); });

		return $system_folders + $custom_folders;
	}


	protected static function _results_from_api_output(){
		$output = parent::_results_from_api_output();

		if(!is_array($output) || !array_key_exists('folder', $output))
			return array();

		return $output['folder'];
	}

	protected static function _conditions_for_find($id_or_conditions){
		$conditions = parent::_conditions_for_find($id_or_conditions);
		$CI = get_instance();

		//make sure we have a mailbox - assume that it's the current mailbox if not otherwise specified
		if(!array_key_exists('mailbox', $conditions) && isset($CI->mailbox)){
			$conditions['mailbox'] = $CI->mailbox->name;
		}
		return $conditions;
	}

	protected static function _delete($entity){
		static::api()->clear();
		$values = array('folder' => $entity->id);

		$CI = get_instance();
		if(isset($CI->mailbox))
			$values['mailbox'] = $CI->mailbox->name;

		return static::api()->call(static::$delete_resource, $values, 'POST');
	}

	protected static function _run_after_delete($entity){
		get_instance()->mailbox->refresh_folders();
	}
}
