<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/ /** */


/**
* @package direct-project-innovation-initiative
* @subpackage models
*/ 
class API_model extends CI_Model {
	
	
	public function webservice_call($resource, $verb, $post = null) {
		$CI = get_instance();
				
		//trying to shift to use the api library, so that we have a standard place where we call the api / standard way of dealing with errors, etc.
		if(is_null($post) || is_array($post)){
			$CI->api->clear();
			$CI->api->call($resource, $post, $verb); 
	
			$response_obj = new stdClass();	
			$response_obj->response = $CI->api->output();
			$response_obj->http_status = $CI->api->http_status;
			
			return $response_obj;
		}
		
	
		$url = WEBSERVICE_URL . $resource;
		$ch = curl_init();
		if(strtolower($verb) === 'post') {
			//assume url encoded for any POST that isn't from the send function, which has it's own web service call built in since it is the only function that needs to send files 
			 $headers = array(
				'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"POST\n" . date('U'). "\n". md5($post) . "\napplication/x-www-form-urlencoded\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
				'Date: ' . date('U'),
				'Content-Type: application/x-www-form-urlencoded',
				'Content-Md5: ' . base64_encode(md5($post)),
			 );
			curl_setopt($ch, CURLOPT_POST,1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		}
		else {
			$headers = array(
				'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',$verb."\n" . date('U'). "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
				'Date: ' . date('U'),
			);
		}

		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		if($server_output === false)
			trigger_error( curl_error($ch), E_USER_WARNING);
			
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

		//decode the JSON response automatically if we requested JSON
		if(strpos($resource,'format/json') >= 0) {
			$response = $CI->json->decode($server_output);
		}
		else { $response = $server_output; }
		
		if($http_status != 200 && $http_status != 403){
			$message = 'Error '.$http_status.' while accessing '.$url.'; ';
			if(is_object($response) && isset($response->message))
				$message .= ' '.strip_from_end('.', $response->message);
			trigger_error($message, E_USER_WARNING);
		}
		
		$response_obj = new stdClass();	
		$response_obj->response = $response;
		$response_obj->http_status = $http_status; 
		
		return $response_obj;
	}
}
