<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/**
* Parent class for models based on the API
*
* Note that extensions should define the *_resource variables with appropriate URLs
* and provide a static method called fields so that the models know which properties to expect from the API.
*
* @package direct-project-innovation-initiative
* @subpackage models
*/

class API_entity extends Entity {
	static $find_resource;
	static $find_one_resource;
	static $create_resource;
	static $update_resource;


///////////////////////////////
// DATA MANAGEMENT (INSTANCE)
//////////////////////////////

	protected function _create(){
	    log_message('debug','Creating ' . $this->model_alias . ' record');
		$error_message = 'Unable to create new '.$this->model_alias;
		if(empty(static::$create_resource))
			return $this->error->warning($error_message.': No resource has been specified for creation');

		if(!$this->_run_before_create() || !$this->_run_before_create_and_update())
			return $this->error->warning($error_message, 2); //run any specific actions for the child class; quit if actions fail.
		if(!$this->_values_are_valid_for_create() || !$this->_values_are_valid_for_create_and_update()){
			return $this->error->warning($error_message, 2);
		}

		//for create, save all writeable values - they may have defaults specified, even if we haven't altered anything
		static::api()->clear();
		$success = static::api()->call(static::$create_resource, $this->_values_for_save(), 'POST');
		if(!$success){
			return $this->error->warning($error_message.' -- API says "'.$this->api->message().'"');
			return false;
		}

		$id = element('id', static::api()->output_as_array());
		if(!static::formatted_like_an_id($id)) return $this->error->warning($error_message, 2);
		$this->_values[static::$primary_key] = $id; //usually you should use _set_field_value - _create() is the only place where we set this manually

		//reload the values in case the database automatically generates any values (timestamps, etc.)
		$this->load_field_values_from_db();

		if(!$this->_run_after_create()) return false; //if any cleanup (deletions) or error messages need to happen on failure, run_after_create should supply them
		if(!$this->_run_after_create_and_update()) return false;
		return true;
	}

    protected function _update(){
        log_message('debug','Updating ' . $this->model_alias . ' record');
		$error_message = 'Unable to update '.$this->describe().' with the following values: '.$this->error->describe($this->_values_for_save());
		if(empty(static::$update_resource))
			return $this->error->warning('No update resource has been specified for '.$this->model_alias.'. '.$error_message);

		if(!$this->_run_before_update() || !$this->_run_before_create_and_update())
			return $this->error->warning($error_message);
		if(!$this->_values_are_valid_for_update() || !$this->_values_are_valid_for_create_and_update()){
			return $this->error->warning('Values are not valid for update. '.$error_message);
		}

		//for update, check to make sure that we've set some of the values to make sure that we really need to save
		if(empty($this->altered_fields)) return true; //the update is unnecessary, so return true (but not false or with a notice, because it's not an invalid behavior to save an entity that hasn't changed)

		static::api()->clear();
		$success = static::api()->call(static::$update_resource, array_merge(array('id' => $this->id()), $this->_values_for_save()), 'POST');
		if(!$success) return $this->error->warning($error_message);

		//reload the values in case the database automatically generates any values (timestamps, etc.)
		$this->load_field_values_from_db();

		if(!$this->_run_after_update()) return false;
		if(!$this->_run_after_create_and_update()) return false;

		return true;
    }



/////////////////////////////////
// STATIC METHODS
/////////////////////////////////

	public static function api(){
		$CI = get_instance();
		return $CI->api;
	}

    public static function count($id_or_conditions = array()){
        $conditions = static::_conditions_for_find($id_or_conditions);

		static::api()->clear();
		if(!static::api()->call(static::$count_resource, $conditions)) return array(); //if the call doesn't work, we don't have any results.  The API library will trigger any necessary errors
		return element('count', static::api()->output_as_array());
    }

	public static function find($id_or_conditions = array(), $key_by = null){
        $CI = get_instance();
		static::api()->clear(); //clear anything previously set by another call

        $primary_key = static::$primary_key;

        //validate the input
        if(is_null($key_by)) $key_by = $primary_key;
        if(!$CI->is->nonempty_string($key_by)) return $CI->error->should_be_a_nonempty_string($key); //note that it's ok for the key to not be a known field if it's manually added it to the select

		$conditions = static::_conditions_for_find($id_or_conditions);
		if(!is_array($conditions)) return array(); //conditions weren't valid - _conditions_for_find will triger an error as necessry

		$resource = static::$find_resource;
        if(array_key_exists('id', $conditions)){
			$resource = static::$find_one_resource;
		}

        if(!static::api()->call($resource, $conditions)) return array(); //if the call doesn't work, we don't have any results.  The API library will trigger any necessary errors

		$results = static::_results_from_api_output();
		if(empty($results)) return array();

        //check to see make sure that the key that we're meant to be using is meaningful - if not, default to the primary key if it's in these results
        if(!is_string($key_by) || !array_key_exists($key_by, first_element($results))){
            if(array_key_exists($primary_key, first_element($results))){
                $CI->error->should_be_a_known_field($key_by);
                $key_by = $primary_key;
            }else{
                $CI->error->warning($CI->error->describe($key_by).' is not a known key.  The resulting array will not have meaningful keys.');
                return $results;
            }
        }

        $entities = array();
        $entity_class = get_called_class();
        foreach($results as $key => $result){
            $entity = new $entity_class();
            $entity->_set_field_values($result);
            $entities[$result[$key_by]] = $entity;
        }
        return $entities;
    }

    public static function find_one($id_or_conditions=array()){
        return first_element(static::find($id_or_conditions));
    }


	protected static function _conditions_for_find($id_or_conditions){
		if(!static::formatted_like_an_id($id_or_conditions) && !is_array($id_or_conditions)) return get_instance()->error->should_be_an_id_or_an_array_of_conditions();

		if(is_scalar($id_or_conditions))
			return array(static::$primary_key => $id_or_conditions);

		return $id_or_conditions;
	}

	protected static function _results_from_api_output(){
		return static::api()->output_as_array(); //by default, we'll return the whole output -> child classes will need to override this
	}


	public static function delete($id){
		$CI = get_instance();
		$class = get_called_class();

		$error_message = 'Unable to delete '.$class.'#'.$id;
		if(empty(static::$delete_resource))
			return $CI->error->warning('No delete resource has been specified for '.$class.' '.$error_message);

		if(!static::formatted_like_an_id($id)) return $CI->error->should_be_an_id($id);

		$entity = static::find_one($id);
		if(!static::is_an_entity($entity)) return $CI->error->should_be_an_x($id, 'id for an existing '.$class::model_alias().' entity');

		if(!static::_run_before_delete($entity)) return false;

		if(!static::_delete($entity)) return $CI->error->warning($error_message);

		static::_run_after_delete($entity);

		return true;
	}

	protected static function _delete($entity){
		static::api()->clear();
		return static::api()->call(static::$delete_resource, array_merge(array('id' => $entity->id)), 'POST');
	}


}
