<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_library('patient_data/soap_call');

/**
 * Class Document_retrieve
 */
class Document_retrieve extends Soap_call {
	var $wsdl_uri = CONNECT_DOCUMENT_RETRIEVE_WSDL;
	var $curl_options = array(
		CURLOPT_SSLCERT => TLS_SERVER_CERT_PATH,
		CURLOPT_SSLKEY => TLS_SERVER_KEY_PATH,
		CURLOPT_SSL_VERIFYHOST => TLS_SERVER_VERIFYHOST,
		CURLOPT_SSL_VERIFYPEER => TLS_SERVER_VERIFYPEER,
		CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1,
	);

	protected $MTOM_request = TRUE; //setting this to true due to the Adapter upgrade of Weblogic 12c and requring a MTOM request in order to send a MTOM resonse. -- BH 2017-05-07

	//these vars will be set from document metadata and passed to the XML
	protected $document_unique_id;
	protected $home_community_id;
	protected $repository_unique_id;

	/**
	* Looks up the CCD for the given patient id and returns the file with associated metadata.
	* The returned array will include document unique id, home community id, repository unique id, and a file array that includes
	* filename, contenttype, cid, and data (the binary data for the file).
	*
	* @param string
	* @return array
	*/
	function find_ccd_for_patient($patient_id){
        log_message('debug','Who called this (Document_retrieve::find_ccd_for_patient)');
		if(!$this->CI->is->nonempty_string($patient_id)) return $this->CI->error->should_be_a_patient_id($patient_id);

		//find the document metadata for this patient
		$this->CI->load->library('patient_data/document_query');
		$metadata = $this->CI->document_query->document_metadata_for_patient($patient_id);
		$this->feedback_messages = array_merge($this->CI->document_query->feedback_messages(), $this->feedback_messages); //make sure that any feedback messages from doc query get transferred

		//if there are no results, return false; //no documents found for this patient - could either be that something's wrong or that there's just no document
		if(is_array($metadata) && empty($metadata)) return $this->no_documents_message($patient_id, 'No documents were found by the document_query library for patient#'.$patient_id);
		if(empty($metadata)) return false; //if we don't get an array back, document_query will have set its own errors and feedback message

		//we could have metadata back for multiple documents - do a retrieve for each one
		foreach($metadata as $document_id => $document_metadata){
			 //set up class variables to match the metadata
			foreach($document_metadata as $var => $value) {
			    $this->$var = $value;
            }
			$response_data = $this->call_as_mtom($document_metadata);

			//if there were no attachments in the response, then this isn't the document we're looking for
			if(empty($response_data) || empty($this->attachments)) {
				continue;
			}

			//set up the response xml as a domdocument object so that we can search it
			$dom = new DOMDocument('1.0', 'UTF-8');
			$dom->encoding = 'utf-8';
			$dom->formatOutput = FALSE;
			$dom->preserveWhiteSpace = TRUE;
			$dom->substituteEntities = TRUE;
			$dom->loadXML($response_data);


			//find the include statement that indicates the cid for the attached document
			$xpath = new DOMXPath($dom);
			$xpath->registerNamespace('ns8', 'urn:ihe:iti:xds-b:2007');
			$xpath->registerNamespace('xop', 'http://www.w3.org/2004/08/xop/include');
			$document_include = $xpath->query('//ns8:DocumentResponse[ns8:DocumentUniqueId = "'.$document_id.'" and ns8:mimeType="text/xml"]/ns8:Document/xop:Include[@href]');
			if(!is_a($document_include, 'DOMNodeList') || !$this->CI->is->nonzero_unsigned_integer($document_include->length)) continue; //if there are no results, move onto the next document

			//find the cid and make sure that we have an attachment with that cid
			if($document_include->length > 1) $this->CI->error->warning('More than one document returned for document#'.$document_id.'; discarding all but the first.');
			$cid = strip_from_beginning('cid:', $document_include->item(0)->getAttribute('href'));
			if(!array_key_exists($cid, $this->attachments)){
				$this->CI->error->warning('Attachment with cid='.$cid.' for document#'.$document_id.' was not found');
				continue;
			}

			//this is in a particular order, though it's possibly unnecessary
			//the reasoning is that even if something with the c32 template id would be considered a c62 if that tempalte id is there, and ccda overrides all
			$recognized_xml_file_types = array('ccr', 'c32', 'c62', 'ccda');
			foreach($recognized_xml_file_types as $file_type) {
				$validator_method = $file_type . '_xml_string';
				if($this->CI->is->{$validator_method}($this->attachments[$cid]['data'])) { $document_metadata['filetype'] = $file_type; }
			}

			//add the actual file information to the document metadata array - according to nusoap docs, this will be an array with four keys: data, filename, contenttype, and cid
			$document_metadata['file'] = $this->attachments[$cid];
			unset($this->attachments[$cid]['data']); //unsetting just for debugging - binary file data usually messes up our print statements
			return $document_metadata;
		}

		return $this->no_documents_message($patient_id, 'No CCDs were found by the document_retrieve library for patient#'.$patient_id.'. The documents found by document_query were: '.sprp_for_log($metadata));
	}
}
