<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_library('patient_data/soap_call');

/**
 * Class Document_query
 * Gathers metadata for each of the documents for a given patient.
 */
class Document_query extends Soap_call {
	var $wsdl_uri = CONNECT_DOCUMENT_QUERY_WSDL;
	var $curl_options = array(
		CURLOPT_SSLCERT => TLS_SERVER_CERT_PATH,
		CURLOPT_SSLKEY => TLS_SERVER_KEY_PATH,
		CURLOPT_SSL_VERIFYHOST => TLS_SERVER_VERIFYHOST,
		CURLOPT_SSL_VERIFYPEER => TLS_SERVER_VERIFYPEER,
		CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1,
	);
	var $patient_id; //this will be set on a case-by-case basis

	//should these be constants?
	var $query_id = 'urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d'; //Stored query - this should be the same in all environments, yes?
	var $document_entry_status = 'urn:oasis:names:tc:ebxml-regrep:StatusType:Approved';
	var $document_entry_class_code = '34133-9-C'; // CCD LOINC Code
	var $document_entry_class_code_scheme = '2.16.840.1.113883.6.1'; // We are using LOINC

	/**
	* Finds the metadata for all documents for a given patient that match our criteria.
	* Note that this may be more than one document.  The data will be returned as an array formatted array($document_id => array()).
	*
	* @param string The patient ID, e.g. 'D123401'
	* @return boolean|array An array of the patient metadata, or false if something went wrong with the call.
	*/
	function document_metadata_for_patient($patient_id){
		if(!$this->CI->is->nonempty_string($patient_id)) return $this->CI->error->should_be_a_patient_id($patient_id);
		$this->patient_id = $patient_id;
		$response_data = $this->call(compact('patient_id'));
		$this->patient_id = null; //clear value after calling, so that we don't accidentally call the same patient data multiple times
		if(empty($response_data)) return false;

		//set up a DOMDocument to represent the XML in the response
		$dom = new DOMDocument('1.0', 'UTF-8');
		$dom->encoding = 'utf-8';
		$dom->formatOutput = FALSE;
		$dom->preserveWhiteSpace = TRUE;
		$dom->substituteEntities = TRUE;
		$dom->loadXML($response_data);

		//search for the <ns3:extrinsicObject> elements that represent documents
		$xpath = new DOMXPath($dom);
		$xpath->registerNamespace('ns3', 'urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0');
		$xpath->registerNamespace('ns4', 'urn:oasis:names:tc:ebxml-regrep:xsd:query:3.0');
		$extrinsic_objects = $xpath->query('//ns4:AdhocQueryResponse/ns3:RegistryObjectList/ns3:ExtrinsicObject[@lid and @home]');
		if(!is_a($extrinsic_objects, 'DOMNodeList') || !$this->CI->is->nonzero_unsigned_integer($extrinsic_objects->length))
			return $this->no_documents_message($patient_id, 'No extrinsic objects were found in the Document Query XML response for patient#'.$patient_id); //if there are no results, return false

		//parse each <ns3:extrinsicObject> element for the relevant metadata.
		$metadata_for_documents = array();
		foreach($extrinsic_objects as $extrinsic_object){
			if(!$extrinsic_object->hasAttribute('lid') || !$extrinsic_object->hasAttribute('home')) continue; //if we can't find the attributes we need, this isn't really a result

			$document_unique_id = $extrinsic_object->getAttribute('lid');
			$home_community_id = $extrinsic_object->getAttribute('home');

			//search this extrinsic object for a respository id
			$xpath = new DOMXPath($dom);
			$xpath->registerNamespace('ns3', 'urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0');
			$request_unique_id_element = $xpath->query('//ns3:Slot[@name=\'repositoryUniqueId\']/ns3:ValueList/ns3:Value')->item(0);
			if(!is_a($request_unique_id_element, 'DOMElement')) continue; //this isn't a real result if we don't have a repository unique id
			$repository_unique_id = $request_unique_id_element->textContent;

			$metadata_for_documents[$document_unique_id] = compact('document_unique_id', 'home_community_id', 'repository_unique_id');
		}

		return $metadata_for_documents;
	}
}
