<?php 
/**
* @package direct-project-innovation-initiative
* @subpackage hooks
*/

/**
* Runs any system-wide code based on the constants file.
* For example, the timezone needs to be set to the default timezone for this instance of Direct.
*/
function set_system_defaults(){
	date_default_timezone_set(ENVIRONMENT_TIMEZONE); //this instance of Direct will be configured with a default timezone, we want it set as early as possible
}

function set_up_session(){
	//at this point, the controller has not been instantiated yet, but the core/Codeigniter bootstrap script has determined which controller and method will be called
	global $class; //the name of the controller class
	global $method; //the method of the controller class which CI will call
	
	$class = strtolower($class);
	$method = strtolower($method); 

	session_set_cookie_params(0, $class, CLINICAL_DOMAIN, TRUE, TRUE);
	session_cache_limiter('none'); //this was included in the restricted controller, but doesn't appear to be a valid value for cache_limiter - should be nocache if we're doing this
#	session_start();

}

/**
* Check to see if there's a theme set for this user and set it as a controller class var if there is.
*/
function set_user_theme(){
	if(is_cli() || defined('PHPUNIT_TEST')) return; //this hook only applies to HTML output
	
	$hooks_disabled = array('install', 'unit_test_controller');
	$CI = get_instance();
	if(is_object($CI)){
		$controller = strtolower(get_class($CI));
		if(!in_array($controller, $hooks_disabled)) {
			require_model('theme'); 
			$theme = Theme::find_from_session();
			if(Theme::is_an_entity($theme))
				$CI->user_theme = $theme->values;
		}
	}
}

function set_up_authentication(){
	$CI = get_instance();
	
	if (USE_PIV_AUTH === TRUE){
		$CI->load->library('authentication/PIV_authentication', array(), 'authentication');
	}elseif(USE_CAC_AUTH === TRUE){
		$CI->load->library('authentication/CAC_authentication', array(), 'authentication');
	}elseif(USE_SSO_AUTH === TRUE){
		$CI->load->library('authentication/SSO_authentication', array(), 'authentication');
	}else{
		$CI->error->warning('No form of authentication is currently configured.');
	}
	
}
 
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ACCESSORS FOR PERFORMANCE LOGGING DEPENDENCIES
// Since hook methods need to be in APPPATH, we can't just reference Benchmark or the API library directly in the hook 
// configuration, unless maybe we think of a clever way later.  For now, this will do.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//set a benchmark for each of our hooks
function add_benchmark($hook_name){
	$BM =& load_class('Benchmark', 'core'); //controller won't be instantiated for our first hook, so need to load the same way the core/CI script does it
	$BM->mark($hook_name);
}

//on the last hook, write the benchmarks to a CSV so that we can parse the data easily
function write_benchmarks_to_log(){
	$CI =& get_instance();
	$CI->benchmark->write_to_csv();
}

function write_api_calls_to_log(){
	$CI =& get_instance();
	if(!$CI->load->is_loaded('api')) return; //nothing to do if the API library isn't up and running in the application
	$CI->api->write_performance_log_to_csv();
}


/* End of file hook_functions.php */
/* Location: ./application/hooks/hook_functions.php */
