<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* True if this is a local developer environment
* It's easy to mistype values for constants or forget whether or not they're capitalized -- using a method provides some extra checks, as we'll see an error if the method doesn't exist.
* @return boolean
*/
function is_on_local(){
	return ( (ENVIRONMENT == 'development' || ENVIRONMENT == 'regression') && DP_ENVIRONMENT == 'LOCAL' );
}

/**
* True if this is a dev environment (either a developer's local or the central dev environment
* It's easy to mistype values for constants or forget whether or not they're capitalized -- using a method provides some extra checks, as we'll see an error if the method doesn't exist.
* @return boolean
*/
function is_on_dev(){
	return (ENVIRONMENT == 'development' || ENVIRONMENT == 'regression');
}

//true if this a portion of the site that people are accessing as an API, rather than the part of the site serving up HTML
function in_api_context(){
	return defined('API_DOMAIN') && string_contains(API_DOMAIN, base_url());
}

// the array that stores all valid domains for the Webmail.
function valid_domains(){
	return array(CLINICAL_DOMAIN);
}

?>
