<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/adminpanel.php';

/**
* Site Announcement page within the Adminpanel.
* This page is used to store functions related to Announcements stored in the database,
*  and the session variable used to display it within the banner.
* Routing is handled using CI routing functionality instead so that each action can be separated into a child function.
*
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Announcement_controller extends AdminPanel {

	protected $validation_errors = array();
	
	function __construct() {
		parent::__construct();
		$this->verify_permission('announcement'); 
	} 

	/**
	* Displays a form within the Adminpanel to enable/disable Site Announcements table .
	*/	
	function index(){
		
		require_model('announcement');
		
		//set the announcement to pull the one row in which by default is a empty message with a disabled status.
		$announcement = Announcement::find_one();
		if(!Announcement::is_an_entity($announcement))
			$announcement = new Announcement();
		
		//set up the form generator so that we can validate existing data or provide the form to populate new data			
		require_library('form_markup_generator');
		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields(array('enabled' => array('type' => 'dropdown',
															   'required' => true,
															   'options' => array(0 => 'No', 1 => 'Yes'),
															   'label_attributes' => array('class'=>'col-sm-5'),
															   'label_text' => 'Display the announcement:',
															   'referral_label' => 'Site Announcement Status'
				
															  ),
											'content' => array('type' =>'text_area',
															   'max_length' => 1000,
															   'required' => true,
															   'inline' => true,
															   'label_attributes' => array('class'=>'col-sm-5'),
															   'label_text' => 'What should the announcement say?',
															   'referral_label' => 'Site Announcement',
															   'comment' => 'Please limit your response to 1000 characters.'
															  )	
		));
		
		$title = PORTAL_TITLE_PREFIX . "Announcement Settings";
		
		if(empty($_POST)){
			if(Announcement::is_an_entity($announcement) && (!$announcement->property_is_empty('enabled') || !$announcement->property_is_empty('content'))){
				$markup_generator->set_values($announcement->values(array('enabled','content')));
			}
		} else {
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages);
			}else{
				$updated_values = array('enabled' =>(boolean)$markup_generator->value('enabled'),
										'content' =>htmlentities($markup_generator->value('content')));
				$announcement->set_values($updated_values);
				$announcement->save();

				$success_message = '<strong>Success!</strong>&nbsp;&nbsp;Your changes have been saved.';
			}
		}
	
		$this->load->view('adminpanel/announcements', compact('error_message', 'success_message', 'markup_generator','title'));
	}
	
	
	private function _sanitize_content($string) {
    // ----- remove HTML TAGs ----- 
    $string = preg_replace ('/<[^>]*>/', ' ', $string); 
    
    // ----- remove control characters ----- 
    $string = str_replace("\r", '', $string);    // --- replace with empty space
    $string = str_replace("\n", ' ', $string);   // --- replace with space
    $string = str_replace("\t", ' ', $string);   // --- replace with space
    
    // ----- remove multiple spaces ----- 
    $string = trim(preg_replace('/ {2,}/', ' ', $string));
    
    return $string; 
	}

}
/* End of file Announcement_controller.php */
/* Location: ./application/controllers/admin_panel/Announcement_controller.php */
