<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Registration extends CI_Controller{

	function index() {

		if(!$this->authentication->is_valid()){
			redirect('auth/logout');
			return $this->error->warning('Cannot register user: this user has not been authenticated by their organization'); //just in case the redirect didn't work
		}

		if(User::is_an_entity($this->authentication->user)){

			//for an active user, just send them to the inbox
			if($this->authentication->user->is_active()){
				redirect('inbox');
				return $this->error->warning('This user already has an account and cannot be registered'); //just in case the redirect didn't work
			}

			return $this->show_system_message(PORTAL_TITLE_PREFIX . 'Account Deactivated', 'The user account associated with the provided credentials has been deactivated. Please contact an administrator directly for help.');
		}

		$account = $this->get_registration_info();
		if(!is_object($account)) return $this->show_registration_error('An error has occurred.  Please try again in a moment.  If this problem persists, contact an administrator.');

		if(!isset($account) || !isset($account->organization_id) || $account->organization_id != $this->authentication->organization_id){
			$this->error->warning('Account does not contain an organization id: '.sprp_for_log($account));
			return $this->show_registration_error('An error occurred and we could not create your account.  Please try again in a moment.  If this problem persists, contact an administrator.');
		}

		if($account->is_denied)
			return $this->show_registration_error('Your request for a Direct account has been denied.  If you believe this to be an error, please contact an administrator for assistance.');

		if(!$account->is_registered)
			return $this->template->load('registration/template', 'registration/form', compact('account'));

		if(!$account->is_approved)
			return $this->show_registration_message('Your account is currently pending and awaiting administrative approval.  An email will be sent to you when your account has been approved.');

		if(empty($account->username))
			return $this->show_registration_error('An error occurred and we could not create your account.  Please try again in a moment.  If this problem persists, contact an administrator.');

		if(User::exists(array('user_name' => $account->username)))
			return $this->show_registration_error('Your Direct username already exists in Webmail. Please contact an administrator for assistance.');

		if(!$account->is_active)
			return $this->show_registration_error('Your Direct account has been disabled.  If you believe this to be in error, please contact an administrator for assistance.');


		if(!User::create(array('user_name' => $account->username))){
			if($this->api->http_status == 403)
				return $this->template->load('registration/template', 'registration/form', compact('account')); //user probably needs to grant permission to this application
			return $this->show_registration_error('An error occurred and we could not create your account.  Please try again in a moment.  If this problem persists, contact an administrator.');
		}

		//on success, redirect to the main application
		redirect('auth');
	}



	/*Displays the web service permission form view, meant for use in a modal window or pop-up */
	public function webservice_permission() {
		$this->load->view('registration/webservice_permission');
	}

	public function get_webservice_permission($mailbox_name, $is_group) {
		$redirect_url = rawurlencode(base64_encode(base_url() . 'inbox/close_authorize'));
		$resource = '/authorize/get_webservice_permission/redirect_url/' . $redirect_url . '/is_group/' . $is_group . '/mailbox_name/' . $mailbox_name . '/format/json';
		$url = WEBSERVICE_URL . $resource;
		$dt = date('U');
		$headers = array(
            'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"GET\n" . $dt . "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
            'Date: ' . $dt,
		);

		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		if($server_output === false) {
		    trigger_error( curl_error($ch), E_USER_WARNING);
        }
		echo $server_output;
	}

	protected function get_registration_info() {
		$org_id = $this->authentication->organization_id;

		$this->api->clear();
		if(!$this->api->call('/authorize/register', array('unique' => $org_id, 'redirect_url' => current_url())) || !is_object($this->api->output())){
			return $this->error->warning('Unable to check the API for registration status for user with organiation id '.$this->error->describe($org_id));
		};

		return $this->api->output();
	}

	protected function show_system_message($title, $message){
		$this->load->view('system_message', compact('title', 'message'));
	}

	protected function show_registration_message($message, $subheader=''){
		$this->template->load_string('registration/template', tag('p', $message));
	}

	protected function show_registration_error($message = ''){
		$this->template->load_string('registration/template', tag('p', $message));
	}

}
