<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once APPPATH.'controllers/restricted_controller.php';

class Feedback extends Restricted_controller {

	public function index() {

		require_library('form_markup_generator');

		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields( array(
		    'feedback_type' => array(
		        'type' => 'radio_button_group',
                'required' => true,
                'label_text' => 'Please express the nature of your feedback:',
                'referral_label' => 'Feedback Type',
                'options' => array(
                   'General Feedback' => 'General Feedback',
                    'Issue Report' => 'Report Issue'
                ),
                'value' => 'General Feedback'
            ),
            'feedback_comments' => array(
                'type' => 'text_area',
                'required' => true,
                'max_length' => 4000,
                'label_text' => 'Please provide your feedback in the space below:',
                'referral_label' => 'Feedback Comments',
                'attributes' => array(
                    'rows' => 10,
                    'cols' => 90
                )
            )
        ));

		if(!empty($_POST) && array_key_exists('feedback_comments', $_POST)){
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$this->template->set(
				    'danger_message',
                    '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages)
                );
			} elseif (!$this->user->submit_feedback($markup_generator->field('feedback_type')->value, $markup_generator->field('feedback_comments')->value)) {
				$this->template->set('danger_message', '<strong>An error occurred and your feedback could not be saved.</strong> Please try again in a moment, and contact a site administrator if the problem persists.');
			} else {

				if(!IS_AJAX){
				    $this->session->set_success_message('Thanks for your input!  Your feedback has been submitted to the site administrators.');
					redirect(site_url()); //just head back to the inbox, since we don't know where they came from
				}

				// show success message and ability to close out the form
				$this->template->set('success_message', '<strong>Thanks for your input!</strong>&nbsp;&nbsp;Your feedback has been submitted to the site administrators.');

				// reset values to a blank form
				$markup_generator->field('feedback_type')->value = 'General Feedback';
				$markup_generator->field('feedback_comments')->value = '';
			}
		}

		$this->template->load('form_dialog_template.php', 'feedback/_form', compact('markup_generator'));
	}

}
