<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* URI ROUTING
*
* This file lets you re-map URI requests to specific controller functions.
*
* Typically there is a one-to-one relationship between a URL string
* and its corresponding controller class/method. The segments in a
* URL normally follow this pattern:
*
*	example.com/class/method/id/
*
* In some instances, however, you may want to remap this relationship
* so that a different class/function is called than the one
* corresponding to the URL.
*
* Please see the user guide for complete details:
*
*	http://codeigniter.com/user_guide/general/routing.html
*
*
* RESERVED ROUTES
*
* There area two reserved routes:
*
*	$route['default_controller'] = 'welcome';
*
* This route indicates which controller class should be loaded if the
* URI contains no data. In the above example, the "welcome" class
* would be loaded.
*
*	$route['404_override'] = 'errors/page_missing';
*
* This route will tell the Router what URI segments to use if those provided
* in the URL cannot be matched to a valid route.
*
* @package direct-project-innovation-initiative
* @subpackage config
*/



$route['default_controller'] = 'auth'; //by default, send the user to the login screen
if(defined('PHPUNIT_TEST'))
	$route['default_controller'] = 'Unit_test_controller';


$route['404_override'] = 'errors';

/*Admin Panel Routes */

/* preferred routes for new admin panel pages - add the model to the parentheses, eg (global_contact|your_new_model) */
$route['adminpanel/(global_contact)s'] = 'admin_panel/$1_controller/index';
$route['adminpanel/(global_contact)s/page/(:num)'] = 'admin_panel/$1_controller/index/$2';
$route['adminpanel/(global_contact)s/(.+)'] = 'admin_panel/$1_controller/$2';
$route['adminpanel/(global_contact)s/(:any)/(.+)'] = 'admin_panel/$1_controller/$2/$3';
$route['adminpanel/(global_contact)s/(:any)/(:any)/(.+)'] = 'admin_panel/$1_controller/$2/$3/$4';

$route['adminpanel/distribution_lists/removed'] = 'adminpanel/distribution_lists_removed';
$route['adminpanel/distribution_lists/create'] = 'adminpanel/create_distribution_list';
$route['adminpanel/distribution_lists/page/(.+)'] = 'adminpanel/paginate_distribution_lists/$1';
$route['adminpanel/distribution_lists/removed/page/(.+)'] = 'adminpanel/paginate_distribution_lists_removed/$1';
$route['adminpanel/distribution_lists/list/(.+)'] = 'adminpanel/distribution_lists_edit/$1';
$route['adminpanel/distribution_lists/removed/list/(.+)'] = 'adminpanel/distribution_lists_edit_removed/$1';

$route['adminpanel/manage_(group|user)s'] = 'admin_panel/$1_controller/index';
$route['adminpanel/manage_(group|user)s/page/(:num)'] = 'admin_panel/$1_controller/index/$2';
$route['adminpanel/manage_(group|user)s/(.+)'] = 'admin_panel/$1_controller/$2';
$route['adminpanel/manage_(group|user)s/(:any)/(.+)'] = 'admin_panel/$1_controller/$2/$3';
$route['adminpanel/manage_(group|user)s/(:any)/(:any)/(.+)'] = 'admin_panel/$1_controller/$2/$3/$4';

$route['adminpanel/contact_list'] =  'admin_panel/global_contact_controller/index';

$route['adminpanel/announcements'] = 'admin_panel/announcement_controller/index';

$route['adminpanel/message_all_users'] = 'admin_panel/system_wide_message_controller/compose';

$route['ajax/dismiss_banner/(:any)'] = 'inbox/ajax_dismiss_banner/$1';

$route['help/videos/(:any)'] = 'help_controller/video/$1';
$route['help/videos/(:any)/(high-res|medium-res|low-res)'] = 'help_controller/local_video/$1/$2';

$route['ajax/widgets/(:any)'] = 'widget_controller/ajax_$1';
$route['widgets/new_message_count/(:num)'] = 'widget_controller/new_message_count/$1';
$route['widgets/send_patient_document/(:any)'] = 'widget_controller/send_patient_document/$1';
$route['widgets/(:any)'] = 'widget_controller/$1';


/* INBOX ROUTES */

/* Attachments */
$route['inbox/attach'] = 'mailbox/attachment_controller/attach/$1';
$route['inbox/attachment/(:any)/description'] = 'mailbox/attachment_controller/ajax_attachment_description/$1';
$route['inbox/imgdisp/(:num)/(.+)'] = 'mailbox/attachment_controller/imgdisp/$1/$2';
$route['inbox/imgdisp/(:num)/(:any)/(.+)'] = 'mailbox/attachment_controller/imgdisp/$1/$2/$3';
$route['inbox/(clear_attachment)/(:any)'] = 'mailbox/attachment_controller/$1/$2';
$route['inbox/compose/draft/(:num)/attachments/add'] = 'mailbox/attachment_controller/attach/$1';

// Attach a VA CCD
$route['inbox/compose/draft/(:num)/attach/patient_document'] = 'mailbox/attachment_controller/patient_id_form/$1';
$route['inbox/compose/draft/(:num)/attach/patient_document/(:any)'] = 'mailbox/attachment_controller/patient_id_form/$1/$2';

$route['inbox/compose/draft/attachments/download/format/(pdf)/(:any)/(:num)'] = 'mailbox/attachment_controller/download_as/$1/$2/0/$3';
$route['inbox/compose/draft/attachments/download/format/(pdf)/(:any)'] = 'mailbox/attachment_controller/download_as/$1/$2';
$route['inbox/compose/draft/attachments/download/(:any)'] = 'mailbox/attachment_controller/download/$1';
$route['inbox/compose/draft/attachments/view/inline/(:any)'] = 'mailbox/attachment_controller/view_inline/$1';
$route['inbox/compose/draft/attachments/view/(:any)'] = 'mailbox/attachment_controller/view/$1';
$route['inbox/compose/draft/attachments/(:any)'] = 'mailbox/attachment_controller/view/$1';
$route['inbox/message/(:num)/attachments/download/format/(pdf)/(:any)'] = 'mailbox/attachment_controller/download_as/$2/$3/$1';
$route['inbox/message/(:num)/attachments/download/format/(pdf)/(:any)/(:num)'] = 'mailbox/attachment_controller/download_as/$2/$3/$1/$4';
$route['inbox/message/(:num)/attachments/download/(:any)/(:any)'] = 'mailbox/attachment_controller/download/$2/$1/$3';
$route['inbox/message/(:num)/attachments/download/(:any)'] = 'mailbox/attachment_controller/download/$2/$1';
$route['inbox/message/(:num)/attachments/save_to_das/(:any)'] = 'mailbox/attachment_controller/save_to_das/$1/$2';
$route['inbox/message/(:num)/attachments/view/inline/(:any)'] = 'mailbox/attachment_controller/view/$2/$1';
$route['inbox/message/(:num)/attachments/view/(:any)'] = 'mailbox/attachment_controller/view_inline/$2/$1';
$route['inbox/message/(:num)/attachments/(:any)/(:any)'] = 'mailbox/attachment_controller/view/$2/$1/$3';
$route['inbox/message/(:num)/attachments/(:any)'] = 'mailbox/attachment_controller/view/$2/$1';

/* File Transfers */
/*
* File transfers removed. rdf 2/6/2019
if(ENABLE_FILE_TRANSFERS){
	$route['inbox/compose/draft/(:num)/file_transfer/add'] = 'mailbox/attachment_controller/ajax_add_file_transfer/$1';
	$route['inbox/compose/draft/(:num)/file_transfer/remove/(:num)'] = 'mailbox/attachment_controller/ajax_remove_file_transfer/$2';
}
*/

/* Distribution Lists */
$route['inbox/(edit_list|remove_list)/(:num)/(:any)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(edit_list|remove_list)/(:num)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(create_list|edit_distribution_list)/(:any)'] = 'mailbox/distribution_list_controller/$1/$2';
$route['inbox/(create_list|edit_distribution_list)'] = 'mailbox/distribution_list_controller/$1';

/* Flags */
$route['inbox/save_flag_message'] = 'mailbox/flag_controller/save_flag_message';

/* Folders */
$route['inbox/folder/new'] = 'mailbox/folder_controller/create';
$route['inbox/folder/(:num)/(change_parent|change_parent_form)'] = 'mailbox/folder_controller/$2/$1';
$route['inbox/folder/(:num)/(change_parent|change_parent_form)/(:any)'] = 'mailbox/folder_controller/$2/$1';
$route['inbox/(archive_folder|rename_folder)/(:any)'] = 'mailbox/folder_controller/$1/$2';
$route['inbox/(archive_folder|rename_folder)'] = 'mailbox/folder_controller/$1';
$route['inbox/rename_folder_form/(:num)'] = 'mailbox/folder_controller/rename_folder_form/$1';
$route['inbox/rename_folder_submit/(:num)'] = 'mailbox/folder_controller/rename_folder_submit/$1';

/* Messages */
$route['inbox/ajax_draft_save'] = 'mailbox/message_controller/ajax_draft_save';
$route['inbox/(archive|viewmsg)/(:num)'] = 'mailbox/message_controller/$1/$2';
$route['inbox/compose'] = 'mailbox/message_controller/compose';
$route['inbox/compose/(draft|forward|reply|replyall)'] = 'mailbox/message_controller/compose/$1';
$route['inbox/compose/(draft|forward|reply|replyall)/(:num)'] = 'mailbox/message_controller/compose/$1/$2';
$route['inbox/compose/draft/(:num)/purpose_of_disclosure'] = 'mailbox/message_controller/purpose_of_disclosure/$1';
$route['inbox/compose/draft/(:num)/discard'] = 'mailbox/message_controller/discard/$1';
$route['inbox/(mark_as_read|mark_as_unread)'] = 'mailbox/message_controller/$1';
$route['inbox/move/(move|move_hidden|inbox)'] = 'mailbox/message_controller/move/$1';

/* Workflow */
$route['inbox/assign_message_status/(:any)/(:num)/(.+)'] = 'mailbox/workflow_controller/assign_message_status/$1/$2';
$route['inbox/assign_message_status/(:any)/(:num)'] = 'mailbox/workflow_controller/assign_message_status/$1/$2';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(:num)/(.+)'] = 'mailbox/workflow_controller/$1/$2/$3';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(:num)'] = 'mailbox/workflow_controller/$1/$2/$3';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(:any)/(.+)'] = 'mailbox/workflow_controller/$1/$2';
$route['inbox/(assign_to_me|complete_message|reset_message_status)/(.+)'] = 'mailbox/workflow_controller/$1/$2';



/* tests */
#if(ENVIRONMENT == 'development'){
	$route['unit-tests'] = 'unit_test_controller/index';
#}

/* End of file routes.php */
/* Location: ./application/config/routes.php */
