<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_library('form_markup_generator/field_markup_generators/social_security_number');

/**
* @package vler
* @subpackage form-markup-generator
*/
class Patient_disclosure_markup_generator extends Field_group_markup_generator{
	protected $_type = 'patient_disclosure';
	
	protected $_field_templates = array('given_name' => array('type' => 'text_input', 'label_attributes' => array('class' => 'sr-only')),
										'family_name' => array('type' => 'text_input', 'label_attributes' => array('class' => 'sr-only')),
										'ssn' => array('type' => 'social_security_number', 'label_text' => 'Social Security Number', 'label_attributes' => array('class' => 'sr-only')),
										'purpose_of_disclosure' => array('type' => 'dropdown',
																		 'options' => array('TREATMENT' => 'Medical Treatment'), 
																		 'label_attributes' => array('class' => 'sr-only'))); 


	function set_required($value){
		//makes sure that the required value for this group applies to all of the fields in the group
		$this->_required = $value;
		if(isset($this->fields) && !empty($this->fields)){
			foreach($this->fields as $field_name => $field){
				$this->field($field_name)->required = $value;
			}
		}
		else{
			//if we don't have the fields yet, apply the required value to the field templates
			foreach($this->_field_templates as $field_name => $info){
				if(!is_array($info)) $info = array('type' => $info);
				$this->_field_templates[$field_name]['required'] = $value;
			}
		}
	}
	
	function has_value(){
		return ($this->field('given_name')->has_value() || $this->field('family_name')->has_value() || $this->field('ssn')->has_value()); //note that purpose_of_disclosure will always have a value	
	}
	
	function has_value_if_required(){
		//if any of the fields are filled out, all of them are required (with the exception of purpose_of_disclosure, which will always have a value)
		if($this->has_value()){														
			$this->field('given_name')->required = true;
			$this->field('family_name')->required = true;
			$this->field('ssn')->required = true;
			$this->field('purpose_of_disclosure')->required = true;
		}

		return parent::has_value_if_required();
	}
	
	function values_for_api(){
		$values = $this->values();
		if(empty($values)) return $values;
		
		$values['ssn'] = str_replace('-', '', $values['ssn']);
		$values['purpose'] = $values['purpose_of_disclosure'];
		unset($values['purpose_of_disclosure']);
		return $values;
	}
}