<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* Any changes to this library need to be made in both Webmail and the API.
* @package vler
* @subpackage libraries
*/

class CCDA_attachment extends Patient_document_attachment{

    protected $_schema = 'CCDA';
	protected static $_parser_class = 'CCDA';

	function xsl_path(){
		if(!isset($this->_xsl_path)){
			$xml = new DOMDocument;
			$xml->loadXml($this->binary_string);
			// get template ids to check document type
			$template_ids = $xml->getElementsByTagName('templateId');

			// loop through template ids and find which oids are present
			foreach($template_ids as $id) {
			    $template_id = $id->getAttribute('root');
                log_message('debug','Looking for XSL Template Id ' . $template_id);
				switch($template_id) {
					//C32
					case '2.16.840.1.113883.3.88.11.32.1':
					    log_message('debug','Template ID matches C32');
						$this->_xsl_path = 'xsl/CCD.xsl';
						break;
					//US Realm Code template, all C-CDAs must at LEAST have this per MU2
					case '2.16.840.1.113883.10.20.22.1.1':
                        log_message('debug','Template ID matches US');
						$this->_xsl_path = 'xsl/ccda/cda.xsl';
						break;
					//C-CDA document template
					case '2.16.840.1.113883.10.20.22.1.2':
                        log_message('debug','Template ID matches C-CDA');
						$this->_xsl_path = 'xsl/ccda/cda.xsl';
						break;
					//another type of C-CDA document template
					case '2.16.840.1.113883.10.20.22.1.2.2':
                        log_message('debug','Template ID matches Other');
						$this->_xsl_path = 'xsl/ccda/cda.xsl';
						break;
					default:
						break;
				}
				if (isset($this->_xsl_path)) {
				    break;
                }
			}
		}
		return $this->_xsl_path;
	}

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	/**
	* True if the given file is a CCDA file.
	*
	* @param string Name of the file
	* @param string Contents of the file
	* @return boolean
	*/
	public static function matches_file($name, $binary_string, $valid_xml = false){
		log_message('debug','Who called this CCDA(matches_file) ' . debug_backtrace()[1]['class'].':'.debug_backtrace()[1]['function']);
		if (!$valid_xml) {
			$matches_file = parent::matches_file($name, $binary_string);
			if(!$matches_file) return false;
			if(!validates_as('xml_string', $binary_string)) return false;
		}
		$validator = new Validator();
		return $validator->ccda_xml_string($binary_string, $valid_xml);
	}

}
