<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage libraries
*//** */


/**
* Extended to display backtraces for the db queries.
* Requires use of an extension of system/database/DB_driver.php to cache backtraces for the db queries.
*
* @package vler
* @subpackage libraries
*/
class VLER_Profiler extends CI_Profiler {
	
	var $_api_calls = array();
	
	protected $_available_sections = array( 'memory_usage',
											'benchmarks',
											'get',
											'post',
											'uri_string',
											'controller_info',
											'api_calls',
											'queries',
											'http_headers',
											'session_data',
											'config'
											);
	
	
	function _compile_api_calls(){
		//find the service calls
		$api_instances = array();
		foreach(get_object_vars($this->CI) as $name => $CI_object){
			if (is_object($CI_object) && is_a($CI_object, 'API')){
				$api_instances[$name] = $CI_object;
			}
		}
		
		$markup = '';
		foreach($api_instances as $name => $api_instance){
			if(empty($api_instance->profiler_log)) continue;
			$markup .= '<fieldset id="ci_profiler_controller_info" style="border:1px solid #007700;padding:6px 10px 10px 10px;margin:20px 0 20px 0;">';
			$markup .= '<legend style="color:#007700;">&nbsp;&nbsp;API CALLS &ndash; '.humanize($name).'&nbsp;&nbsp;CALLS: &ndash; '.count($api_instance->profiler_log).'</legend>';
			
			$markup .= '<table cellpadding="4" cellspacing="1" border="0" width="100%">';
#			$markup .= '<tr><th>'.implode('</th><th>', array_map('humanize', array_keys(first_element($api_instance->profiler_log)))).'</th></tr>';
			foreach($api_instance->profiler_log as $key =>$log_entry){
				
				//format the log entry data
				$log_entry['data'] = trim(strip_from_beginning('<div>', strip_from_end('</div>', trim(sprp($log_entry['data'], '')))));
				$log_entry['data'] = trim(strip_from_beginning('<pre>', strip_from_end('</pre>', $log_entry['data'])));
				$log_entry['data'] = trim(strip_from_beginning('<strong>[]</strong>', strip_from_end('<strong>[/]</strong>', $log_entry['data'])));
				$log_entry['data'] = strip_from_beginning('(', trim(strip_from_beginning('Array', strip_from_end(')', $log_entry['data']))));
				
				$markup .= '<tr>';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;">'.$log_entry['time'].'&nbsp;&nbsp;</td>';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;">'.$log_entry['http_status'].'&nbsp;&nbsp;</td>';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;">'.$log_entry['http_method'].'&nbsp;&nbsp;</td>';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;">'.$log_entry['url'].'&nbsp;&nbsp;</td>';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;"><pre>'.$log_entry['data'].'</pre></td>';
				$onclick = 'onclick="profiler_toggle(\'api_output_'.$key.'\', \'api_output_toggle_'.$key.'\')"';
				$markup .= '<td valign="top" style="color:#990000;font-weight:normal;background-color:#ddd;">'.$log_entry['format'].'<span id="api_output_toggle_'.$key.'" '.$onclick.'>&darr;</span></td>';
				$onclick = 'onclick="profiler_toggle(\'query_backtrace_'.$key.'\', \'query_toggle_'.$key.'\')"';
				$markup .= '<td id="query_toggle_'.$key.'" style="color:#990000;font-weight:normal;background-color:#ddd;" '.$onclick.' valign="top">&darr;</td>';
#				$markup .= '<td>'.implode('</td><td>', $log_entry).'</td></tr>';
				$markup .= '</tr>';
				
				if(array_key_exists('backtrace', $log_entry)){
					extract($log_entry['backtrace'], EXTR_SKIP);
					ob_start();
					echo '<tr id="query_backtrace_'.$key.'" style="display:none;" ><td></td><td colspan="5"><table cellpadding="4" cellspacing="1" border="0" width="100%">';
					require APPPATH.'views/errors/html/_backtrace.php';
					echo '</table></td></tr>';
					$markup .= ob_get_clean();
				}
				
				if(array_key_exists('output', $log_entry)){
					$markup .= '<tr id="api_output_'.$key.'" style="display:none;" ><td></td><td colspan="5"><code>'.$log_entry['output'].'</code></td></tr>';
				}	
				
			}
			$markup .= '</table>';
			$markup .= '</fieldset>';
		
		
		}
		return $markup;
	}
	
	//ovverrides parent to provide peak memory usage and some conversions between MB/GB/etc
	protected function _compile_memory_usage(){
		get_instance()->load->helper('number');
		
		$usage = memory_get_usage();
		$peak_usage = memory_get_peak_usage();
		$max_limit = strip_from_end('M', ini_get('memory_limit')) * 1024 * 1024;
		
		return "\n\n"
			.'<fieldset id="ci_profiler_memory_usage" style="border:1px solid #5a0099;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee;">'
			."\n"
			.'<legend style="color:#5a0099;">&nbsp;&nbsp;'.$this->CI->lang->line('profiler_memory_usage')."&nbsp;&nbsp;</legend>\n"
			.'<div style="color:#5a0099;font-weight:normal;padding:4px 0 4px 0;">'
			.'<table>'
			.'<tr><td style="padding:5px;font-weight:bold;">Current&nbsp;&nbsp;</td>'
			.'<td style="padding:5px;font-weight:normal;">'.(!empty($usage) ? number_format($usage).' bytes' : $this->CI->lang->line('profiler_no_memory')).' </td>'
			.'<td style="padding:5px;;font-weight:normal;">'.(!empty($usage) ? (byte_format($usage)) : '').'</td>'
			.'<td style="padding:5px;;font-weight:normal;">'.round(100 * ($usage/$max_limit)).'%</td></tr>'
			.'<tr><td style="padding:5px;font-weight:bold;">Peak&nbsp;&nbsp;</td>'
			.'<td style="padding:5px;font-weight:normal;">'.(!empty($peak_usage) ? number_format($peak_usage).' bytes' : $this->CI->lang->line('profiler_no_memory')).' </td>'
			.'<td style="padding:5px;;font-weight:normal;">'.(!empty($peak_usage) ? (byte_format($peak_usage)) : '').'</td>'	
			.'<td style="padding:5px;;font-weight:normal;">'.round(100 * ($peak_usage/$max_limit)).'%</td></tr>'
			.'<tr><td style="padding:5px;font-weight:bold;">Memory Limit&nbsp;&nbsp;</td>'
			.'<td style="padding:5px;font-weight:normal;">'.number_format($max_limit).' bytes'.' </td>'
			.'<td style="padding:5px;;font-weight:normal;">'.byte_format($max_limit).'</td><td></td></tr>'							
/*			.'<tr><td style="padding:5px;width:50%;font-weight:bold;">Peak Usage&nbsp;&nbsp;</td>'
			.'<td style="padding:5px;width:25%;font-weight:normal;">'.!empty($peak_usage) ? number_format($peak_usage).' bytes' : $this->CI->lang->line('profiler_no_memory').' </td>'
			.'<td style="padding:5px;width:25%;font-weight:normal;">'.!empty($peak_usage) ? byte_format($peak_usage) : $this->CI->lang->line('profiler_no_memory').'</td></tr>' */
			.'</table>'
			.'</div></fieldset>';
	}	
	
	
	/**
	 * Compile Queries
	 *
	 * @return	string
	 */	
	function _compile_queries()
	{
		$dbs = array();

		// Let's determine which databases are currently connected to
		foreach (get_object_vars($this->CI) as $CI_object)
		{
			if (is_object($CI_object) && is_subclass_of(get_class($CI_object), 'CI_DB') )
			{
				$dbs[] = $CI_object;
			}
		}
					
		if (count($dbs) == 0)
		{
			$output  = "\n\n";
			$output .= '<fieldset style="border:1px solid #0000FF;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
			$output .= "\n";
			$output .= '<legend style="color:#0000FF;">&nbsp;&nbsp;'.$this->CI->lang->line('profiler_queries').'&nbsp;&nbsp;</legend>';
			$output .= "\n";		
			$output .= "\n\n<table cellpadding='4' cellspacing='1' border='0' width='100%'>\n";
			$output .="<tr><td width='100%' style='color:#0000FF;font-weight:normal;background-color:#eee;'>".$this->CI->lang->line('profiler_no_db')."</td></tr>\n";
			$output .= "</table>\n";
			$output .= "</fieldset>";
			
			return $output;
		}
		
		// Load the text helper so we can highlight the SQL
		$this->CI->load->helper('text');

		// Key words we want bolded
		$highlight = array('SELECT', 'DISTINCT', 'FROM', 'WHERE', 'AND', 'LEFT&nbsp;JOIN', 'ORDER&nbsp;BY', 'GROUP&nbsp;BY', 'LIMIT', 'INSERT', 'INTO', 'VALUES', 'UPDATE', 'OR', 'HAVING', 'OFFSET', 'NOT&nbsp;IN', 'IN', 'LIKE', 'NOT&nbsp;LIKE', 'COUNT', 'MAX', 'MIN', 'ON', 'AS', 'AVG', 'SUM', '(', ')');

		$output  = "\n\n";
			
		foreach ($dbs as $db){			
		
			$output .= '<fieldset style="border:1px solid #0000FF;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
			$output .= "\n";
			$output .= '<legend style="color:#0000FF;">&nbsp;&nbsp;'.$this->CI->lang->line('profiler_database').':&nbsp; '.$db->database.'&nbsp;&nbsp;&nbsp;'.$this->CI->lang->line('profiler_queries').': '.count($db->queries).'&nbsp;&nbsp;&nbsp;</legend>';
			$output .= "\n";		
			$output .= "\n\n<table cellpadding='4' cellspacing='1' border='0' width='100%'>\n";
		
			if (count($db->queries) == 0)
			{
				$output .= "<tr><td width='100%' style='color:#0000FF;font-weight:normal;background-color:#eee;'>".$this->CI->lang->line('profiler_no_queries')."</td></tr>\n";
			}
			else
			{	
				$output .= '<script type="text/javascript">
<!--
    function profiler_toggle(tr_id, toggle_id) {
       var tr = document.getElementById(tr_id);
	   var toggle = document.getElementById(toggle_id);			 

       if(tr.style.display == \'table-row\'){
          tr.style.display = \'none\';
					toggle.innerHTML = \'&darr;\';
			 }
       else{
          tr.style.display = \'table-row\';
					toggle.innerHTML = \'&uarr;\';
			 }
    }
//-->
</script>
';
				foreach ($db->queries as $key => $val){					
					$time = number_format($db->query_times[$key], 4);
					$val = highlight_code($val, ENT_QUOTES);				
						
					foreach ($highlight as $bold){
						$val = str_replace($bold, '<strong>'.$bold.'</strong>', $val);	
					}
					
					$td_style = 'color:#990000;font-weight:normal;background-color:#ddd;';					
					$output .= "<tr><td width='1%' valign='top' style='".$td_style."'>".$time."&nbsp;&nbsp;</td>";
	
					
					if(!empty($db->queries_backtrace[$key]['file']) && !empty($db->queries_backtrace[$key]['short_file']) && !empty($db->queries_backtrace[$key]['line'])){
						$onclick = 'onclick="profiler_toggle(\''.$db->database.'_query_backtrace_'.$key.'\', \'query_toggle_'.$key.'\')"';
						$output .= '<td id="query_toggle_'.$key.'" style="'.$td_style.'" '.$onclick.' valign="top">&darr;</td>';
					}else{
						$output .= '<td style="'.$td_style.'">&nbsp;</td>';
					}
					
				
					$output .= "<td style='color:#000;font-weight:normal;background-color:#ddd;'>".$val."</td>";	
					if(!empty($db->queries_backtrace[$key]['file']) && !empty($db->queries_backtrace[$key]['short_file']) && !empty($db->queries_backtrace[$key]['line'])){
						$output .= "<td style='".$td_style."'>".$db->queries_backtrace[$key]['function']."()</td>";
						$output .= "<td style='".$td_style."'><a title=\"".$db->queries_backtrace[$key]['file']."\" ".$onclick.">".$db->queries_backtrace[$key]['short_file']." :".$db->queries_backtrace[$key]['line']."</a></td>";
						$output .= '<td id="query_toggle_'.$key.'" style="'.$td_style.'" '.$onclick.'>&darr;</td>';
					}else{
						$output .= str_repeat('<td style="'.$td_style.'">&nbsp;</td>', 3);
					}
					$output .= "</tr>\n";
					
					if(property_exists($db, 'queries_backtrace') && !empty($db->queries_backtrace) && array_key_exists($key, $db->queries_backtrace)){
						$backtrace = $db->queries_backtrace[$key]['backtrace'];
						
						ob_start();
						echo '<tr id="'.$db->database.'_query_backtrace_'.$key.'" style="display:none;" ><td></td><td colspan="4"><table cellpadding="4" cellspacing="1" border="0" width="100%">';
						require APPPATH.'views/errors/html/_backtrace.php';
						echo '</table></td></tr>';
						$output .= ob_get_clean();
					}
				}
			}
			
			$output .= "</table>\n";
			$output .= "</fieldset>";
			
		}
		
		return $output;
	}

}

// END CI_Profiler class

/* End of file Profiler.php */
/* Location: ./system/libraries/Profiler.php */