<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage libraries
*/

/**
* VLER Direct extension of the CodeIgniter encryption library.
*
* Any changes to this library need to be made in both Webmail and the API.
*
* @package vler
* @subpackage libraries
*/
class VLER_Encrypt extends CI_Encrypt {

	/** Overrides parent in order to use sha256 encryption instead of md5. */
	public function get_key($key = '')
	{
		if ($key === '')
		{
			if ($this->encryption_key !== '')
			{
				return $this->encryption_key;
			}

			$key = config_item('encryption_key');

			if ( ! strlen($key))
			{
				show_error('In order to use the encryption class requires that you set an encryption key in your config file.');
			}
		}

		return hash('sha256',$key,true);
	}
	
	/** 
	* Public wrapper for protected method
	* @param	string	$data
	* @param	string	$key
	* @return	string
	*/
	public function remove_cipher_noise($data, $key){
		return $this->_remove_cipher_noise($data, $key);
	}

	public function ssha256_encode($text) {
		$salt = hash('sha256', openssl_random_pseudo_bytes(32));
		$hash = "{SSHA256}".base64_encode(pack("H*",hash('sha256',$text.$salt)).$salt);
		return $hash;
	}
	
	
}