<?php

if (! defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 *
 * @package vler
 * @subpackage libraries
 */
/**
 */

/**
 *
 * @package vler
 * @subpackage libraries
 */
class VLER_Email extends CI_Email
{

    // vars for VLER config - as long as we have standard values, might as well set them here
    var $smtp_host = GATEWAY_SMTP_HOSTNAME;

    var $smtp_port = GATEWAY_SMTP_PORT;

    var $protocol = DIRECT_SEND_PROTOCOL;

    var $smtp_timeout = GATEWAY_SMTP_TIMEOUT;

    // override default encoding in CI with quoted-printable to support S/MIME transfer encoding
    var $_encoding = "quoted-printable";

    var $_bit_depths = array(
        '7bit',
        '8bit',
        'quoted-printable'
    );

    var $newline = "\r\n";
 // Default newline. "\r\n" or "\n" (Use "\r\n" to comply with RFC 822)
                           // Once again, let's comply with the RFC.
    var $crlf = "\r\n";
 // CI has found \n to be the most compatible, but we've found it to be buggy.
                        // We're going with \r\n because it's easier to enforce the standard among our partners than to anticipate all possible variations.
    
    /**
     * Overrides parent to ignore CI's magic quotes check
     *
     * @todo Is this actually a check that we want to strip out?
     */
    public function message($body)
    {
        $this->_body = rtrim(str_replace("\r", '', $body));
        return $this;
    }

    // --------------------------------------------------------------------
    
    /**
     * Added to assign string attachments.
     *
     * @param
     *            string
     * @return void
     */
    public function string_attach($str_file, $filename, $mime = null, $disposition = 'attachment')
    {
        if (empty($mime))
            $mime = $this->_mime_types(pathinfo($filename, PATHINFO_EXTENSION));
        if (empty($mime))
            return get_instance()->error->should_be_a_filename_with_a_recognizable_mime_path($filename);
        return $this->attach($str_file, $disposition, $filename, $mime);
    }

    // --------------------------------------------------------------------
    
    /**
     * Overrides parent to allow for string attachments & provide a case for sending MDNs (message receipts)
     *
     * @todo It would probably be better for MDN code to be in a child library, so that there's no chance they'll be accidentally sent from the standard library if someone forgets to
     *       clear() the variables.
     */
    protected function _build_message()
    {
        if ($this->wordwrap === TRUE && mb_strtolower($this->mailtype) != 'html') {
            $this->_body = $this->word_wrap($this->_body);
        }
        
        $this->_set_boundaries();
        $this->_write_headers();
        
        $hdr = ($this->_get_protocol() === 'mail') ? $this->newline : '';
        $body = '';
        
        switch ($this->_get_content_type()) {
            case 'plain':
                
                $hdr .= 'Content-Type: text/plain; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: ' . $this->_get_encoding();
                
                /* START CHANGES TO PARENT VERSION */
                $body = $this->_body;
                if ($this->_get_encoding() === 'quoted-printable')
                    $body = $this->_prep_quoted_printable($this->_body);
                
                if ($this->_get_protocol() === 'mail') {
                    $this->_header_str .= $hdr;
                    $this->_finalbody = $body;
                } else {
                    $this->_finalbody = $hdr . $this->newline . $this->newline . $body;
                }
                /* END MODIFICATIONS TO PARENT VERSION */
                return;
            
            case 'html':
                
                if ($this->send_multipart === FALSE) {
                    $hdr .= 'Content-Type: text/html; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: quoted-printable';
                } else {
                    $hdr .= 'Content-Type: multipart/alternative; boundary="' . $this->_alt_boundary . '"';
                    
                    $body .= $this->_get_mime_message() . $this->newline . $this->newline . '--' . $this->_alt_boundary . $this->newline . 
                    'Content-Type: text/plain; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: ' . $this->_get_encoding() . $this->newline . $this->newline . $this->_get_alt_message() . $this->newline . $this->newline . '--' . $this->_alt_boundary . $this->newline . 
                    'Content-Type: text/html; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: quoted-printable' . $this->newline . $this->newline;
                }
                
                $this->_finalbody = $body . $this->_prep_quoted_printable($this->_body) . $this->newline . $this->newline;
                
                if ($this->_get_protocol() === 'mail') {
                    $this->_header_str .= $hdr;
                } else {
                    $this->_finalbody = $hdr . $this->newline . $this->newline . $this->_finalbody;
                }
                
                if ($this->send_multipart !== FALSE) {
                    $this->_finalbody .= '--' . $this->_alt_boundary . '--';
                }
                
                return;
            
            case 'plain-attach':
                
                $hdr .= 'Content-Type: multipart/' . $this->multipart . '; boundary="' . $this->_atc_boundary . '"';
                
                if ($this->_get_protocol() === 'mail') {
                    $this->_header_str .= $hdr;
                }
                
                $body .= $this->_get_mime_message() . $this->newline . $this->newline . '--' . $this->_atc_boundary . $this->newline . 'Content-Type: text/plain; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: ' . $this->_get_encoding() . $this->newline . $this->newline;
                
                /**
                 * BEGIN CHANGES TO PARENT
                 */
                if ($this->_get_encoding() == 'quoted-printable') {
                    $body .= $this->_prep_quoted_printable($this->_body) . $this->newline . $this->newline;
                } else {
                    $body .= $this->_body . $this->newline . $this->newline;
                }
                /**
                 * END CHANGES TO PARENT
                 */
                break;
            case 'html-attach':
                
                $hdr .= 'Content-Type: multipart/' . $this->multipart . '; boundary="' . $this->_atc_boundary . '"';
                
                if ($this->_get_protocol() === 'mail') {
                    $this->_header_str .= $hdr;
                }
                
                $body .= $this->_get_mime_message() . $this->newline . $this->newline . '--' . $this->_atc_boundary . $this->newline . 
                'Content-Type: multipart/alternative; boundary="' . $this->_alt_boundary . '"' . $this->newline . $this->newline . '--' . $this->_alt_boundary . $this->newline . 
                'Content-Type: text/plain; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: ' . $this->_get_encoding() . $this->newline . $this->newline . $this->_get_alt_message() . $this->newline . $this->newline . '--' . $this->_alt_boundary . $this->newline . 
                'Content-Type: text/html; charset=' . $this->charset . $this->newline . 'Content-Transfer-Encoding: quoted-printable' . $this->newline . $this->newline . 
                $this->_prep_quoted_printable($this->_body) . $this->newline . $this->newline . '--' . $this->_alt_boundary . '--' . $this->newline . $this->newline;
                
                break;
        }
        
        $attachment = array();
        for ($i = 0, $c = count($this->_attachments), $z = 0; $i < $c; $i ++) {
            $filename = $this->_attachments[$i]['name'][0];
            $basename = ($this->_attachments[$i]['name'][1] === NULL) ? basename($filename) : $this->_attachments[$i]['name'][1];
            $attachment[$z ++] = '--' . $this->_atc_boundary . $this->newline 
            . 'Content-type: ' . $this->_attachments[$i]['type'] . '; ' . 'name="' . $basename . '"' . $this->newline 
            . 'Content-Length: ' . string_length_in_bytes($this->_attachments[$i]['content']) . $this->newline 
            . 'Content-Disposition: ' . $this->_attachments[$i]['disposition'] . ';' . $this->newline 
            . 'Content-Transfer-Encoding: base64' . $this->newline . (empty($this->_attachments[$i]['cid']) ? '' : 'Content-ID: <' . $this->_attachments[$i]['cid'] . '>' . $this->newline);
            // Strips out the carriage return/line-feeds from the ends of the BASE64 encoded attachment.
            $attachment[$z ++] = str_replace('\r\n','',$this->_attachments[$i]['content']);
        }
        
        $body .= implode($this->newline, $attachment) . $this->newline . '--' . $this->_atc_boundary . '--';
        $this->_finalbody = ($this->_get_protocol() === 'mail') ? $body : $hdr . $this->newline . $this->newline . $body;
        
        return TRUE;
    }

    // --------------------------------------------------------------------
    
    // Overrides parent to use _prep_quoted_printable instead of word_wrap if we're using quoted-printable encoding on this message
    // Both methods will wrap the text, but the quoted printable method will include an indicator that the text was not originally wrapped so that it won't be displayed that way
    protected function _get_alt_message()
    {
        if (! empty($this->alt_message)) {
            /* START CHANGES TO PARENT METHOD */
            if ($this->_get_encoding() == 'quoted-printable')
                return $this->_prep_quoted_printable($this->alt_message, 76);
            /* END CHANGES TO PARENT METHOD */
            return ($this->wordwrap) ? $this->word_wrap($this->alt_message, 76) : $this->alt_message;
        }
        
        $body = preg_match('/\<body.*?\>(.*)\<\/body\>/si', $this->_body, $match) ? $match[1] : $this->_body;
        
        /* START CHANGES TO PARENT METHOD */
        // BEFORE STRIP TAGS, CONVERT NEW LINE TAGS TO NEW LINES
        
        // remove any vertical space before or after a <br> tag, and then replace the <br> with single new line
        $body = preg_replace('/\v*\<br[^>]*>\v*/i', $this->newline, $body);
        
        // remove any vertical space before or after a </div> tag, and then replace the </div> with single new line.
        // doing this only for closing tags because we only want one new line per div
        $body = preg_replace('/\v*\<\/div[^>]*\>\v*/i', $this->newline, $body);
        
        // remove any vertical space before or after a <p> or </p> tag, and then replace the <p> or </p> tag with a new line.
        // we want two new lines per paragraph- not sure if this is the right way to do this, really, but we'll give it a shot.
        $body = preg_replace('/\v*\<\/?p[^>]*\>\v*/i', $this->newline . $this->newline, $body);
        /* END CHANGES TO PARENT METHOD */
        
        $body = str_replace("\t", '', preg_replace('#<!--(.*)--\>#', '', trim(strip_tags($body))));
        
        for ($i = 20; $i >= 3; $i --) {
            $body = str_replace(str_repeat("\n", $i), "\n\n", $body);
        }
        
        // Reduce multiple spaces
        $body = preg_replace('| +|', ' ', $body);
        
        /* START CHANGES TO PARENT METHOD */
        if ($this->_get_encoding() == 'quoted-printable')
            return $this->_prep_quoted_printable($body, '76');
        /* END CHANGES TO PARENT METHOD */
        
        return ($this->wordwrap) ? $this->word_wrap($body, 76) : $body;
    }

    /**
     * Overrides parent to use multibyte-safe string methods
     */
    public function word_wrap($str, $charlim = '')
    {
        
        // Set the character limit
        if ($charlim == '') {
            $charlim = ($this->wrapchars == "") ? "76" : $this->wrapchars;
        }
        
        // Reduce multiple spaces
        $str = preg_replace("| +|", " ", $str);
        
        // Standardize newlines
        if (mb_strpos($str, "\r") !== FALSE) {
            $str = str_replace(array(
                "\r\n",
                "\r"
            ), "\n", $str);
        }
        
        // If the current word is surrounded by {unwrap} tags we'll
        // strip the entire chunk and replace it with a marker.
        $unwrap = array();
        if (preg_match_all("|(\{unwrap\}.+?\{/unwrap\})|s", $str, $matches)) {
            for ($i = 0; $i < count($matches['0']); $i ++) {
                $unwrap[] = $matches['1'][$i];
                $str = str_replace($matches['1'][$i], "{{unwrapped" . $i . "}}", $str);
            }
        }
        
        // Use PHP's native public function to do the initial wordwrap.
        // We set the cut flag to FALSE so that any individual words that are
        // too long get left alone. In the next step we'll deal with them.
        $str = mb_wordwrap($str, $charlim, "\n", FALSE);
        
        // Split the string into individual lines of text and cycle through them
        $output = "";
        foreach (explode("\n", $str) as $line) {
            // Is the line within the allowed character count?
            // If so we'll join it to the output and continue
            if (mb_strlen($line) <= $charlim) {
                $output .= $line . $this->newline;
                continue;
            }
            
            $temp = '';
            
            while ((mb_strlen($temp) + mb_strlen($line)) > $charlim) {
                if (mb_strlen($temp) >= ($charlim - 1)) {
                    $output .= $temp . $this->newline;
                    $temp = '';
                }
                
                // If the over-length word is a URL we won't wrap it
                if (preg_match("!\[url.+\]|://|wwww.!", $line)) {
                    break;
                }
                
                // Trim the word down
                $temp .= mb_substr($line, 0, $charlim - 1);
                $line = mb_substr($line, $charlim - 1);
            }
            
            // If $temp contains data it means we had to split up an over-length
            // word into smaller chunks so we'll add it back to our current line
            if (! empty($temp)) {
                $output .= $temp . $this->newline . $line;
            } else {
                $output .= $line;
            }
            
            $output .= $this->newline;
        }
        
        // Put our markers back
        if (count($unwrap) > 0) {
            foreach ($unwrap as $key => $val) {
                $output = str_replace("{{unwrapped" . $key . "}}", $val, $output);
            }
        }
        
        return $output;
    }

    /**
     * Overrides parent to be safe with multibyte strings.
     * The CI version of this method tries to iterate through the characters of a string,
     * but they don't do so in a way that's safe for UTF-8 strings.
     */
    protected function _prep_quoted_printable($str)
    {
        // We are intentionally wrapping so mail servers will encode characters
        // properly and MUAs will behave, so {unwrap} must go!
        $str = str_replace(array(
            '{unwrap}',
            '{/unwrap}'
        ), '', $str);
        
        // RFC 2045 specifies CRLF as "\r\n".
        // However, many developers choose to override that and violate
        // the RFC rules due to (apparently) a bug in MS Exchange,
        // which only works with "\n".
        if ($this->crlf === "\r\n") {
            if (is_php('5.3')) {
                return quoted_printable_encode($str);
            } elseif (function_exists('imap_8bit')) {
                return imap_8bit($str);
            }
        }
        
        // Reduce multiple spaces & remove nulls
        $str = preg_replace(array(
            '| +|',
            '/\x00+/'
        ), array(
            ' ',
            ''
        ), $str);
        
        // Standardize newlines
        if (string_contains("\r", $str)) {
            $str = str_replace(array(
                "\r\n",
                "\r"
            ), "\n", $str);
        }
        
        // Break into an array of lines
        $lines = explode("\n", $str);
        
        $escape = '=';
        $output = '';
        /* START CHANGES FROM PARENT */
        foreach ($lines as $line) {
            $processed_line = '';
            
            $characters = preg_split('/(?<!^)(?!$)/u', $line);
            
            foreach ($characters as $i => $char) {
                $ascii = mb_ord($char); // for multibyte chars, this will be the UTF-32 decimal value
                                        // Convert spaces and tabs but only if it's the end of the line
                if ($i == array_last_key($characters) && ($ascii == '32' or $ascii == '9')) {
                    $char = $escape . sprintf('%02s', dechex($ascii));
                }
                
                // encode = signs
                if ($ascii == '61') {
                    $char = $escape . mb_strtoupper(sprintf('%02s', dechex($ascii))); // =3D
                }
                
                // encode non-US-ASCII characters
                if (intval($ascii) >= 128) {
                    $char = quoted_printable_encode($char);
                }
                
                // If we're at the character limit, add the line to the output, reset our temp variable, and keep on chuggin'
                if ((mb_strlen($processed_line) + mb_strlen($char)) >= $charlim) {
                    $output .= $processed_line . $escape . $this->crlf;
                    $processed_line = '';
                }
                
                $processed_line .= $char;
            }
            
            $output .= $processed_line . $this->crlf;
        }
        
        // get rid of extra CRLF tacked onto the end
        $output = strip_from_end($this->crlf, $output);
        /* END CHANGES FROM PARENT */
        
        return $output;
    }

    public function send($auto_clear = FALSE)
    {
        $success = parent::send($auto_clear);
        if (! $success && ! empty($this->_debug_msg)) {
            get_instance()->error->warning(implode_nonempty("\r\n ", $this->_debug_msg));
        }
        return $success;
    }

    /**
     * Overrides parent to use multibyte-safe string functions
     * Also, the original override commented out the starttls case.
     * Not sure why it was necessary to comment this out instead of just not using the starttls case.
     */
    protected function _send_command($cmd, $data = '')
    {
        switch ($cmd) {
            case 'hello':
                
                if ($this->_smtp_auth or $this->_get_encoding() === '8bit') {
                    $this->_send_data('EHLO ' . $this->_get_hostname());
                } else {
                    $this->_send_data('HELO ' . $this->_get_hostname());
                }
                
                $resp = 250;
                break;
            
            /*
             * case 'starttls' :
             * $this->_send_data('STARTTLS');
             *
             * $resp = 220;
             * break;
             */
            case 'from':
                
                $this->_send_data('MAIL FROM:<' . $data . '>');
                $resp = 250;
                break;
            case 'to':
                
                if ($this->dsn) {
                    $this->_send_data('RCPT TO:<' . $data . '> NOTIFY=SUCCESS,DELAY,FAILURE ORCPT=rfc822;' . $data);
                } else {
                    $this->_send_data('RCPT TO:<' . $data . '>');
                }
                
                $resp = 250;
                break;
            case 'data':
                
                $this->_send_data('DATA');
                $resp = 354;
                break;
            case 'reset':
                
                $this->_send_data('RSET');
                $resp = 250;
                break;
            case 'quit':
                
                $this->_send_data('QUIT');
                $resp = 221;
                break;
        }
        
        $reply = $this->_get_smtp_data();
        
        $this->_debug_msg[] = '<pre>' . $cmd . ': ' . $reply . '</pre>';
        
        if ((int) substr($reply, 0, 3) !== $resp) {
            $this->_set_error_message('lang:email_smtp_error', $reply);
            return FALSE;
        }
        
        if ($cmd === 'quit') {
            fclose($this->_smtp_connect);
        }
        
        return TRUE;
    }

    /**
     * Overrides parent to use multibyte-safe string functions
     */
    protected function _get_smtp_data()
    {
        $data = '';
        
        while ($str = fgets($this->_smtp_connect, 512)) {
            $data .= $str;
            
            if (mb_substr($str, 3, 1) == ' ') {
                break;
            }
        }
        
        return $data;
    }
}