<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package icarus
* @subpackage core
*/

/**
* Extension to the router class which allows greater ability for dynamic urls.
*
* The Codeigniter routing system is already built with the idea that your url may contain matched name/value pairs that can be expressed as an associative array.  
* (See the {@link http://codeigniter.com/user_guide/libraries/uri.html documentation for uri_to_assoc()}.)  However, Codeigniter doesn't provide any flexibility
* for the possibility of a particular name/value pair only appearing sometimes in a URL -- if you want to allow for the possibility of 
* http://mysite.com/list_of_things and http://mysite.com/list_of_things/page/3 and http://mysite.com/list_of_things/page/3/order_by/name, you have to specify the 
* routes for each possible permutation.  (Or, y'know, just use normal query string var system.  But hush, you.  We're stubborn and these look cooler.)
* 
* This extension allows you to add the wildcard (:get) to the end of your route to allow for the possibility of a series of name/value pairs to be appended
* to the URL.  The information as to where the (:get) string starts will be passed to the {@link MY_URI} class, and you'll then be able to access the (:get) 
* name/value pairs as an associative array by calling {@link query_string_params} (nominations for a better name for this method are being taken now.).  
* If you don't access them, they'll be completely ignored by the system; if you do decide to access and use them, it is your responsibility to cleanse the values and
* use them responsibly.
*
* @author M. Gibbs <gibbs_margaret@bah.com>
* @package icarus
* @subpackage core
*/

class VLER_Router extends CI_Router {
	
	// --------------------------------------------------------------------

	//customizes parent to add (:get) wildcard to the route
    protected function _parse_routes()
    {
        // Turn the segment array into a URI string
        $uri = implode('/', $this->uri->segments);
 
        // Get HTTP verb
        $http_verb = isset($_SERVER['REQUEST_METHOD']) ? strtolower($_SERVER['REQUEST_METHOD']) : 'cli';
 
        // Is there a literal match?  If so we're done
        if (isset($this->routes[$uri]))
        {
            // Check default routes format
            if (is_string($this->routes[$uri]))
            {
                $this->_set_request(explode('/', $this->routes[$uri]));
                return;
            }
            // Is there a matching http verb?
            elseif (is_array($this->routes[$uri]) && isset($this->routes[$uri][$http_verb]))
            {
                $this->_set_request(explode('/', $this->routes[$uri][$http_verb]));
                return;
            }
        }
 
        // Loop through the route array looking for wildcards
        foreach ($this->routes as $key => $val)
        {
            // Check if route format is using http verb
            if (is_array($val))
            {
                if (isset($val[$http_verb]))
                {
                    $val = $val[$http_verb];
                }
                else
                {
                    continue;
                }
            }
 
            // Convert wildcards to RegEx
            $key = str_replace(array(':any', ':num'), array('[^/]+', '[0-9]+'), $key);
 
            // Does the RegEx match?
            if (preg_match('#^'.$key.'$#', $uri, $matches))
            {
                // Are we using callbacks to process back-references?
                if ( ! is_string($val) && is_callable($val))
                {
                    // Remove the original string from the matches array.
                    array_shift($matches);
 
                    // Execute the callback using the values in matches as its parameters.
                    $val = call_user_func_array($val, $matches);
                }
                // Are we using the default routing method for back-references?
                elseif (strpos($val, '$') !== FALSE && strpos($key, '(') !== FALSE)
                {
                    $val = preg_replace('#^'.$key.'$#', $val, $uri);
                }
 
                $this->_set_request(explode('/', $val));
                return;
            }
        }
 
 		//START VLER CUSTOMIZATION
 		if($this->_find_route_with_get_parameters($uri))
			return; 
		//END VLER CUSTOMIZATION
 
        // If we got this far it means we didn't encounter a
        // matching route so we'll set the site default route
        $this->_set_request(array_values($this->uri->segments));
    }
	
	
	//use krsort on routes to go backwards in specificity
	//check go see if it matches the URL up to a certain point
	//set the point and the params
	
	//alternatively, specifiy that they have to add the "get" wildcard
	//once they've added the "get" wildcard, we check to see how many callbacks there are in the URL and add another one for get?
	
	function _find_route_with_get_parameters($uri){
		$routes = $this->routes;
		krsort($routes);
		foreach($routes as $key => $val){
			if(strpos($key, '/(:get)') !== strlen($key) - strlen('/(:get)'))
				continue; //get needs to be the last item
			
			
			$this->uri->url_params_start = count(explode('/', $key));
			
			// Convert wild-cards to RegEx
			$key = str_replace(':any', '.+', str_replace(':num', '[0-9]+', str_replace('(:get)', '.*', $key)));
			// Does the RegEx match?
			if (preg_match('#^'.$key.'$#', $uri))
			{			
				// Do we have a back-reference?
				if (strpos($val, '$') !== FALSE AND strpos($key, '(') !== FALSE)
				{
					$val = preg_replace('#^'.$key.'$#', $val, $uri);
				}
			
				$this->_set_request(explode('/', $val));		
				return true; 
			}
		}
	}
}
// END Router Class

/* End of file Router.php */
/* Location: ./system/libraries/Router.php */