<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package vler
* @subpackage core
*//** */


/**
* DPII Input Class
*
* Extends the CodeIgniter class for pre-processing global input data for security. 
* Also allow GET, POST, SERVER, COOKIES, and request headers to run xss cleaning by default.
*
* @author		Adam Bell
* @author		Elan Jaffee
* @package vler
* @subpackage core
*/
class VLER_Input extends CI_Input {

	/**
	* Fetch an item from the GET array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function get($index = NULL, $xss_clean = TRUE)
	{
		return parent::get($index, $xss_clean);
	}

	// --------------------------------------------------------------------

	/**
	* Fetch an item from the POST array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function post($index = NULL, $xss_clean = TRUE){
		return parent::post($index, $xss_clean);
	}


	public function post_get($index, $xss_clean = TRUE){
		return parent::post_get($index, $xss_clean);
	}

	// --------------------------------------------------------------------

	/**
	* Fetch an item from either the GET array or the POST.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string	The index key
	* @param	bool	XSS cleaning
	* @return	string
	*/
	function get_post($index = '', $xss_clean = TRUE)
	{
		return parent::get_post($index, $xss_clean);
	}
	
	/**
	* Fetch an item from the COOKIE array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function cookie($index = '', $xss_clean = TRUE)
	{
		return parent::cookie($index, $xss_clean);
	}
	
	// --------------------------------------------------------------------

	/**
	* Fetch an item from the SERVER array.  Changed to set xss_clean to true by default
	*
	* @access	public
	* @param	string
	* @param	bool
	* @return	string
	*/
	function server($index = '', $xss_clean = TRUE){
		return parent::server($index, $xss_clean);
	}
	
	public function input_stream($index = NULL, $xss_clean = TRUE){
		return parent::input_stream($index, $xss_clean);	
	}
	
	// --------------------------------------------------------------------

	/**
	 * Request Headers
	 *
	 * In Apache, you can simply call apache_request_headers(), however for
	 * people running other webservers the function is undefined.  Changed to set xss_clean to true by default
	 *
	 * @param	bool XSS cleaning
	 *
	 * @return array
	 */
	public function request_headers($xss_clean = TRUE){
		return parent::request_headers($xss_clean);
	}
	
	public function user_agent($xss_clean = TRUE){
		return parent::user_agent($xss_clean);
	}
	
	public function get_request_header($index, $xss_clean = TRUE){
		return parent::get_request_header($index, $xss_clean);
	}
	
	//this is an exact copy of the 3.0 code EXCEPT that we've moved a CSRF check into its own function so that our application can override it on their own. -- MG 2015/05/26
	protected function _sanitize_globals(){
		// Is $_GET data allowed? If not we'll set the $_GET to an empty array
		if ($this->_allow_get_array === FALSE)
		{
			$_GET = array();
		}
		elseif (is_array($_GET) && count($_GET) > 0)
		{
			foreach ($_GET as $key => $val)
			{
				$_GET[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
			}
		}

		// Clean $_POST Data
		if (is_array($_POST) && count($_POST) > 0)
		{
			foreach ($_POST as $key => $val)
			{
				$_POST[$this->_clean_input_keys($key)] = $this->_clean_input_data($val);
			}
		}

		// Clean $_COOKIE Data
		if (is_array($_COOKIE) && count($_COOKIE) > 0)
		{
			// Also get rid of specially treated cookies that might be set by a server
			// or silly application, that are of no use to a CI application anyway
			// but that when present will trip our 'Disallowed Key Characters' alarm
			// http://www.ietf.org/rfc/rfc2109.txt
			// note that the key names below are single quoted strings, and are not PHP variables
			unset(
				$_COOKIE['$Version'],
				$_COOKIE['$Path'],
				$_COOKIE['$Domain']
			);

			foreach ($_COOKIE as $key => $val)
			{
				if (($cookie_key = $this->_clean_input_keys($key)) !== FALSE)
				{
					$_COOKIE[$cookie_key] = $this->_clean_input_data($val);
				}
				else
				{
					unset($_COOKIE[$key]);
				}
			}
		}

		// Sanitize PHP_SELF
		$_SERVER['PHP_SELF'] = strip_tags($_SERVER['PHP_SELF']);

		$this->_verify_csrf_for_http_requests();

		log_message('debug', 'Global POST, GET and COOKIE data sanitized');
	}	
	
	//functionality from _sanitize_globals, separated out so that the API can override it
	protected function _verify_csrf_for_http_requests(){
		// CSRF Protection check on HTTP requests
		if ($this->_enable_csrf == TRUE && !is_cli())
		{
			$this->security->csrf_verify();
		}
	}

}