<?php 

//todo - conditional comment advising better browser if under IE11
//todo - sub nav
//todo - page subheader
//todo - better responsive widths for nav + subnav, icon in header
//todo - swap colors for info and warning
//todo - why is form markup generator so slow?
//todo - menu

if(empty($human_readable_domain_name)) $human_readable_domain_name = PRODUCT_NAME;

if(empty($title)) $title = $human_readable_domain_name;
if(!isset($page_title)) $page_title = implode_nonempty(': ', array_map('humanize', array($CI->uri->segment(1), $CI->uri->segment(2)))); //pass an empty string if you don't want a page title for some reason

if(!empty($_SESSION['user_info']))
	$display_name = implode_nonempty(' ', array($_SESSION['user_info']['first_name'], $_SESSION['user_info']['last_name']));	


?><!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta http-equiv="x-ua-compatible" content="ie=edge">
		<title><?php echo $title ?></title>
		<meta name="description" content="An application for secure health messaging.">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="/css/bootstrap.min.css?v=<?php echo APPLICATION_BUILD_VERSION;?>">
		<link rel="stylesheet" href="/css/template.css?v=<?php echo APPLICATION_BUILD_VERSION;?>">
	</head>
	<body class="controller-<?php echo strip_from_end('-controller', make_string_css_friendly(get_class($CI))) ?> action-<?php echo make_string_css_friendly($CI->router->method) ?> container-fluid">
		<header>
			<div class="header-inner">
				<div class="banner">
					<h1 class="content-width"><?php echo $human_readable_domain_name ?></h1>
					<div class="content-width hidden-sm hidden-xs"><?php if(!empty($display_name)): ?><strong class="pull-right">Welcome, <?php echo $display_name ?></strong><?php endif ?></div>
				</div>
			</div>
			<?php if(!empty($nav_items)): ?>
			<nav class="navbar navbar-default content-width">
				<div class="container-fluid">
					<div class="navbar-header">
						<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="header .navbar-collapse" aria-expanded="false">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						</button>
					</div>			
					<div class="collapse navbar-collapse">
						<ul class="nav navbar-nav">
					<?php foreach($nav_items as $identifier => $nav_item): ?>
						<?php if(empty($nav_item['dropdown_items'])): ?>
							<li<?php if($nav_item['is_active']):?> class="active"<?php endif ?>>
								<?php echo link_to($nav_item['path'], $nav_item['link_text']); ?>
							</li>
						<?php else: ?>
							<li<?php if($nav_item['is_active']):?> class="active"<?php endif ?>>
								<?php echo link_to($nav_item['path'], $nav_item['link_text'], array('class' => 'dropdown-toggle', 
																									'data-toggle' => 'dropdown', 
																									'role' => 'button', 
																									'aria-haspopup' => 'true', 
																									'aria-expanded' => 'false')) ?>
								<ul class="dropdown-menu">
								<?php foreach($nav_item['dropdown_items'] as $dropdown_item_description => $dropdown_item_path): ?>
									<li><?php echo link_to($dropdown_item_path, $dropdown_item_description) ?></li>
								<?php endforeach ?>	
								</ul>
							</li>						
						<?php endif ?>
					<?php endforeach ?>
						</ul>
					</div>
				</div>
			</nav>
			<?php endif ?>
		</header> 
		<main class="content-width">
			<?php if(!empty($page_title)) echo tag('h2', $page_title) ?>
			<?php if(!empty($success_message)) echo dismissable_alert($success_message, 'success'); ?>
			<?php if(!empty($error_message)) echo dismissable_alert($error_message, 'danger'); ?>
			<?php if(!empty($subnav_items)): ?>
			<nav class="subnav">
				<ul class="nav nav-tabs">
				<?php foreach($subnav_items as $identifier => $nav_item): ?>
					<li role="presentation"<?php if($nav_item['is_active']):?> class="active"<?php endif ?>>
						<?php echo link_to($nav_item['path'], $nav_item['link_text']); ?>
					</li>				
				<?php endforeach ?>	
				</ul>
			</nav>
			<?php endif ?>					
			<div <?PHP if(!empty($subnav_items)) echo 'class="subnav-content"'; ?>>
				<?php echo $contents ?>
				<div style="clear: both"></div>
			</div>
		</main>
		<footer>
			<nav class="navbar navbar-default navbar-fixed-bottom">
				<div class="container-fluid content-width">
					<div class="navbar-header">
					<?php if(!empty($nav_items)): ?>
						<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="footer .navbar-collapse" aria-expanded="false">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						</button>
					<?php endif ?>
						 <a class="navbar-brand" href="<?php echo site_url() ?>"><?php echo $human_readable_domain_name ?></a>
					</div>
					<?php if(!empty($nav_items)): ?>
					<div class="collapse navbar-collapse">
						<ul class="nav navbar-nav pull-right">
						<?php foreach($nav_items as $identifier => $nav_item): ?>
							<li><?php echo link_to($nav_item['path'], $nav_item['link_text']); ?></li>
						<?php endforeach ?>						
						</ul>
					</div>
					<?php endif ?>
				</div>
			</nav>		
		</footer> 
		<script src="https://code.jquery.com/jquery-2.2.3.min.js?v=<?php echo APPLICATION_BUILD_VERSION;?>"></script>
		<script>window.jQuery || document.write('<script src="/js/jquery.min.js?v='.APPLICATION_BUILD_VERSION.'"><\/script>')</script>
		<script src="/js/bootstrap.min.js?v=<?php echo APPLICATION_BUILD_VERSION;?>"></script>
		<script src="/js/daas.js?v=<?php echo APPLICATION_BUILD_VERSION;?>"></script>
		<script>
			$( document ).ready(function() {
				if(typeof daas === 'object') daas._init();
			});
		</script>
	</body>
</html>