<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
<style>
pre {
    background: #f4f4f4;
    border: 1px solid #ddd;
    border-left: 3px solid #f36d33;
    color: #666;
    page-break-inside: avoid;
    font-family: monospace;
    font-size: 15px;
    line-height: 1.6;
    margin-bottom: 1.6em;
    max-width: 100%;
    overflow: auto;
    padding: 1em 1.5em;
    display: block;
    word-wrap: break-word;
}
</style>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; <a class="underline" href="/onboarding/validate">/direct/validate</a> - GET</h1>
				<p>The validate web service allows authorized applications to check if a Direct address is a trusted recipient and can be accessed by sending a GET request to /direct/validate. Below are some code examples for sending a message using the validate web service.</p>
				<h3>Java</h3>
				<p>
					<div style="border: 1px solid; padding: 10px; box-shadow: 5px 10px 18px #888888;">
					<pre><code>
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
 
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
 
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
 
import java.text.SimpleDateFormat;
 
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
 
 
public class VLERDirectTest {
 
    private String makeRequest(String urlloc) {
        String pubkey ="YOUR_PUBLIC_API_KEY";
        String prvkey ="YOUR_PRIVATE_API_KEY";
        String rtc = "";
        HttpURLConnection conn = null;
       
        try {
            System.out.println("urlloc>>"+urlloc+"<<");
            URL url = new URL(urlloc);
            conn = (HttpURLConnection)url.openConnection();
 
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String address = "swilliams@example.com";
	    String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
            String reqstr = "GET\n" + dstr + "\n/direct/validate/format/json?address=" + encaddr;
            System.out.println("reqest str>>" + reqstr + "<<");
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(prvkey.getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
 
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            System.out.println("encoded request str>>" + encsha + "<<");
            String auth = "DAAS " + pubkey + ":" + encsha;
            System.out.println("auth>>" + auth + "<<");
 
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("X-DaaS-Date", dstr);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestMethod("GET");
 
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
 
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
 
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
                System.err.println(output);
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
 
    public static void main(String[] args) {
        VLERDirectTest test = new VLERDirectTest();
        String address = "user@example.com";
	String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
		     System.out.println(test.makeRequest("https://'.API_DOMAIN .'/direct/validate/format/json?address=" + encaddr));
    }
 
}
</pre></code>
</div>

				</p>
				<p>&nbsp;</p>
				<h3>HTML and JavaScript</h3>
				<p>
					<div style="border: 1px solid; padding: 10px; box-shadow: 5px 10px 18px #888888;">
				<pre><code>
					<?php $str = <<<'EOD'
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>VLER Direct GET Sample</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.2.2/jquery.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/i18n/jquery-ui-i18n.js"></script>
    <script src="https://crypto-js.googlecode.com/svn/tags/3.0.2/build/rollups/hmac-sha256.js"></script>
    <script src="https://crypto-js.googlecode.com/svn/tags/3.0.2/build/components/enc-base64-min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.form/3.51/jquery.form.min.js"></script>
    <style>
        #success{
            display:none;
        }
        #error{
            display:none;
        }
    </style>
    <script type="text/javascript">
			var PUBLIC_API_KEY = "YOUR_PUBLIC_API_KEY";
			var PRIVATE_API_KEY = "YOUR_PRIVATE_API_KEY";
			var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

			//a function for base64 encoding an input string
			function encode64(input) {
			   if (!String(input).length) return false;
			   var output = "";
			   var chr1, chr2, chr3;
			   var enc1, enc2, enc3, enc4;
			   var i = 0;

			   do {
			      chr1 = input.charCodeAt(i++);
			      chr2 = input.charCodeAt(i++);
			      chr3 = input.charCodeAt(i++);

			      enc1 = chr1 >> 2;
			      enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			      enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			      enc4 = chr3 & 63;

			      if (isNaN(chr2)) {
			         enc3 = enc4 = 64;
			      } else if (isNaN(chr3)) {
			         enc4 = 64;
			      }

			      output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) +
			         keyStr.charAt(enc3) + keyStr.charAt(enc4);
			   } while (i < input.length);

			   return output;
			}

			$(function() {
				$(".json").click(function() {
					$("#sender").css("background-color","#fff");
					$("#to").css("background-color","#fff");
					var oldVal = $(\'#address\').val();
					$(\'#address\').val(encode64(""+$(\'#address\').val()));
					$("#messageForm").ajaxSubmit({
						type: "GET",
					  	url: "/direct/validate/format/json",
					  	beforeSend: function(request){
							start = new Date().getTime();
							//use this block if you want to send UTC stamp
							var d = Date.now();
							var currentDate = Math.round(d / 1000);
							//use this block if you want to send normal timestamp with timezone
							/*var d = new Date();
							var currentDate = d.format("mm/dd/yyyy HH:MM:ss Z");*/
							var hash_string = "GET\n"+currentDate+"\n/direct/validate/format/json?address="+encodeURIComponent($(\'#address\').val()).replace(/%20/g,"+");
							var hashString = CryptoJS.HmacSHA256(hash_string,PRIVATE_API_KEY);
							var base64 = encode64(""+hashString);
							var authorization = "DAAS "+PUBLIC_API_KEY+":"+base64;
							request.setRequestHeader("Authorization", authorization);
							request.setRequestHeader("X-Daas-Date", currentDate);
						  },
					  	success: function(data, status, jqXHR) {
						  	if (data[\'message\'])
					  			$(\'#success\').html(data[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else
								$(\'#success\').html("Valid address string.").slideDown(500).delay(5000).slideUp(500);

							$(\'#address\').val(oldVal);
					  	},
					  	error: function (jqXHR, textStatus, errorThrown) {
					  		if ($.parseJSON(jqXHR.responseText)[\'message\'])
					  			$(\'#error\').html($.parseJSON(jqXHR.responseText)[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else
								$(\'#error\').html("Not a valid address string.").slideDown(500).delay(5000).slideUp(500);

					  		$(\'#address\').val(oldVal);
					  	}
					});
				});
			});
		</script>
	</head>
	<body>
		<div class="container">
			<h1>Direct Mail</h1>
			<div id="success">Valid address string.</div>
			<div id="error"><div class="imageText">Not a valid address string.</div></div>
			<div class="wrapper">
				<form id="messageForm" action="/direct/validate" method="GET">
					<label>Address:</label> <input class="full" type="text" name="address" id="address">
				</form>
				<br/>
			</div>
			<div class="button-container"><input type="button" class="button json" value="Send"></div>
		</div>
	</body>
</html>
EOD;

	$str = htmlentities($str); 
	echo $str;

	?>

				</code></pre>
			</div>
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>