<?PHP
/**
 * @package direct-as-a-service
 * @subpackage views
 */
$this->load->view('api/header');
$this->load->view('api/nav');
$this->load->helper('form');
?>

<h1>Global Search</h1>

<div class = "column">
	<p>This table lists all messages stored in the system.</p>
	<?PHP echo form_open('/global_search/search',array('id'=>'global_search'));?>
	<table class="form" role="presentation">
		<tr class="form_row">
		<?php
		$number = 0;
		foreach ($rows as $name=>$value){
			if($number % 2 == 0 && $number !== 0){
				echo '</tr><tr class="form_row">';
			}
			$number++;
			switch ($value){
				case "plain":
					$helper = 'This is the plain text body of the message';
					break;
				case "recipients":
				case "attachments":
					$helper = 'These are the '.$value.' of the message';
					break;
				default:
					$helper = 'This is the '.$value.' of the message';
					break;
			}
		?>
			<td>
				<label for="message_<?PHP echo $value;?>"><?php echo $name;?>:</label>
			</td>
			<td>
				<p class="hidden_context" style="display:none;" id="<?PHP echo $value;?>_help"><?php echo $helper;?></p>
				<input class="ttFocus" aria-describedby="<?PHP echo $this->security->xss_clean($value);?>_help" title="<?php echo $this->security->xss_clean($helper);?>" id="message_<?PHP echo $this->security->xss_clean($value);?>" name="message_<?PHP echo $this->security->xss_clean($value);?>" type="text" value="<?php if(isset($form_data['message_'.$value])) { echo htmlentities($form_data['message_'.$value]); } ?>" onkeydown="if(event.keyCode == 13){$('#message_sender').onfocus = function(){this.form.submit();return false;}}"></input>
			</td>
			<td>
				<label for="message_<?PHP echo $value;?>_type" class="hidden_context">Compare options for <?php echo $name;?></label>
				<select id="message_<?PHP echo $value;?>_type" name="message_<?PHP echo $value;?>_type">
					<?php foreach($compare as $key => $val){ ?>
						<option value="<?php echo $key;?>" <?php if (isset($form_data['message_'.$value.'_type']) && $key == $form_data['message_'.$value.'_type']){echo "selected";}?>><?php echo $val?></option>
					<?php  } ?>
				</select>
			</td>
		<?php }?>
		</tr>
		<tr class="form_row">
			<td>Mailbox:</td>
			<td>
				<label for="mailbox" class="hidden_context">Select a Mailbox</label>
				<select id="mailbox" name="mailbox" onchange="update_folders()">
					<option value="ALL" <?php if (!isset($form_data['mailbox']) || "ALL" === $form_data['mailbox']){echo "selected";}?>>(ALL)</option>
					<?php foreach($mailboxes as $mailbox){?>
					<option value="<?php echo $mailbox->id;?>" <?php if (isset($form_data['mailbox']) && $mailbox->id === $form_data['mailbox']){echo "selected";}?>><?php echo $mailbox->name?></option>
					<?php }?>
				</select>
			</td>
			<td/>
			<td>Folder:</td>
			<td>
				<label for="folder" class="hidden_context">Select a Folder</label>
				<select id="folder" name="folder" >
					<option value="ALL" <?php if (!isset($form_data['folder']) || "ALL" === $form_data['mailbox']){echo "selected";}?>>(ALL)</option>
					<?php foreach($folders as $id=>$name){?>
					<option value="<?php echo $id;?>" <?php if (isset($form_data['folder']) && $id == $form_data['folder']){echo "selected";}?>><?php echo $name?></option>
					<?php }?>
				</select>
			</td>
		<tr/>
		<tr class="form_row">
			<td><label for="start_date">Start Date:</label></td>
			<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo $this->security->xss_clean($form_data['start_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
			<td>
			</td>
			<td><label for="end_date">End Date:</label></td>
			<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo $this->security->xss_clean($form_data['end_date']); } ?>"onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}" onchange="checkBeforeAfterDates('start_date', 'end_date', 'End Date cannot be before Start Date.');"/></td>
		</tr>
		<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt", timeSuffix : ' '+timezone_abbr});</script>
	</table>
	<?PHP
		$hidden_inputs = array(
			'order' => isset($form_data['order']) ? $form_data['order'] : '',
			'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
			'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
			'change' => 'false',
			'export' => '0',
			'page_on_bar' => '',
			'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
		);
		echo form_hidden($hidden_inputs,TRUE);
	?>
	<div class="center">
		<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>
		<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
		<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
		<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
	</div>
	<div id="date_error_message" class="message_error" style="display: none;"></div>
	<?php if(sizeof($messages) != 0) { ?>
			<div class="pagination">
				<?php echo $form_data['pages']->display_result_num();?>
				<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
				<?php echo $form_data['pages']->display_items_per_page();?>
				<div class="pagination-options">
					<!-- <img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#global_search').submit();$('#export').attr('value','0');" /> -->
					<label for="page_select" class="hidden_context">Page Selector</label>
					<input id="page_select" class="page_selector_input" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '', <?php echo $form_data['num_pages'];?>);" value="<?PHP echo $form_data['cur_page']?>">
					<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
				</div>
			</div>
	<?php } ?>
	<?PHP echo form_close();?>
	<?PHP echo form_open('/global_search/search',array('id'=>'clear_form')); echo form_close(); ?>
	<table class="display">
		<caption class="hidden_context">Search Results</caption>
		<tr class="report_row">
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','id');$('#change').attr('value','true');$('#global_search').submit();">ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'id'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','mailbox');$('#change').attr('value','true');$('#global_search').submit();">Mailbox<?php  if(isset($form_data['order'])&&$form_data['order'] == 'mailbox'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','folder');$('#change').attr('value','true');$('#global_search').submit();">Folder<?php  if(isset($form_data['order'])&&$form_data['order'] == 'folder'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','subject');$('#change').attr('value','true');$('#global_search').submit();">Subject<?php  if(isset($form_data['order'])&&$form_data['order'] == 'subject'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','timestamp');$('#change').attr('value','true');$('#global_search').submit();">Date<?php  if(isset($form_data['order'])&&$form_data['order'] == 'timestamp'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','sender');$('#change').attr('value','true');$('#global_search').submit();">From<?php  if(isset($form_data['order'])&&$form_data['order'] == 'sender'){echo $image;} ?></a></th>
			<th><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','recipients');$('#change').attr('value','true');$('#global_search').submit();">To<?php  if(isset($form_data['order'])&&$form_data['order'] == 'recipients'){echo $image;} ?></a></th>
			<th class="displaylast" style="width: 50px;"><span style="color:#FFFFFF;">View</span></th>
		</tr>
		<?php foreach($messages as $message){ ?>
			<tr>
				<td class="report_row">
					<?php echo $message->id; ?>
				</td>
				<td class="report_row">
					<?php echo $message->name; ?>
				</td>
				<td class="report_row">
					<?php
					if($form_data['folder_name']){
						echo $form_data['folder_name'];
					}
					else{
						if($message->archived == MSG_ARCHIVED){
							echo "Archived";
						}
						if($message->archived == MSG_DISCARDED){
							echo "Discarded";
						}
						if($message->archived == MSG_DELETED){
							echo "Deleted";
						}
						else if($message->sent){
							echo "Sent";
						}
						else if($message->draft){
							echo "Draft";
						}
						else if ($message->folder_name !== null){
							echo ($message->folder_name);
						}
						else{
							echo "Inbox";
						}
					}
					?>
				</td>
				<td class="report_row" style="width: 30%;">
					<?php echo $message->subject; ?>
				</td>
				<td class="report_row" style="width:10%;">
					<?php echo date('m/d/y h:i:s A',$message->timestamp); ?>
				</td>
				<td class="report_row" style="width:20%;">
					<?php echo $message->sender; ?>
				</td>
				<td class="report_row break-word" style="width:20%;">
					<?php echo $message->recipients; ?>
				</td>
				<td class="report_row" style="width:50px;">
					<a href="/global_search/view/<?php echo $message->id; ?>"><img title="Detailed View" alt="Detailed View" src="/images/icons/email_open.png"/></a>
					<a href="/global_search/raw/<?php echo $message->id; ?>"><img title="Raw Message" alt="Raw Message"   src="/images/icons/page_white_text_width.png"/></a>
				</td>
			</tr>
		<?php } ?>
	</table>

</div>

				<!-- This area is included on the bottom of every page to create the footer and end the page. -->
				</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>
