<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

/**

$user = User::find_from_session();

//we really *should* be able to look up the sender's display name without a logged-in user, but we're getting LDAP errors if we try.  can probably fix this later.
$sender_display_name = (User::is_an_entity($user)) ? $sender->display_name() : $sender->email_address();

if(!$file_transfer->property_is_empty('downloaded_at')){
	if($file_transfer->property_is_empty('downloaded_by'))
		$message = 'This file was downloaded';
	elseif(User::is_an_entity($user) && $user->id == $file_transfer->downloaded_by)
		$message = 'You downloaded this file';
	else
		$message = $file_transfer->downloader->display_name().' downloaded this file';

	echo dismissable_alert($message.' on '.unix_to_display($file_transfer->downloaded_at, 'n/j/Y \a\t g:i a').'. It is no longer available for download.', 'warning');
}

//only allow the download if the file has not expired and it is being viewed by the recipient rather than the sender
$show_download_link = !$file_transfer->has_expired() && (!User::is_an_entity($user) || strtolower($user->email_address) == strtolower($file_transfer->recipient));

if(User::is_an_entity($user) && $user->id === $sender->id) {
    $recipient_message = 'You sent this file to '.mailto($file_transfer->recipient, $file_transfer->recipient_display_name()).'.';
}else{
	//since we don't seem to have ldap permission to look up the sender display name without a logged-in user.  that's pretty weird, but this will do for now.
    $recipient_message = mailto($sender->email_address, $sender_display_name) .' has sent you a file.'.
						' You can download it on this page.  The download process may take a while, since this is a large file.';  
}

$recipient_message .= ' The file will expire after it is downloaded, or '.number_as_text(FILE_TRANSFER_EXPIRATION_IN_DAYS).' days after it was sent.';

?>
<?php if($show_download_link || (User::is_an_entity($user) && $user->id === $sender->id)): ?><p><?= $recipient_message; ?></p><?php endif ?>

<h3>File Download</h3>
<table class="table table-bordered table-hover">
	<caption class="sr-only">This table displays the metadata for the file which has been sent to you, and allows you to download the file.</caption>
	<tr>
		<th>File Name</th>
		<th>Size</th>
		<th>Sent By</th>
		<th>Sent Date</th>
		<th><?= ($file_transfer->property_is_empty('downloaded_at')) ? 'Expiration Date' : 'Download Date'; ?></th>
		<?php if($show_download_link): ?><th><span class="sr-only">Actions</span></th><?php endif ?>
	</tr>
	<tr>
		<td><?= $file_transfer->name ?></td>
		<td><?= byte_format($file_transfer->size) ?></td>
		<td><?= (empty($sender_display_name) ? $sender->email_address : $sender_display_name) ?></td>
		<td><?= unix_to_display($file_transfer->created_at, 'n/j/Y g:i a T') ?></td>
		<td><?= unix_to_display($file_transfer->expires_at, 'n/j/Y g:i a T') ?>
		<?php if($show_download_link): ?><td><?php if(!$file_transfer->has_expired()) echo link_to('file_transfer/download/'.$file_transfer->id.'/'.$file_transfer->hash, 'Download', 'onclick="$confirm = confirm(\'File transfers can only be downloaded once.  Are you sure you would like to download this file now?\'); if($confirm) $(this).remove(); return $confirm;"'); ?></td><?php endif ?>
	</tr>
</table>
<?php if(!$file_transfer->property_is_empty('note')): ?>
<h3>Notes</h3>
<p><?= html_escape($file_transfer->note) ?>
<?php endif ?>
<h3>Patient Information</h3>
<?php if(empty($file_transfer->disclosures())): ?>
<p><?= (User::is_an_entity($user) && $user->id === $sender->id) ? 'You' : (empty($sender_display_name) ? $sender->email_address : $sender_display_name) ?> did not indicate that any patient information was disclosed as part of this file transfer.</p>
<?php else: ?>
<table class="table table-bordered table-hover">
	<caption>This file includes information about the following patients:</caption>
	<tr><th>Patient Name</th><th>Purpose of Disclosure</th></tr>
<?php foreach($file_transfer->disclosures as $disclosure): ?>
	<tr>
		<td><?= $disclosure->patient_display_name() ?></td>
		<td><?= ucfirst(strtolower($disclosure->purpose)) ?></td>
	</td>
<?php endforeach ?>
</table>
<?php endif ?>

**/

?>
