<?php

$CI = get_instance();

// we need mailbox, user, and application to be passed
if(!isset($application) || !Application::is_an_entity($application)) {
    $this->error->should_be_a_user_entity($application);
}
if(!isset($mailbox) || !Mailbox::is_an_entity($mailbox)) {
    $this->error->should_be_a_mailbox_entity($mailbox);
}
if(!isset($user) || !User::is_an_entity($user)) {
    $this->error->should_be_a_user_entity($user);
}

// i dont think we need
$redirect_url = '';

$user_feedback_message = '<p><strong>The ' . mailto($application->poc_email, $application->name) . '</strong> ' .
    'application is requesting authorization to Direct Services ' .
    'in order to access the '.mailto($mailbox->email_address()) . ' mailbox on your behalf.  ' .
    'However, you cannot grant this permission because the account that you are logged in ' .
    'as ('.mailto($user->email_address()).') does not have access to this mailbox.</p>'.
    '<p>If you believe this message to be in error, please contact the administrator for assistance.</p>';

$hidden_inputs = array(
    'id' =>  $application->id,
    'mailbox_name' => $mailbox->name,
    'is_group' => $mailbox->is_group,
    'redirect_url' => $redirect_url,
);

?>
<!doctype html>
<html lang="en">
	<head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <link href="<?php echo site_url('css/main.css'); ?>" rel="stylesheet" type="text/css" media="all" />
        <link href="<?php echo site_url('css/bootstrap-scoped.min.css'); ?>" rel="stylesheet" type="text/css" media="all" />
        <link href="<?php echo site_url('css/localized.css'); ?>" rel="stylesheet" type="text/css" media="all" />
	</head>
	<body>
<?php if(!empty($service_error_message)): ?>
    <div>
        <p><strong>Service Permission Error</strong></p>
        <p><?php echo $service_error_message ?></p>
    </div>
<?php else: ?>
    <?php echo form_open(
            'authorize/edit_webservice_permission/id/' . $application->id .
            '/mailbox_name/' . $mailbox->name .
            '/is_group/' . (int)$mailbox->is_group .
            '/redirect_url/' . rawurlencode(base64_encode($redirect_url)),
            "id='form-webservice-permissions' style='margin-bottom: 0;'"
        );
    ?>
    <p>
        <strong><?php echo $application->name ?></strong> is requesting authorization from the
        <?php echo PRODUCT_NAME ?> to perform the following services on behalf of
        <strong><?php echo $mailbox->name  ?></strong>.  We recommend that you allow all services
        in order to use all features of the application.
    </p>
	<div class="bootstrap">
    <?php
    if(!empty($success_message)) {
        echo dismissable_alert($success_message, 'success');
    }
    ?>
    <?php echo form_hidden($hidden_inputs,true); ?>
    <table class="table table-bordered table-hover table-condensed">
        <tr>
            <th>
                <label for="select_all" class="sr-only">Select All Permissions</label>
                <?php
                echo form_checkbox(
                    'select_all',
                    1,
                    (array_sum(array_unique(collect('authorized', $service_permissions))) == 1),
                    'id="select_all"'
                );
                ?>
            </th>
            <th>Service</th>
            <th>Description</th>
        </tr>
        <?php foreach($service_permissions as $permission): ?>
        <tr>
            <td>
                <?php
                echo form_checkbox(
                    'service_permissions['.$permission->name.']',
                    1,
                    (bool)$permission->authorized, 'id="'.$permission->name.'"'
                );
                ?>
            </td>
            <td><label for="<?php echo $permission->name; ?>"><?php echo ucfirst($permission->name); ?></label></td>
            <td><?php echo $permission->description; ?></td>
        </tr>
        <?php endforeach ?>
    </table>
	</div>
    <?php echo form_close(); ?>
<?php endif ?>
	</body>
    <?php if(empty($service_error_message)): ?>
	<script type="text/javascript">
		$().ready(function() {
			$('input#select_all').click(function() {
				console.log('Select All');
				$('input[name^="service_permissions"]').prop('checked', this.checked);
			});
			$('input[name^="service_permissions"]').click(function() {
				console.log('I am clicked');
				let allSelected = true;
				$('input[name^="service_permissions"]').each(function(){
					allSelected = allSelected && $(this).prop('checked');
				});
				$('input:checkbox.select-all').prop('checked', allSelected);
			});
		});
	</script>
    <?php endif ?>
</html>
