<?PHP
/**
* @package direct-as-a-service
* @subpackage views
*/ 
	$this->load->helper('form');
	$count = 0;
?>
	<div class="column">
		<h3>Authorized Application List for Group: <?PHP echo $group['ou']; ?></h3>
		
			<?PHP if(isset($message)) { echo '<div class="message">'.$message.'</div>'; } ?>
			<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
			<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
			<div id="message-success" class="message_success display_none">&nbsp;</div>
			<div id="message-error" class="message_error display_none">&nbsp;</div>
			<div id="active">
				<?php if (sizeof($active_list) == 0) { ?>
					<div class="message">This group does not have access to any applications, access can be granted manually on the "Edit Access" menu.</div>
				<?php }else{ ?>
					<table class="display">
						<tr>
							<th width="90%">Name</th>
							<th width="10%" class="displaylast">Actions</th>
						</tr>
						<?php $count = 0; foreach($active_list as $app){ ?>
							<tr>
								<td>
									<a href="/user_settings/webservice_access_edit/<?PHP echo $group['ou']; ?>/<?php echo $app->id; ?>/"><?php echo $app->name; ?></a>&nbsp;
									<?php if ($app->url){?>
										<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
									<?php } ?>
									<?php if ($app->description){?>
										<br/><?php echo $app->description; ?>&nbsp;
									<?php } ?>
								</td>
								<td>
									<?PHP echo form_hidden('app_id',$app->id,'app_id'); ?>
									<div class="center">
										<a href="/user_settings/webservice_access_edit/<?PHP echo $group['ou']; ?>/<?php echo $app->id; ?>/" title="Edit Web Service Access: <?php echo $app->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Application: <?php echo $app->name; ?>" /></a>
									</div>
								</td>
							</tr>
						<?php $count++; } ?>
					</table>
				<?php } ?>
			</div>
		</div>
	</div>
<?PHP $this->load->view('api/footer'); ?>