<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class Patient extends DAAS_Entity {

	protected $_attachment_name;

//////////////////
// STATIC VARS
///////////////////
	static $database_group = 'mail_db';
	static $table = 'patients';
	protected static $_relationships = array( 'message' => array('type' => 'belongs_to'));

/////////////////////
// INSTANCE METHODS
/////////////////////

	function attachment_name(){
		if(!isset($this->_attachment_name)){
			$message = $this->message;
			if(Message::is_an_entity($message)){
				require_library('attachment');
				foreach($message->attachment_files as $name => $binary_string){
					$attachment = Attachment::create($name, $binary_string, array('message_id' => $message->id));
					if($attachment->property_exists('children')){
						foreach($attachment->children as $child){
							if($this->file_hash == sha1($child->name.$child->binary_string)){
								$this->_attachment_name = $child->name;
								return $this->_attachment_name;
							}
						}
					}elseif($this->file_hash == sha1($name.$binary_string)){
						$this->_attachment_name = $name;
						return $this->_attachment_name;
					}
				}
			}
		}
		return $this->_attachment_name;
	}

	function name(){
		return implode_nonempty(' ', array($this->given_name, $this->family_name));
	}

	function values_for_api(){
		$values = $this->values();
		unset($values['id']); //not that useful for API, since we rewrite patient db entries frequently
		unset($values['message_id']);
		$values['file_name'] = $this->document_name;
		return $values;
	}

///////////////////////
// DATA MANAGEMENT
///////////////////////
	protected function _run_before_create(){
		if($this->property_is_empty('document_name'))
			$this->document_name = $this->attachment_name();

		return parent::_run_before_create();
	}

///////////////////////
// STATIC METHODS
///////////////////////

	public static function populate_for_attachment($attachment){

	    if(!is_a($attachment, 'attachment')) {
		    // not an attachment
		    return should_be('attachment', $attachment);
        }
		if(!is_a($attachment, 'Patient_document_attachment')) {
            // no patient data to parse
		    return true;
        }

        log_message('debug','populate_for_attachment() Adding Patient to DB');
		return Patient::create(array(
		    Message::foreign_key('patient') => $attachment->message_id,
           'given_name' => implode_nonempty(' ', $attachment->parser->given_names),
           'family_name' => $attachment->parser->family_name,
           'title' => $attachment->parser->title,
           'date_of_birth' => $attachment->parser->raw_value('date_of_birth'),
           'organization' => $attachment->parser->organization,
           'file_hash' => sha1($attachment->name.$attachment->binary_string),
        ));
	}

	public static function populate_for_message($message){
		if(!Message::is_an_entity($message)) return should_be('message entity', $message);
		require_library('attachment');

		//clear any old patients for this message
		Patient::db()->where(Message::foreign_key('patient'), $message->id)->delete(Patient::$table);

		$success = true;

		log_message('debug','populate_for_message() found ' . count($message->attachment_files) . ' attachments');
		//populate with new patients for the message
		foreach($message->attachment_files as $name => $binary_string){
		    log_message('debug', 'populate_for_message(): Re attaching ' . $name . ' to message # ' . $message->id);
			$attachment = Attachment::create($name, $binary_string, array('message_id' => $message->id));
			if(is_a($attachment, 'Patient_document_attachment') && is_object($attachment->parser)){
                log_message('debug', 'populate_for_message(): ' . $name . ' is a PDA');
				$success = static::populate_for_attachment($attachment) && $success;
			}elseif($attachment->property_exists('child_patient_documents')){
				foreach($attachment->child_patient_documents as $child_patient_document) {
                    log_message('debug', 'populate_for_message(): ' . $name . ' has child patient documents');
				    $success = static::populate_for_attachment($child_patient_document) && $success;
                }
			}
		}

		return $success;
	}

}
