<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Automatic_reply extends DAAS_Entity {
	static $database_group = 'mail_db';	
	static $table = 'automatic_replies';
	protected static $_relationships = array( 'mailbox' => array( 'type' => 'belongs_to'));
											  
	protected $_property_validation_rules = array('content' => 'nonempty_string');				
	
	public function human_readable_start_at(){
		if(!$this->property_is_empty('start_at'))
			return unix_to_human($this->start_at);
	}
	
	public function human_readable_end_at(){
		if(!$this->property_is_empty('end_at'))
			return unix_to_human($this->end_at);
	}	
	
//////////////////////////////////////////
// SETTERS
//////////////////////////////////////////		
	
	/**
	* Sets the mailbox id for this automatic reply & validates that the id is for an existing mailbox that does not yet have an automatic reply
	*
	* @param int
	* @param int (Optional, internal use only) An integer offset to help {@link Error} build better backtraces
	*/
	public function set_mailbox_id($value, $offset = 0){
		if(!Mailbox::formatted_like_an_id($value)) return $this->error->should_be_formatted_like_a_mailbox_id($value, $offset+1);
		if(!Mailbox::exists($value)) return $this->error->should_be_a_mailbox_id($value, $offset+1);
		if(static::exists(array('mailbox_id' => $value))) return $this->error->should_be_an_id_for_a_mailbox_that_does_not_have_an_automatic_reply($value);
		
		return $this->_set_field_value('mailbox_id', $value, $offset+1);
	}
	
	/**
	* Sets the start_at value for this automatic reply and validates that it is not after the end_at value.
	*
	* @param int
	* @param int (Optional, internal use only) An integer offset to help {@link Error} build better backtraces
	*/
	public function set_start_at($value, $offset=0){
		if(is_null($value)) return $this->_set_field_value('start_at', $value, $offset+1);  //allow people to unset the current start_at value
		if(empty($value) || !$this->is->unix_timestamp($value)) return $this->error->should_be_a_unix_timestamp($value, $offset+1);
		if($value < strtotime('today')) return $this->error->should_be_a_future_timestamp($value, $offset+1);
		if(!$this->property_is_empty('end_at') && $value >= $this->end_at){
			$end_at = $this->end_at;
			if(!empty($end_at)) $end_at .= ', which is '.unix_to_human($end_at);
			return $this->error->warning('The start_at value must be before the end_at value ('.$end_at.'), but you gave me '.$this->error->describe($this->value).' ('.unix_to_human($value).')');
		}
		return $this->_set_field_value('start_at', $value, $offset+1);		
	}
	
	/**
	* Sets the end_at value for this automatic reply and validates that it is not before the start_at value.
	*
	* @param int
	* @param int (Optional, internal use only) An integer offset to help {@link Error} build better backtraces
	*/
	public function set_end_at($value, $offset=0){
		if(is_null($value)) return $this->_set_field_value('end_at', $value, $offset+1);  //allow people to unset the current start_at value
		if(empty($value) || !$this->is->unix_timestamp($value)) return $this->error->should_be_a_unix_timestamp($value, $offset+1);
		if($value < strtotime('today')) return $this->error->should_be_a_future_timestamp($value, $offset+1);
		if(!$this->property_is_empty('start_at') && $value <= $this->start_at){
			$start_at = $this->start_at;
			if(!empty($start_at)) $start_at .= ', which is '.unix_to_human($start_at);
			return $this->error->warning('The end_at value for '.$this->describe().' must be after the start_at value ('.$start_at.'), but you gave me '.$this->error->describe($value).' ('.unix_to_human($value).')');
		}
		
		return $this->_set_field_value('end_at', $value, $offset+1);		
	}	
	
//////////////////////////////////////////
// DATA MANAGEMENT
//////////////////////////////////////////	
	
	protected function _values_are_valid_for_create_and_update(){ 
		if($this->property_is_empty('mailbox_id')) return $this->error->warning('The mailbox_id is required in order to save '.$this->describe());
		if($this->property_is_empty('start_at') && !$this->property_is_empty('end_at')) 
			return $this->error->warning('The value for start_at must be set when there is a value for end_at when saving '.$this->describe());
		if($this->property_is_empty('end_at') && !$this->property_is_empty('start_at')) 
			return $this->error->warning('The value for end_at must be set when there is a value for start_at ('.$this->error->describe($this->start_at).') when saving '.$this->describe());
		if($this->property_is_empty('content')) 
			return $this->error->warning('The value for content is required for '.$this->describe());
		return parent::_values_are_valid_for_create_and_update(); 
	}
	
	protected function _values_for_save(){
		$values = parent::_values_for_save();
		$values['updated_at'] = now();
		return $values;
	}
	
}