<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
*/ /** */

require_library('patient_data/Soap_call');

//TODO - This should follow the conventions of the other extensions of the Soap_call library as to how
//errors are handled and make use of the feedback_messages class variable to store messages for the user.
//Given that consent is either given or not given, it doesn't really benefit us to be returning an array
//as a result instead of a simple boolean (true/false - we either have consent or we don't) and call on 
//on feedback_messages when user-friendly details are needed. -- MG 2016-02-24

/**
 * Patient Consent class
 * Makes a call to VAP and checks to see if patient consent is permitted/denied for automated processes
 * @package direct-as-a-service
 * @subpackage libraries
 */ 
class Patient_consent extends Soap_call {
	
	var $wsdl_uri = VAP_URI;
	var $curl_options = array(
		CURLOPT_SSLCERT => TLS_SERVER_CERT_PATH,
		CURLOPT_SSLKEY => TLS_SERVER_KEY_PATH,
		CURLOPT_SSL_VERIFYHOST => TLS_SERVER_VERIFYHOST,
		CURLOPT_SSL_VERIFYPEER => TLS_SERVER_VERIFYPEER,
		CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1,
	);

	//these vars will be set from document metadata and passed to the XML
	protected $home_community_id = VAP_HOME_COMMUNITY_ID;//not sure if we have to set this dynamically
	protected $purpose_of_use;	//not sure if we have to set this dynamically
	protected $resource_id; 
	protected $action_id = 'DocumentQueryIn'; 

	/**
	 * Get Patient Consent 
	 * @param string $resource_id - patient ien
	 * @param string $purpose_of_use - currently we are only using TREATMENT, but could put other values in for the future.
	 * @return string - xamcl response
	 */
	function get_consent($resource_id, $purpose_of_use = 'TREATMENT') {
		try {
			$this->purpose_of_use = $purpose_of_use;
			$this->resource_id = $resource_id;	// patient_ien 
			$response = $this->call();
		} catch (Exception $e) {
			log_message('error', $e->getMessage());
			$response = FALSE;
		}
		return $this->response_handler($response);
	}

	/**
	 * Handle XML response
	 * takes XACML PDP response and outputs the decision and message in an array
	 * @param  string $response xml data (default to false)
	 * @return array  decision: Permit, Deny, Not Applicable, Indeterminate; message: message pertaining to decision
	 */
	protected function response_handler($response = FALSE) {
		
		$result = "Indeterminate";
		if ($response != FALSE) {
			//parse the xml into a SimpleXML Object
			$xml = simplexml_load_string($response);
			$xml->registerXpathNamespace('urn','urn:oasis:names:tc:xacml:2.0:context:schema:os');
			//we just need to use Xpath to get the first intance of the Decision, there will only ever be one
			$decision = trim($xml->xpath('//urn:Decision')[0]);
			log_message("error", $decision);
			if(!empty($decision)) { $result = $decision; }
		} 
		
		//switch messages
		switch($result) {
			case "Permit":
				$message = "Permitted.";
			break;
			case "Deny":
				$message = "The patient not has permitted this.";
			break;
			case "Not Applicable":
				$message = "The request can't be answered by this service.";
			break;
			case "Indeterminate":
				$message = "An error occurred or some required value was missing in the request.";
			break;
			default:
				//	response was not an available decision 
				log_message("error", print_r($vals, TRUE));
				$result = "Indeterminate";
				$message = "An error occurred or some required value was missing in the request.";
			break;
		}
		return array('decision' => $result, 'message' => $message);
	}
}
