<?php

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_library('form_markup_generator');
require_model('account_request');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Account_request_form extends Form_markup_generator{
	protected $_account_request;
	protected $_application;
	protected $_application_account;
	protected $_use_grid = true;
	
	//todo - constructor should add the max length from the db to each field
	protected $_field_settings = array(	'first_name' => array('type' => 'text_input', 'label_text' => 'Given Name', 'required' => true),
										'middle_name' => 'text_input',
										'last_name' => array('type' => 'text_input', 'label_text' => 'Family Name', 'required' => true),
										'ext_mail' => array('type' => 'email', 
															'label_text' => 'VA Email Address', 
															'required' => true, 
															'validation_method' => 'string_like_a_va_email_address',
															'feedback_invalid_input' => "Please enter a VA email address for the %s field."
															 ),
										'title' => array('type' => 'text_input', 'label_text' => 'Job Title'),
										'department' => array('type' => 'text_input'),
										'organization' => array('type' => 'text_input'),
										'telephone' => array('type' => 'text_input',
															 'attributes' => array('size' => 12),
															 'validation_method' => 'string_like_a_phone_number',
															 'feedback_invalid_input' => "Please enter a valid telephone number for the %s field."
															 ),
										'mobile' => array('type' => 'text_input', 
														  'attributes' => array('size' => 12), 
														  'label_text' => 'Mobile Phone',
														  'validation_method' => 'string_like_a_phone_number',
														  'feedback_invalid_input' => "Please enter a valid telephone number for the %s field."),
										'location' => array('type' => 'text_input'),
										'facility_id' => array('type' => 'dropdown', 
															   'label_text' => 'Facility',
															   'required' => true, 
															   'attributes'=> array('data-placeholder' => 'Choose a Facility')),
										'system_permissions' => array('type' => 'checkbox_group', 
																	  'inline' => true,
																	  'options' => array( 'retrieve' => 'Retrieve Messages', 'send' => 'Send Messages', 'manage' => 'Manage Your Data'),
																	  /* 'value' => array('retrieve' => true, 'send' => true, 'manage' => true) */),
																	
												
										);
										

	function __construct($properties_to_set = array()){		
		parent::__construct(array(), $properties_to_set);
		
		//set up some configuration that we needed to generate dynamically
		$this->_field_settings['facility_id']['options'] = $this->facilities();
		
		if(!isset($this->application)){
			unset($this->_field_settings['system_permissions']);
		}else{
			$this->_field_settings['system_permissions']['label_text'] = 'Service Permissions';
			$this->_field_settings['system_permissions']['comment'] = $this->application->name.' is requesting the following service permissions.  We recommend that you leave all options selected in order to use all features of the application.';
		}
		
		
		$this->set_fields($this->_field_settings);
		
		//set max length for each field based on the database
		foreach(Account_request::field_data() as $field_name => $field_data){
			if(!$this->field_exists($field_name)) continue;
			$this->field($field_name)->max_length = $field_data['max_length'];
		}
		
		//set additional comments on each field in the checkbox group - we should be able to do this in field settings, but it's too much of a hassle right now to figure out if that's been enabled
		if($this->field_exists('system_permissions')){
			$this->field('system_permissions')->field('retrieve')->comment = '&ndash; Allow this application to retrieve your messages';
			$this->field('system_permissions')->field('send')->comment = '&ndash; Allow this application to send your messages';
			$this->field('system_permissions')->field('manage')->comment = '&ndash; Allow this application to manage your data, including folders and user settings';
		}
		
	}

	
	/**
	* Loads values for this form from the various sources to which they have been saved.
	* This includes data from the database, the API, and LDAP. Returns true if we were able to save all o
	* @return boolean 
	*/
	public function load_saved_values(){
		
		//load saved application account values
		if($this->field_exists('system_permissions')){
			if(isset($this->application_account))
				$this->field('system_permissions')->value = get_instance()->json->decode_as_array(str_replace('"false"', '"0"', str_replace('"on"', '"1"', $this->application_account->system_permissions)));
			else
				$this->field('system_permissions')->value = array('retrieve' => '1', 'send' => '1', 'manage' => '1'); //by default, all service permissions are selected
		}

		//load saved account request permissions
		if(isset($this->account_request)){
			return $this->set_values($this->account_request->values(array_intersect_key($this->field_names, $this->account_request->fields)));	
		}
		
		
		$CI = get_instance();		
		if(isset($CI->authentication)){
			//load name values from the cert and return true
			return $this->set_values(array('first_name' => $CI->authentication->given_name,
											'middle_name' => $CI->authentication->middle_name,
											'last_name' => $CI->authentication->family_name,
											'ext_mail' => $CI->authentication->email));
		}
		
		return $this->error->warning('No saved values found');
	}
	
	function values_for_account_request(){
		return $this->values(array_intersect($this->field_names(), Account_request::fields()));
	}
	
	function values_for_application_account(){
		$values = $this->values(array_intersect($this->field_names(), Application_account::fields()));
		if(array_key_exists('system_permissions', $values)){
			$values['system_permissions'] = str_replace(':null', ':"false"', str_replace(':1', ':"on"', get_instance()->json->encode($values['system_permissions'])));
		}
		
		return $values;
	}
	
	/**
	* Since saving this form is pretty complicated 
	* @return boolean 
	*/
	public function save_values(){
		
		//if the form doesn't validate, return an error - developer should know better	
		if(!$this->validates)
			return $this->error->warning("I can't save a form that doesn't validaet");

		//save the actual account request
		if(!isset($this->account_request) || $this->account_request->is_denied()){
			$values = array('user_org_id' => get_instance()->authentication->organization_id, 'username' => strstr($this->value('ext_mail'), '@', true));
			$account_request = new Account_request(array_merge($values, $this->values_for_account_request()));
		}else{
			$account_request = $this->account_request;
			$account_request->set_values($this->values_for_account_request);
		}
			
		if(!$account_request->save()){
			$CI = get_instance();
			$CI->load->library('eventlog');
			$CI->eventlog->create_event(4, 0, 4, 0, 'Requested account', time(), 0);
			return $this->error->warning('Unable to save '.$account_request->describe());
		}
		
		$this->account_request = $account_request;
		
		//if an application has been specified, make sure that an application account has been set up
		if(isset($this->application)){
			if(!Application_account::is_an_entity($this->application_account)){
				$this->application_account = new Application_account(array('org_id' => $account_request->user_org_id, 'app_id' => $this->application->id));
			}

			$this->application_account->set_values($this->values_for_application_account());
			if(!$this->application_account->save())
				return $this->error->warning('Unable to save '.$this->application_account->describe());
		}			
		
		return true;
	}

		
///////////////////////////
// GETTERS FOR CLASS VARS
////////////////////////////

	function application_account(){
		if(!isset($this->_application_account) && isset($this->application) && isset($this->account_request)){
			$application_account = first_element($this->account_request->application_account(array('app_id' => $this->application->id)));
			if(Application_account::is_an_entity($application_account))
				$this->_application_account = $application_account;
		}
		return $this->_application_account;
	}

	
	function facilities(){
		$facilities = array();
		foreach(get_instance()->facilitymodel->get_facilities(true)->result() as $facility){
			$facilities[$facility->id] = $facility->name;
		}
		return $facilities;
	}

///////////////////////////
// SETTERS FOR CLASS VARS
///////////////////////////	

	function set_account_request($value){
		if(!Account_request::is_an_entity($value)) return $this->error->property_value_should_be_an_account_request_entity('account_request', get_class($this), $value);
		$this->_account_request = $value;
	}
	
	function set_application($value){
		if(!Application::is_an_entity($value)) return $this->error->property_value_should_be_an_application_entity('application', get_class($this), $value);
		$this->_application = $value;
	}
	
	function set_application_account($value){
		if(!Application_account::is_an_entity($value)) return $this->error->property_value_should_be_an_application_account_entity('application_account', get_class($this), $value);
		$this->_application_account = $value;
	}
	
}