<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage helpers
*//** */

//true if this is a local developer environment
//it's easy to mistype values for constants or forget whether or not they're capitalized -- using a method provides some extra checks, as we'll see an error if the method doesn't exist
function is_on_local(){
	return ( (ENVIRONMENT == 'development' || ENVIRONMENT == 'regression') && DIRECT_ENVIRONMENT == 'LOCAL' );
}

//true if this is a dev environment (either a developer's local or the central dev environment
//it's easy to mistype values for constants or forget whether or not they're capitalized -- using a method provides some extra checks, as we'll see an error if the method doesn't exist
function is_on_dev(){
	return (ENVIRONMENT == 'development' || ENVIRONMENT == 'regression');
}

//true if this a portion of the site that people are accessing as an API, rather than the part of the site serving up HTML
function in_api_context(){
	if(function_exists('string_contains')) return string_contains(API_DOMAIN, base_url());
	global $CFG; //grab the global config used by core/CodeIgniter if we don't have everything loaded yet
	return (mb_strpos($CFG->base_url(), API_DOMAIN) !== FALSE);
}

// the array that stores all valid domains for the API.
function valid_domains(){
	return array(CLINICAL_DOMAIN,PATIENT_DOMAIN);
}

?>
