<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/Reports.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Login_report_controller extends Reports{

    //function for User Activity Summary
	//note - this used to be the report_user_activity_summary method on Reports.  Over time, we want to make this method MUCH smaller, make better 
	//use of reusable methods, and move any other code that's just for the user summary report from the Reports controller to this controller.
    public function index($adhoc_report_id = null){

        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("logins_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $id_type = $this->input->post('id_type',TRUE); //gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);
		
		$typesearch = array (
			'org_id' => array(
			'typesql' => '',
			'name' => $this->search_type($this->input->post('username',TRUE),$this->input->post('username_type',TRUE)),
			'type' => 'login_report_username'
			)
		);
        
        if($id_type) { // This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                    'success' =>  $this->input->post('successful',TRUE),
            );
                
            $items = array(
                    'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
                    'session_id'=>$this->search_type($this->input->post('session_id',TRUE),$this->input->post('session_id_type',TRUE)),
                    'ip_address'=>$this->search_type($this->input->post('ip_address',TRUE),$this->input->post('ip_address_type',TRUE)),
                    'error_msg'=>$this->search_type($this->input->post('message',TRUE),$this->input->post('message_type',TRUE)),
                    'org_id'=>$this->search_type($this->input->post('org_id',TRUE),$this->input->post('org_id_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
                
            $between = array(
                    'login_time' => $this->check_paired_dates($start_date,$end_date)
            );

            //get direction and if exported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $order = $this->input->post('order',TRUE);
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
    
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
                
            //get data
            $response = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$this->items_per_page);
            $login_list = $response['response'];
            $response_adhoc = $this->reports_helper_adhoc('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$this->items_per_page);
                
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if ($selector['success']==1) $selected='Success: True';
            elseif ($selector['success']!='(ALL)') $selected='Success: False';
                
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('login',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/
            
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "logins")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = str_replace('%', '###', $adhoc_report[0]->report_selector);
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
    
            $successful = $filters_used['successful'];
    
            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);
                
            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];
                
            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
    
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;
    
                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);
    
                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;
    
                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            }
            //adds each component type into its own json
            $selector = array(
                    'success' =>  $filters_used['successful'],
            );
                
            $items = array(
                    'id' => $this->search_type($filters_used['id'],$filters_used['id_type']),
                    'session_id'=>$this->search_type($filters_used['session_id'],$filters_used['session_id_type']),
                    'ip_address'=>$this->search_type($filters_used['ip_address'],['ip_address_type']),
                    'error_msg'=>$this->search_type($filters_used['message'],$filters_used['message_type']),
                    'org_id'=>$this->search_type($filters_used['org_id'],$filters_used['org_id_type']),
            );
                
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
                
            $between = array(
                    'login_time' => $this->check_paired_dates($start_date,$end_date)
            );
			
            //get direction and if exported
            $dir = $adhoc_report[0]->report_order_by_direction;
            $order = $adhoc_report[0]->report_order_by;
                
                
            $this->items_per_page = $filters_used['items_per_page'];
    
            $page = 1;
    
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
    
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export; 
                
            //get data
			if(empty($sql)) $sql = array();
    		$size = Authentication_log_entry::count_for_reports($sql);
    		if(string_begins_with('id', $order))$order = 'id '.$dir;
    		if (!string_contains('DESC',$order)||(!string_contains('ASC',$order)))$order = $order.' '.$dir;
    		Authentication_log_entry::db()->order_by($order)->limit($this->items_per_page);
            $responses_list = Authentication_log_entry::find_for_reports($sql);
            $login_list = $responses_list;
            $response_adhoc = $sql;
                
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['id'] = $filters_used['id'];
            $form_data['id_type'] = $filters_used['id_type'];
            $form_data['username'] = $filters_used['username'];
            $form_data['username_type'] = $filters_used['username_type'];
            $form_data['session_id']= $filters_used['session_id'];
            $form_data['session_id_type']= $filters_used['session_id_type'];
            $form_data['ip_address'] = $filters_used['ip_address'];
            $form_data['ip_address_type'] = $filters_used['ip_address_type'];
            $form_data['message'] = $filters_used['message'];
            $form_data['message_type'] = $filters_used['message_type'];
            $form_data['org_id'] = $filters_used['org_id'];
            $form_data['org_id_type'] = $filters_used['org_id_type'];
            $form_data['start_date'] = $start_date;
            $form_data['end_date'] = $end_date;
            $form_data['successful'] = $filters_used['successful'];
                
            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
                
            //ExportPDF-PRINT
            if($is_export) {
                $response_export = $this->reports_helper('login',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items, $between, $selected, null);
            }
            $data['form_data'] = $form_data;
            
            if ($selector['success']==1) $selected='Success: True';
            elseif ($selector['success']!='(ALL)') $selected='Success: False';
    
        } else { //if this is the first time you have loaded the page (ie no filters have fields)
            Authentication_log_entry::db()->order_by('login_time', 'DESC')->limit($this->items_per_page);
            $login_list = Authentication_log_entry::find_for_reports();
            //set defaults
            $form_data = array(
                 'direction' => 'DESC',
                 'order' => 'login_time',
                 'cur_page' => '1'
            );
            //get number of items in log
            $size = Authentication_log_entry::count_for_reports(array(), TRUE);
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;
                
            //Adhoc Report
            $between = array ("login_time" => Array("start"=>"", "end" =>""));
            $response_adhoc = '';
            $dir = "DESC";
            $order = "login_time";
            //set blank filters
            $form_data['id'] = "";
            $form_data['id_type'] = "";
            $form_data['username'] = "";
            $form_data['username_type'] = "";
            $form_data['session_id']= "";
            $form_data['session_id_type']= "";
            $form_data['ip_address'] = "";
            $form_data['ip_address_type'] = "";
            $form_data['message'] = "";
            $form_data['message_type'] = "";
            $form_data['org_id'] = "";
            $form_data['org_id_type'] = "";
            $form_data['start_date'] = "";
            $form_data['end_date'] = "";
            $form_data['successful'] = "(ALL)";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
                'equals' => 'Equals',
                'contains' => 'Contains',
                'starts' => 'Starts With',
                'ends' => 'Ends With',
        );
    
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "logins";
    
        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();
    
        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>';
        }
    
        $form_data['num_pages'] = ceil($size/$this->items_per_page); //num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['login_list'] = $login_list;

        foreach($login_list as $login) {
            //get binary true/false into text
            if($login->success === 1) { $login->success = 'TRUE'; }
            else { $login->success = 'FALSE'; }
        }
        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }
        
        
        //if export
        if($export){    
            $this->export(array('ID','Session ID','IP Address','Date ('.$data['timezone_abbr'].')','Success','Message','Org ID','Username'),collect('values_for_export', $login_list),$export_file_name,$items,$between,$selected,null);
        }elseif($export_pdf) {
            if (!empty($response_export)){
                $data['export_login_list'] = $response_export_list;
            }
			

            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_logins', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }elseif($print_page == 1) {
                $this->clear_cache();
                if (!empty($response_export)){
                    $data['export_login_list'] = $response_export_list;
                } 


                $data['print_page'] = true;
                $form_data['page_select'] = $this->destination_page;
                $this->load->view('api/reports/logins', $data);
        } 
        else{
            $this->load->view('api/reports/logins', $data);
        }
        
    }

}