<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */


require_once APPPATH.'controllers/admin/Onboarding.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Registration_controller extends Onboarding{
	
	public function __construct(){
		parent::__construct();

		require_library('form_markup_generator/account_request_form');
		require_models('account_request', 'application', 'application_account');
		
		$this->load->library('template');
	}
	
	public function account_request(){
		//find the existing account request for this user, if it exists
		Account_request::db()->order_by('request_date', 'desc');
		$account_request = Account_request::find_one(array('user_org_id' => User::organization_id_from_session()));
		
		if(Account_request::is_an_entity($account_request) && $account_request->is_approved()){
			redirect('user_settings/account_edit');
		}
		
		$models = array();;
		
		//if the user only has one application, include the service permissions for it in this form
		if(Account_request::is_an_entity($account_request)){
			$models['account_request'] = $account_request;
			$application_accounts = $account_request->application_accounts;
			if(count($application_accounts) == 1){
				$models['application_account'] = first_element($application_accounts);
				$models['application'] = $models['application_account']->application;
			}
		}

		$markup_generator = new Account_request_form($models);
		if(Account_request::is_an_entity($account_request))
			$markup_generator->account_request = $account_request;
			
		$data['markup_generator'] = $markup_generator;	
		$data['account_request'] = $account_request;	
		
		if(empty($_POST)){
			$markup_generator->load_saved_values();	
		}elseif(!$markup_generator->set_values_from_post()){
			$data['error_message'] = '<strong>An error occurred and your changes could not be saved.</strong>  Please try again in a moment, and contact an administrator if the the problem persists.';
		}elseif(!$markup_generator->validates()){
			$data['error_message'] = '<strong>We need you to make a few changes to this form.</strong>&nbsp;&nbsp;'.ul_if_multiple($markup_generator->validation_messages);
		}elseif(!$markup_generator->save_values()){
			$data['error_message'] = '<strong>An error occurred and your changes could not be saved.</strong>  Please try again in a moment, and contact an administrator if the the problem persists.';
		}else{
			redirect(current_url()); //success!
		}
		
		$data['page_title'] = 'Account Registration';
		$this->template->load('template', 'api/onboarding/registration/account_request',$data);	
	
	}		
	
	
	//todo - add services
	//check which vars need to be passed to the view at this point - we can get rid of a lot
	//go through the old method and make sure that we've got everything that needs to happen (log creation of account request, for example)
	//merge in Brandon's log-in changes
	//create a test plan
	//get the normal account request page to use the same markup generator
	//last few bootsrap changes - buttons, warnings, etc.
	public function application_account_request($app_id = null, $unique_id = null, $redirect_url=null){

		//VALIDATE PARAMETERS AND FIND THE ACCOUNT REQUEST
		if(is_null($app_id)) $app_id = $this->input->get('app_id');
		if(!Application::formatted_like_an_id($app_id)) 
			show_404();
			
		$application = Application::find_one($app_id);
		if(!Application::is_an_entity($application))
			show_404();
		
		if(is_null($unique_id)) $unique_id = $this->input->get('unique_id');
		if(empty($unique_id))
			show_404();
		
		if(is_null($redirect_url)) 
			$redirect_url = $this->input->get('redirect_url');
		else
			$redirect_url = base64_decode(rawurldecode($redirect_url));
		
		
		if(empty($redirect_url)) $this->error->notice('No redirect URL sent');
		$org_id = User::organization_id_from_session();
		
		if(!Application::formatted_like_an_id($app_id) || empty($unique_id) /* || !$this->is->string_like_a_url($redirect_url) */) show_404();
		
		$account = Application_account::find_one(compact('app_id', 'unique_id'));
		if(!Application_account::is_an_entity($account)){
			$this->error->warning('Could not find application_account with application id '.$this->error->describe($app_id).' and unique id '.$this->error->describe($unique_id));
			show_404();
		}
		
		if($account->org_id != $this->authentication->organization_id){
			$this->error->warning($account->describe().' does not belong to the user with organization id '.$this->error->describe($this->authentication->organization_id));
			show_404();
		}
		
		if($account->is_registered() && !$account->is_denied()){
			redirect($redirect_url); //todo - may need to rawurldecode this
		}
		
		require_library('form_markup_generator/account_request_form');
		$markup_generator = new Account_request_form(compact('account_request', 'application'));
		$data['markup_generator'] = $markup_generator;	
		$data['account_request'] = $account->account_request;	
		$data['application'] = $application;
		
		if(empty($_POST)){
			$markup_generator->load_saved_values();	
		}elseif(!$markup_generator->set_values_from_post()){
			$data['error_message'] = '<strong>An error occurred and your changes could not be saved.</strong>  Please try again in a moment, and contact an administrator if the the problem persists.';
		}elseif(!$markup_generator->validates()){
			$data['error_message'] = '<strong>We need you to make a few changes to this form.</strong>&nbsp;&nbsp;'.ul_if_multiple($markup_generator->validation_messages);
		}elseif(!$markup_generator->save_values()){
			$data['error_message'] = '<strong>An error occurred and your changes could not be saved.</strong>  Please try again in a moment, and contact an administrator if the the problem persists.';
		}else{
			if(!empty($redirect_url)) redirect($redirect_url);
			redirect('onboarding/request'); //success!
		}
		
		$data['page_title'] = 'Account Registration';
		$this->template->load('template', 'api/onboarding/registration/account_request',$data);	
	
	}	
	
	/* 
	* Onboarding request is the page where a user can request application access. 
	*/
	public function onboarding_request($form_data = null, $error_message = null) {
		$this->load->model('accountrequestmodel');
		$data['title'] = 'Direct API: Application Request';
		$data['active_tab'] = array('onboarding'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->permissions->get_user_permissions($id);
		if(!$permissions['Registered']) return $this->account_request();
		
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		
		if(!empty($_POST) && empty($error_message)){
			return $this->app_request_save();
		}
		
		//load validation errors from flashdata if necessary
		//error message from app request
		if(!empty($error_message)) { 
			$data['error_message'] = $error_message;
			$data['form_data'] = $form_data;
		}
		//error message from account request
		else if(!empty($this->session->flashdata('error_message'))) { 
			$data['error_message'] = $this->session->flashdata('error_message');
		}
		
		//load view based on user permissions
		$this->load->view('api/onboarding/app_request', $data); 
	}

	/*
	 * Onboarding request edit is a function for editing existing requests.
	 */
	public function onboarding_request_edit($id = null, $form_data = array(), $error_message = null){
		if(is_null($id)) { redirect('applications/list'); } //if no id is set, go back to application list
		
		$data['title'] = 'Direct API: Request Edit';
		$data['active_tab'] = array('onboarding'=>true);
		//get user id from session to get permissions
		$user_id = User::organization_id_from_session();
		$user_db_id = $this->usersmodel->get_user_id_from_org_id($user_id);
		$permissions = $this->permissions->get_user_permissions($user_id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);

		if(!$data['show']['applications']) show_error('Forbidden',403);
		if(!Application_request::formatted_like_an_id($id)) show_404(); //make sure its a valid id
		
		$application_request = Application_request::find_one($id);
		if(!Application_request::is_an_entity($application_request)) show_404();

		if(!$permissions['API']['admins'] && $application_request->requestor != $user_db_id)  
			show_error('Forbidden',403);		
			
		if(!empty($_POST) && empty($error_message)){
			return $this->app_request_save();
		}	
		
		//load validation errors from flashdata if necessary
		if(!empty($error_message)) {
			$data['error_message'] = $error_message;
		}else{
			$form_data['app_name'] = $application_request->name;
			$form_data['app_url'] = $application_request->url;
			$form_data['app_desc'] = $application_request->description;
			$form_data['app_just'] = $application_request->justification;
			$form_data['app_poc_name'] = $application_request->poc_name;
			$form_data['app_poc_email'] = $application_request->poc_email;
			$form_data['app_poc_phone'] = $application_request->poc_phone;	
		}		
		
		$data['form_data'] = $form_data;
		$data['request'] = $application_request;
		$this->load->view('api/onboarding/app_request', $data);
	}

	/* 
	 * App request save handles the save of the request information into the database. 
	 * @todo - this needs to be rethought.  Note that this used to be a public method and switched to be proted as a minor imporvement
	 */
	protected function app_request_save(){
		$this->load->library(array('external_email', 'form_validation'));
		
		//grab the admin accounts and their emails for external notifications
		$admins = $this->usersmodel->get_daas_admins();
		$emails = $this->usersmodel->get_emails_from_uid_array($admins);
		
		//collect request form information
		$id = $this->input->post('app_id', TRUE);
		$name = $this->input->post('app_name', TRUE);
		$url = $this->input->post('app_url', TRUE);
		$desc = $this->input->post('app_desc', TRUE);
		$just = $this->input->post('app_just', TRUE);
		$poc_name = $this->input->post('app_poc_name', TRUE);
		$poc_email = $this->input->post('app_poc_email', TRUE);
		$poc_phone = $this->input->post('app_poc_phone', TRUE);

		//validation of form values
		if(!empty(trim($id))){
			$application_request = Application_request::find_one($id);
			if($application_request->name === $name){
				$this->form_validation->set_rules('app_name','Application Name','required|max_length[100]');
			}else{
				$this->form_validation->set_rules('app_name','Application Name','required|is_unique[application_request.name]|max_length[100]');
			}
		}else{
			$this->form_validation->set_rules('app_name','Application Name','required|is_unique[application_request.name]|max_length[100]');
		}
		$this->form_validation->set_rules('app_url','Application URL','required|max_length[1000]|valid_url');
		$this->form_validation->set_rules('app_desc','Application Description','required|max_length[4000]');
		$this->form_validation->set_rules('app_just','Justification','required|max_length[4000]');
		$this->form_validation->set_rules('app_poc_name','POC Name','required|max_length[500]');
		$this->form_validation->set_rules('app_poc_email','POC Email','required|va_email|max_length[100]');
		$this->form_validation->set_rules('app_poc_phone','POC Phone','required|validate_phone|max_length[20]');
		$is_denied = 0;
		

		//if it doesn't pass the validation checks then pass back the errors
		if(!$this->form_validation->run()){		
			$form_data = $this->input->post(NULL,TRUE);
			if(!empty(trim($id))) 
				return $this->onboarding_request_edit($id, $form_data, validation_errors());
			 
			return $this->onboarding_request($form_data, validation_errors());
		}

		//determine id
		$user_id = User::organization_id_from_session();
		$user_db_id = $this->usersmodel->get_user_id_from_org_id($user_id);
		
		//if the request already exists then update it
		if(!empty(trim($id)) && Application_request::exists($id)) {
			$request = Application_request::find_one($id);
		
			$is_denied = $request->denied;
			//use permissions to determine whether to allow function call at all
			$permissions = $this->permissions->get_user_permissions($user_id);
			if($permissions['API']['admins'] || $request->requestor === $user_db_id) {
				
				$request->set_values(array(
					'name' => $name,
					'url' => $url,
					'description' => $desc,
					'justification' => $just,
					'poc_name' => $poc_name,
					'poc_email' => $poc_email,
					'poc_phone' => $poc_phone,
				));
				
				if($request->save()){			
				
					$this->session->set_flashdata('success_message', 'Request for application "'.$name.'" has been updated successfully.');
					
					$mail_subject = 'Request for application "'.$name.'" has been updated and is waiting approval.';
					$mail_message = "Admins,\r\n\r\nAn application request has been updated and is awaiting approval.\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/administration/application/requests\r\n\r\nThank you,\r\n".EMAIL_SIGNATURE;
					$this->external_email->to($emails);
					$this->external_email->subject($mail_subject); 
					$this->external_email->message($mail_message); 
					$this->external_email->send();
					
					$this->eventlog->create_event( 1,$id,3 ,$user_db_id, "Application request updated", time(), 1);
				}
				
				//TODO: find way to get external email to send through relay
			}else{$this->eventlog->create_event( 1,$id,3 ,$user_db_id, "Application request updated", time(), 2); show_error('Forbidden',403); }
		}
		//if the request doesn't exist then add a new one
		else {
			$requestor = $user_db_id;
			if(!$requestor) { 
				$this->eventlog->create_event( 1,0,3 ,$user_db_id, "Application request created", time(), 0);
				$form_data = $this->input->post(NULL,TRUE);
				$this->onboarding_request($form_data, 'Failed to submit application request.');
			}
			
			$application_request = Application_request::create(array(
					'name' => $name,
					'requestor' => $requestor,
					'url' => $url,
					'description' => $desc,
					'justification' => $just,
					'poc_name' => $poc_name,
					'poc_email' => $poc_email,
					'poc_phone' => $poc_phone,
					'requested_date' => now()
			));

			
			$this->session->set_flashdata('success_message', 'Request for application "'.$name.'" has been submitted successfully.');
			$new_id = $application_request->id;
			$this->eventlog->create_event( 1,$new_id,3 ,$user_db_id, "Application request created", time(), 1);
			
			$mail_subject = 'Request for application "'.$name.'" is awaiting approval.';
			$mail_message = "Admins,\r\n\r\nA new application request is awaiting approval.\r\n\r\nhttps://".API_ADMINPANEL_DOMAIN."/administration/application/requests\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE;
			$this->external_email->to($emails);
			$this->external_email->subject($mail_subject); 
			$this->external_email->message($mail_message); 
			$this->external_email->send();
			redirect('applications/list#pending');
		}
		
		
		if($is_denied){
			redirect('applications/list#denied');
		}else{
			redirect('applications/list#pending');
		}

	}
	

}