<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

// This can be removed if you use __autoload() in config.php OR use Modular Extensions //no, it can't, autoload should not be used for things that you're extending but not instantiating -- MG
require_once APPPATH.'controllers/admin/admin_controller.php';
require_once APPPATH.'third_party/Paginator.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Administration extends Admin_controller
{	
	public function __construct(){
		parent::__construct();
		
		$this->load->library('external_email');
		$this->load->model(array('applicationmodel','usersettingsmodel'));
	}
	
	public function index() {
		//get user id from session to get permissions
		$this->administration(); 
	}
	
	
	/* -----------------------------*
	 * ADMINISTRATION TAB FUNCTIONS *
	 * -----------------------------*/
	
	/*
	 * Administration is the main landing page for the administration tab. 
	 */
	public function administration() {	
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		
		//use tab access to determine whether to show view at all
		if($this->has_access('application_requests')){
			$this->application_request_list();
		}
		else if($this->has_access('account_requests')){
			$this->account_request_list();
		}
		else if($this->has_access('manage_accounts')){
			$this->admin_manage_accounts();
		}
		else if($this->has_access('manage_groups')){
			$this->admin_manage_groups();
		}
		else if(count($this->permissions->get_application_permission($this->account_permissions, 'admins')) > 0) {
			$this->admin_manage_accounts();
		}
		else { redirect("onboarding"); }
	}
	
	/*
	 * Admin request list shows all the pending, approved and denied requests.
	 */
	public function application_request_list() {
		$this->verify_access('application_requests');
		$data['title'] = 'Direct API: Request List';
		$data['active_tab'] = array('administration'=>true);
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		
		
		//pending request list ---------------------------------------------------------
		$pending_pages = new Paginator('pending_');
		$pending_list_size = Application_request::count_pending();
		//push back the page number and items per page from the attempt to approve an application to administration/application/requests
		$pending_page_select_from_approve_button = $this->session->flashdata('pending_page_select_from_approve_button');
		$pending_items_per_page_from_approve_button = $this->session->flashdata('pending_items_per_page_from_approve_button');
		if($pending_page_select_from_approve_button) {
			$pending_destination_page = $pending_page_select_from_approve_button;
			//return the pending applications of the page before if the application approved was the only one application on the last page
			if($pending_list_size == ($pending_page_select_from_approve_button - 1) * $pending_items_per_page_from_approve_button) {
				$pending_destination_page = $pending_destination_page - 1;
			}
		}
		if($pending_items_per_page_from_approve_button) {
			$pending_items_per_page = $pending_items_per_page_from_approve_button;
		}
		
		//push back the page number and items per page from the attempt to deny an application to administration/application/requests
		$pending_page_select_from_deny_button = $this->session->flashdata('pending_page_select_from_deny_button');
		$pending_items_per_page_from_deny_button = $this->session->flashdata('pending_items_per_page_from_deny_button');
		if($pending_page_select_from_deny_button) {
			$pending_destination_page = $pending_page_select_from_deny_button;
			//return the pending applications of the page before if the application denied was the only one application on the last page
			if($pending_list_size == ($pending_page_select_from_deny_button - 1) * $pending_items_per_page_from_deny_button) {
				$pending_destination_page = $pending_destination_page - 1;
			}
		}
		if($pending_items_per_page_from_deny_button) {
			$pending_items_per_page = $pending_items_per_page_from_deny_button;
		}
		
		//pending request list pagination setup
		$pending_pages->page_setup($pending_bar_page, $pending_jump_page, $pending_items_per_page, $pending_destination_page);
		
		$pending_list = Application_request::find_pending();
				
		$data['pending_list'] = $pending_list;
		$data['pending_items_per_page'] = $pending_items_per_page;
		$data['pending_num_pages'] = ceil($pending_list_size / $pending_items_per_page);
		$data['pending_cur_page'] = $pending_destination_page;
		$pending_pages->items_total = $pending_list_size;
		$pending_pages->current_page = $pending_destination_page;
		$pending_pages->paginate();
		$data['pending_pages'] = $pending_pages;
		
		//approved request list ----------------------------------------------------------
		$approved_pages = new Paginator('approved_');
		$approved_list_size = Application_request::count_approved();
		//push back the page number and items per page on Approved tab
		$approved_page_select_from_approve_button = $this->session->flashdata('approved_page_select_from_approve_button');
		$approved_items_per_page_from_approve_button = $this->session->flashdata('approved_items_per_page_from_approve_button');
		if($approved_page_select_from_approve_button) {
			$approved_destination_page = $approved_page_select_from_approve_button;
			
		}
		if($approved_items_per_page_from_approve_button) {
			$approved_items_per_page = $approved_items_per_page_from_approve_button;
		}
		//push back the page number and items per page on Approved tab
		$approved_page_select_from_deny_button = $this->session->flashdata('approved_page_select_from_deny_button');
		$approved_items_per_page_from_deny_button = $this->session->flashdata('approved_items_per_page_from_deny_button');
		if($approved_page_select_from_deny_button) {
			$approved_destination_page = $approved_page_select_from_deny_button;
			
		}
		if($approved_items_per_page_from_deny_button) {
			$approved_items_per_page = $approved_items_per_page_from_deny_button;
		}
		
		//approved list pagination setup
		$approved_pages->page_setup($approved_bar_page, $approved_jump_page, $approved_items_per_page, $approved_destination_page);
		$approved_list = Application_request::find_approved();
		usort($approved_list, function($a, $b) {
			return strnatcasecmp($a->name, $b->name);
		});

		$data['approved_list'] = $approved_list;
		$data['approved_items_per_page'] = $approved_items_per_page;
		$data['approved_num_pages'] = ceil($approved_list_size / $approved_items_per_page);
		$data['approved_cur_page'] = $approved_destination_page;
		$approved_pages->items_total = $approved_list_size;
		$approved_pages->current_page = $approved_destination_page;
		$approved_pages->paginate();
		$data['approved_pages'] = $approved_pages;
		
		//denied request list --------------------------------------------------------------
		$denied_pages = new Paginator('denied_');
		$denied_list_size = Application_request::count_denied();
		//push back the page number and items per page on Denied tab
		$denied_page_select_from_approve_button = $this->session->flashdata('denied_page_select_from_approve_button');
		$denied_items_per_page_from_approve_button = $this->session->flashdata('denied_items_per_page_from_approve_button');
		if($denied_page_select_from_approve_button) {
			$denied_destination_page = $denied_page_select_from_approve_button;
			
		}
		if($denied_items_per_page_from_approve_button) {
			$denied_items_per_page = $denied_items_per_page_from_approve_button;
		}
		//push back the page number and items per page on Denied tab
		$denied_page_select_from_deny_button = $this->session->flashdata('denied_page_select_from_deny_button');
		$denied_items_per_page_from_deny_button = $this->session->flashdata('denied_items_per_page_from_deny_button');
		if($denied_page_select_from_deny_button) {
			$denied_destination_page = $denied_page_select_from_deny_button;
			
		}
		if($denied_items_per_page_from_deny_button) {
			$denied_items_per_page = $denied_items_per_page_from_deny_button;
		}
		
		//denied list pagination setup
		$denied_pages->page_setup($denied_bar_page, $denied_jump_page, $denied_items_per_page, $denied_destination_page);
		$denied_list = Application_request::find_denied();
		usort($denied_list, function($a, $b) {
			return strnatcasecmp($a->name, $b->name);
		});
		
		$data['denied_list'] = $denied_list;
		$data['denied_items_per_page'] = $denied_items_per_page;
		$data['denied_num_pages'] = ceil($denied_list_size / $denied_items_per_page);
		$data['denied_cur_page'] = $denied_destination_page;
		$denied_pages->items_total = $denied_list_size;
		$denied_pages->current_page = $denied_destination_page;
		$denied_pages->paginate();
		$data['denied_pages'] = $denied_pages;
		
		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		//assign form values
		$form_values = array();
		$form_values['approved_page_select'] = $approved_destination_page;
		$form_values['approved_items_per_page'] = $approved_items_per_page;
		$form_values['pending_page_select'] = $pending_destination_page;
		$form_values['pending_items_per_page'] = $pending_items_per_page;
		$form_values['denied_page_select'] = $denied_destination_page;
		$form_values['denied_items_per_page'] = $denied_items_per_page;
		$data['form_values'] = $form_values;
		
		//use tab access to determine whether to show view at all
		$this->load->view('api/administration/application_requests/all', $data); 
	}
	
	/*
	 * Account request list shows all the pending, approved and denied requests for user accounts.
	 */
	public function account_request_list() {
		$this->verify_access('account_requests');
		$this->load->model('accountrequestmodel');
		$data['title'] = 'Direct API: Account Request List';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		
		$approved_list = $this->accountrequestmodel->get_requests('approved');
		$denied_list = $this->accountrequestmodel->get_requests('denied');
		
		//pending request list -----------------------------------------------------------------------------------
		$pending_pages = new Paginator('pending_');
		$pending_pages->page_setup($pending_bar_page, $pending_jump_page, $pending_items_per_page, $pending_destination_page);
		$pending_size = $this->accountrequestmodel->get_requests_size(null)->result();
		$pending_size = $pending_size[0]->count;
		
		//push back the page number and items per page from the attempt to approve an account request to administration/account/requests
		$pending_page_select_from_approve_button = $this->session->flashdata('pending_page_select_from_approve_button');
		$pending_items_per_page_from_approve_button = $this->session->flashdata('pending_items_per_page_from_approve_button');
		if($pending_page_select_from_approve_button) {
			$pending_destination_page = $pending_page_select_from_approve_button;
			//return the pending account requests of the page before if the account approved was the only one account on the last page
			if($pending_size == ($pending_page_select_from_approve_button - 1) * $pending_items_per_page_from_approve_button) {
				$pending_destination_page = $pending_destination_page - 1;
			}
		}
		if($pending_items_per_page_from_approve_button) {
			$pending_items_per_page = $pending_items_per_page_from_approve_button;
		}
		
		//push back the page number and items per page from the attempt to deny an account request to administration/account/requests
		$pending_page_select_from_deny_button = $this->session->flashdata('pending_page_select_from_deny_button');
		$pending_items_per_page_from_deny_button = $this->session->flashdata('pending_items_per_page_from_deny_button');
		if($pending_page_select_from_deny_button) {
			$pending_destination_page = $pending_page_select_from_deny_button;
			//return the pending account request of the page before if the account request denied was the only one on the last page
			if($pending_size == ($pending_page_select_from_deny_button - 1) * $pending_items_per_page_from_deny_button) {
				$pending_destination_page = $pending_destination_page - 1;
			}
		}
		if($pending_items_per_page_from_deny_button) {
			$pending_items_per_page = $pending_items_per_page_from_deny_button;
		}
		
		$pending_list = $this->accountrequestmodel->get_requests_by_page_number(null, ($pending_destination_page - 1) * $pending_items_per_page + 1, $pending_items_per_page);
		$data['pending_list'] = $pending_list->result();
		//pending request list pagination setup
		$data['pending_items_per_page'] = $pending_items_per_page;
		$data['pending_num_pages'] = ceil($pending_size / $pending_items_per_page);
		$data['pending_cur_page'] = $pending_destination_page;
		$pending_pages->items_total = $pending_size;
		$pending_pages->current_page = $pending_destination_page;
		$pending_pages->paginate();
		$data['pending_pages'] = $pending_pages;
		
		//approved request list -----------------------------------------------------------------------------------
		$approved_pages = new Paginator('approved_');
		$approved_size = $this->accountrequestmodel->get_requests_size('approved')->result();
		$approved_size = $approved_size[0]->count;
		//push back the page number and items per page on the Approved tab
		$approved_page_select_from_approve_button = $this->session->flashdata('approved_page_select_from_approve_button');
		$approved_items_per_page_from_approve_button = $this->session->flashdata('approved_items_per_page_from_approve_button');
		if($approved_page_select_from_approve_button) {
			$approved_destination_page = $approved_page_select_from_approve_button;
			
		}
		if($approved_items_per_page_from_approve_button) {
			$approved_items_per_page = $approved_items_per_page_from_approve_button;
		}
		
		//push back the page number and items per page on the Approved tab
		$approved_page_select_from_deny_button = $this->session->flashdata('approved_page_select_from_deny_button');
		$approved_items_per_page_from_deny_button = $this->session->flashdata('approved_items_per_page_from_deny_button');
		if($approved_page_select_from_deny_button) {
			$approved_destination_page = $approved_page_select_from_deny_button;
			
		}
		if($approved_items_per_page_from_deny_button) {
			$approved_items_per_page = $approved_items_per_page_from_deny_button;
		}
		
		//approved request list pagination setup
		$approved_pages->page_setup($approved_bar_page, $approved_jump_page, $approved_items_per_page, $approved_destination_page);
		/* $approved_list = $this->accountrequestmodel->get_requests_by_page_number('approved', ($approved_destination_page - 1) * $approved_items_per_page + 1, $approved_items_per_page);
		$approved_list->result();
		usort($approved_list->result_object, function($a, $b) {
			return strnatcasecmp($a->first_name.' '.$a->middle_name.' '.$a->last_name, $b->first_name.' '.$b->middle_name.' '.$b->last_name);
		});
		$data['approved_list'] = $approved_list->result(); */
		$data['approved_list'] = array();
		$data['approved_items_per_page'] = $approved_items_per_page;
		$data['approved_num_pages'] = ceil($approved_size / $approved_items_per_page);
		$data['approved_cur_page'] = $approved_destination_page;
		$approved_pages->items_total = $approved_size;
		$approved_pages->current_page = $approved_destination_page;
		$approved_pages->paginate();
		$data['approved_pages'] = $approved_pages;
		
		//denied request list -----------------------------------------------------------------------------------
		$denied_pages = new Paginator('denied_');
		$denied_size = $this->accountrequestmodel->get_requests_size('denied')->result();
		$denied_size = $denied_size[0]->count;
		//push back the page number and items per page on the Denied tab
		$denied_page_select_from_approve_button = $this->session->flashdata('denied_page_select_from_approve_button');
		$denied_items_per_page_from_approve_button = $this->session->flashdata('denied_items_per_page_from_approve_button');
		if($denied_page_select_from_approve_button) {
			$denied_destination_page = $denied_page_select_from_approve_button;
			
		}
		if($denied_items_per_page_from_approve_button) {
			$denied_items_per_page = $denied_items_per_page_from_approve_button;
		}
		
		//push back the page number and items per page on the Denied tab
		$denied_page_select_from_deny_button = $this->session->flashdata('denied_page_select_from_deny_button');
		$denied_items_per_page_from_deny_button = $this->session->flashdata('denied_items_per_page_from_deny_button');
		if($denied_page_select_from_deny_button) {
			$denied_destination_page = $denied_page_select_from_deny_button;
			
		}
		if($denied_items_per_page_from_deny_button) {
			$denied_items_per_page = $denied_items_per_page_from_deny_button;
		}
		
		//denied request list pagination setup
		$denied_pages->page_setup($denied_bar_page, $denied_jump_page, $denied_items_per_page, $denied_destination_page);
		//$denied_list = $this->accountrequestmodel->get_requests_by_page_number('denied', ($denied_destination_page - 1) * $denied_items_per_page + 1, $denied_items_per_page);
		$denied_list = $this->accountrequestmodel->get_requests('denied');
		$denied_list->result();
		usort($denied_list->result_object, function($a, $b) {
			return strnatcasecmp($a->first_name.' '.$a->middle_name.' '.$a->last_name, $b->first_name.' '.$b->middle_name.' '.$b->last_name);
		});
		$data['denied_list'] = $denied_list->result();
		$data['denied_items_per_page'] = $denied_items_per_page;
		$data['denied_num_pages'] = ceil($denied_size / $denied_items_per_page);
		$data['denied_cur_page'] = $denied_destination_page;
		$denied_pages->items_total = $denied_size;
		$denied_pages->current_page = $denied_destination_page;
		$denied_pages->paginate();
		$data['denied_pages'] = $denied_pages;
		
		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		
		//assign form values
		$form_values = array();
		$form_values['approved_page_select'] = $approved_destination_page;
		$form_values['approved_items_per_page'] = $approved_items_per_page;
		$form_values['pending_page_select'] = $pending_destination_page;
		$form_values['pending_items_per_page'] = $pending_items_per_page;
		$form_values['denied_page_select'] = $denied_destination_page;
		$form_values['denied_items_per_page'] = $denied_items_per_page;
		$data['form_values'] = $form_values;
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		//use tab access to determine whether to show view at all
		$this->load->view('api/administration/account_request_list', $data); 
	}
	
	public function approved_account_request_search() {
		$this->verify_access('account_requests');
		$this->load->model('accountrequestmodel');
		
		$active = $this->input->get('active',TRUE);
		$searchbox_input = $this->input->get('sSearch',TRUE);
		$display_start = $this->input->get('iDisplayStart',TRUE);
		$items_per_page = $this->input->get('iDisplayLength',TRUE);
		$sort_col = $this->input->get('iSortCol_0',TRUE);
		$echo = $this->input->get('sEcho',TRUE);
		$destination_page = floor($display_start / $items_per_page) + 1;
		
		$approved_list = $this->accountrequestmodel->get_requests_by_page_number('approved', ($destination_page - 1) * $items_per_page + 1, $items_per_page, $searchbox_input);
		$approved_list->result();
		usort($approved_list->result_object, function($a, $b) {
			return strnatcasecmp($a->first_name.' '.$a->middle_name.' '.$a->last_name, $b->first_name.' '.$b->middle_name.' '.$b->last_name);
		});
		$approved_list = $approved_list->result();
		
		$request_info_array = array();
		foreach($approved_list as $request) {
			$user = '';
			if($request->middle_name) { $user .= $request->first_name.' '.$request->middle_name.' '.$request->last_name; }
			else { $user .= $request->first_name.' '.$request->last_name; }
			if($request->title) { $user .= '<br />'.$request->title; }
			if($request->department) { $user .= '<br />'. $request->department; }
			if($request->organization) { $user .= '<br />'. $request->organization; }
			if($request->user_org_id) { $user .= '<br />ID: '. $request->user_org_id; }
			
			$contact = '';
			if($request->ext_mail) { $contact .= '<a href="mailto:"'.$request->ext_mail.'>'.$request->ext_mail.'</a>'; }
			if($request->telephone) { $contact .= '<br />Phone: '.$request->telephone; }
			if($request->mobile) { $contact .= '<br />Mobile: '.$request->mobile; }
			if($request->location) { $contact .= '<br />'. $request->location; }
			
			$request_date = date("M d Y H:i:s",$request->request_date);
			
			$approved_date = date("M d Y H:i:s",$request->approved_date);
			
			$request_info = array($user, $contact, $request_date, $approved_date);
			
			array_push($request_info_array, $request_info);
		}
		$approved_account_request_list_size = $this->accountrequestmodel->get_size_of_approved_account_request_list($searchbox_input)->result()[0]->count;
		$output = array (
				"sEcho" => $echo,
				"iTotalRecords" => $approved_account_request_list_size,
				"iTotalDisplayRecords" => $approved_account_request_list_size,
				"aaData" => $request_info_array
		);
		echo json_encode( $output );
	}
	
	/* This function loads the manage accounts view and provides it with the account data
	 */
	public function admin_manage_accounts() {
		$this->verify_access('manage_accounts');
		$data['title'] = 'Direct API: Manage Accounts';
		$data['view'] = 'account_list';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$is_admin = (isset($permissions['API']['admins']) && $permissions['API']['admins']);
		$data['create_account_show'] = $is_admin || in_array('create_account', $permissions['Permission']); //only show create account to API admins
		$data['action_permission'] = $is_admin || in_array('disable_account', $permissions['Permission']);
		$data['account_permission'] = $is_admin || in_array('account_account', $permissions['Permission']);
		
		User::where_user_is_active();
		$data['users_total'] = User::count();
		User::where_user_is_active()->order_by('username')->limit(ITEMS_PER_PAGE_DEFAULT);
		$data['users'] = User::find();
		
		User::where_user_is_disabled();
		$data['disabled_users_total'] = User::count();
		User::where_user_is_disabled()->order_by('username')->limit(ITEMS_PER_PAGE_DEFAULT);
		$data['disabled_users'] = User::find();

		//create account form data
		$data['first_name'] = $this->session->flashdata('first_name');
		$data['middle_name'] = $this->session->flashdata('middle_name');
		$data['last_name'] = $this->session->flashdata('last_name');
		$data['user_name'] = $this->session->flashdata('user_name');
		$data['user_org_id'] = $this->session->flashdata('user_org_id');
		$data['ext_mail'] = $this->session->flashdata('ext_mail');
		$data['account_title'] = $this->session->flashdata('account_title');
		$data['department'] = $this->session->flashdata('department');
		$data['organization'] = $this->session->flashdata('organization');
		$data['telephone'] = $this->session->flashdata('telephone');
		$data['mobile'] = $this->session->flashdata('mobile');
		$data['location'] = $this->session->flashdata('location');
		$data['facility_select'] = $this->session->flashdata('facility_select');
		$data['domain_select'] = $this->session->flashdata('domain_select');

		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}

		$data['facility_options'] = array('' => '&nbsp;');
		foreach($this->facilitymodel->get_facilities(true)->result() as $facility){
			$data['facility_options'][$facility->id] = $facility->name;
		}

		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		$this->load->view('api/administration/manage_accounts', $data);
	}
	
	public function admin_account_search() {
		//set permission, will be necessary for formatting search result output
		$this->verify_access('manage_accounts');
		$permissions = $this->account_permissions;
		$is_admin = (isset($permissions['API']['admins']) && $permissions['API']['admins']);
		$disable_permission = $is_admin || in_array('disable_account', $permissions['Permission']);
		$enable_permission = $is_admin || in_array('disable_account', $permissions['Permission']);
		$account_permission = $is_admin || in_array('account_account', $permissions['Permission']);
		
		//get search parameters
		$searchbox_input = strtolower($this->input->get('sSearch',TRUE));
		$display_start = $this->input->get('iDisplayStart',TRUE);
		$items_per_page = $this->input->get('iDisplayLength',TRUE);
		$sort_col = $this->input->get('iSortCol_0',TRUE);
		$echo = $this->input->get('sEcho',TRUE);
		$active = $this->input->get('active',TRUE);
		$destination_page = $display_start / $items_per_page + 1;
		$suffix = 'inactive';
		if($active == 'true') {
			$suffix = 'active';
		}
		
		$status = ($active == 'true') ? 'active' : 'disabled';
		$action_permission = ($active == 'true') ? $disable_permission : $enable_permission;
		
		//if the active vs. inactive filter is on we will need to search different sources
		if($active == 'true')
			User::where_user_is_active();
		else
			User::where_user_is_disabled();

			User::db()->order_by('username');
				
		if($active == 'true')
			User::where_user_is_active();
		else
			User::where_user_is_disabled();
		$users = User::find();

		if($searchbox_input){
			$filtered_users = array();
			foreach($users as $key => $user){
				
				//check to see if the search input matches something that we can get from the database - if so, we're done.
				if( string_contains($searchbox_input, strtolower($user->username)) || string_contains($searchbox_input, strtolower($user->user_org_id)) ||
					string_contains($searchbox_input, strtolower($user->user_ext_mail))){
					$filtered_users[$key] = $user; 
					continue; 
				}
				
				//if we didn't find the result against a db value, check against ldap.  (Doing this second to minimize the number of ldap lookups)
				foreach(array( 'cn', 'title', 'departmentnumber', 'o', 'physicaldeliveryofficename', 'telephonenumber', 'mobile', 'user_ext_mail') as $field){
					if(!empty($user->ldap_info->$field) && (string_contains($searchbox_input,strtolower($user->ldap_info->$field)))){
						$filtered_users[$key] = $user;
						break;
					}
				}

			}
			$users = $filtered_users;
		}
		$paginated_accounts = array_slice($users, ($destination_page - 1) * $items_per_page, $items_per_page, TRUE);
		$user_info_array = array();
		foreach($paginated_accounts as $user) {
			$user_info = array(
								'<a href="/administration/manage/accounts/edit/' . $user->user_id . '">' . $user->username . '</a>', 
								$user->user_org_id, 
								$this->load->view('api/administration/manage_accounts/_account_details', compact('user', 'status'), TRUE),
								implode('<br>', $user->applications), 
								$this->load->view('api/administration/manage_accounts/_account_actions', compact('user', 'status', 'action_permission', 'account_permission'), TRUE)
							);
							$user_info_array[] = $user_info;
		}
				
		$output = array (
			"sEcho" => $echo,
			"iTotalRecords" => sizeof($users),
			"iTotalDisplayRecords" =>sizeof($users),
			"aaData" => $user_info_array
		);
		
		echo json_encode( $output );
	}
	
	/* This function loads the edit account view and provides the data for the user
	 * specified by the user id parameter
	 */
	public function admin_edit_account($user_id) {
		$this->verify_access('manage_accounts');
		$data['title'] = 'Direct API: Manage Accounts';
		$data['view'] = 'account_edit';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$data['user'] = $this->usersmodel->get_user($user_id);
		//get facilitiy list and the facility associated with the user if any
		$data['facility_select'] = $this->usersettingsmodel->get_facility_id_in_mailbox($data['user']->username, false);
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();

		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		$this->load->view('api/administration/manage_accounts', $data);
	}
	
	/* This function loads the edit account access view and provides the data for the user
	 * specified by the user id parameter
	 */
	public function admin_edit_account_access($user_id) {
		$this->verify_access('account_permissions');
		$data['title'] = 'Direct API: Manage Accounts';
		$data['view'] = 'account_edit_access';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$data['user'] = $this->usersmodel->get_user($user_id);
                $data['group_descriptions'] = $this->usersmodel->get_group_descriptions(); 
		
                $user_groups = $this->usersmodel->get_allowed_groups_for_access($permissions);
                $group_types = $user_groups['group_types']; 
                
                $assigned_groups = $data['user']->group_types['groups'];
                $assigned_roles = $data['user']->group_types['roles'];
                $assigned_applications = $data['user']->group_types['applications'];
                
                natcasesort($assigned_groups);
                natcasesort($assigned_roles); 
                natcasesort($assigned_applications);
                
		$accessible_groups = $group_types['groups'];
                $accessible_roles = $group_types['roles'];
                $accessible_applications = $group_types['applications']; 
                
		natcasesort($accessible_groups);
                natcasesort($accessible_applications);
                natcasesort($accessible_roles); 
                		
                $available_groups = array_diff($accessible_groups, $assigned_groups); 
                $available_roles =  array_diff($accessible_roles , $assigned_roles); 
                $available_applications = array_diff($accessible_applications, $assigned_applications ); 
                
		natcasesort($available_groups);
                natcasesort($available_applications); 
                natcasesort($available_roles); 
                
		$data['available_groups'] = $available_groups;
		$data['accessible_groups'] = $accessible_groups;
                $data['assigned_groups'] = $assigned_groups;
                
                $data['available_roles'] = $available_roles; 
                $data['accessible_roles'] = $accessible_roles; 
                $data['assigned_roles'] = $assigned_roles; 
                
                $data['accessible_applications'] = $accessible_applications; 
                $data['available_applications'] = $available_applications; 
                $data['assigned_applications'] = $assigned_applications; 
                            
 		$this->load->view('api/administration/manage_accounts', $data);
	}
	
	/* Save account data from account edit form
	 */
	public function account_edit_save() {
		$this->verify_access('edit_account');
		$this->load->library('form_validation');
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$cur_user=$this->usersmodel->get_user_id_from_org_id($id);
		//TO-DO: which groups should have permissions to edit this account data?
		//we may want to check if a user has authorized their account data to be editable by an app and allow it
		//but for now let's restrict it to API admins only
		if($data['show']['administration'] && $data['admin_show']['manage_accounts'] && $permissions['API']['admins']  || $data['show']['acct_group_maint']) {
			$first = $this->input->post('first_name', TRUE);
			$middle = $this->input->post('middle_name', TRUE);
			$last = $this->input->post('last_name', TRUE);
			$ext_mail = $this->input->post('ext_mail', TRUE);
			$title = $this->input->post('title', TRUE);
			$department = $this->input->post('department', TRUE);
			$organization = $this->input->post('organization', TRUE);
			$telephone = $this->input->post('telephone', TRUE);
			$mobile = $this->input->post('mobile', TRUE);
			$location = $this->input->post('location', TRUE);
			$facility_id = $this->input->post('facility_select', TRUE);
			$user_id = $this->input->post('user_id', TRUE);
			
			$this->form_validation->set_rules('first_name','First Name','required');
			$this->form_validation->set_rules('last_name','Last Name','required');
			$this->form_validation->set_rules('ext_mail','Email','required|va_email');
			$this->form_validation->set_rules('telephone','Telehone','validate_phone');
			$this->form_validation->set_rules('mobile','Mobile','validate_phone');
			$this->form_validation->set_rules('facility_select','Facility','required|valid_facility');
			
			
			if($this->form_validation->run() === TRUE) {
				if(is_numeric($user_id)) {
					$username = $this->usersmodel->get_username_from_id($user_id);
					if($username) {
						$attributes = array(
							'cn' => $first . ' ' . $last,
							'givenName' => $first,
							'initials' => $middle,
							'sn' => $last,
							'title' => $title,
							'departmentNumber' => $department,
							'o' => $organization,
							'telephoneNumber' => $telephone,
							'mobile' => $mobile,
							'physicalDeliveryOfficeName' => $location,
						);
						//set optional attributes / attributes that depend on optional attributes
						if(isset($middle) && !empty(trim($middle))){ 
							$attributes['initials'] = $middle;
							$attributes['displayName'] = $last.', '.$first.' '.$middle;							
						}
						else { $attributes['displayName'] = $last.', '.$first; }
						$result = $this->usersmodel->update_user($user_id,$ext_mail,$facility_id,$attributes);
						if(!$result || in_array(FALSE,$result)) {
							$this->session->set_flashdata('error_message','Account information failed to saved properly.');
							$this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Edit user", time(), 0);
						}
						else { $this->session->set_flashdata('success_message','Account information saved.');  $this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Edit user", time(), 1); }
					}
					else { $this->session->set_flashdata('success_message','Account information saved.');  $this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Edit user", time(), 1); }
				}
			}
			else{
				$this->session->set_flashdata('error_message',validation_errors());
				$this->session->set_flashdata('first_name', $first);
				$this->session->set_flashdata('middle_name', $middle);
				$this->session->set_flashdata('last_name', $last);
				$this->session->set_flashdata('ext_mail', $ext_mail);
				$this->session->set_flashdata('account_title', $title);
				$this->session->set_flashdata('department', $department);
				$this->session->set_flashdata('organization', $organization);
				$this->session->set_flashdata('telephone', $telephone);
				$this->session->set_flashdata('mobile', $mobile);
				$this->session->set_flashdata('location', $location);
				$this->session->set_flashdata('facility_select', $facility_id);
			}
			redirect('administration/manage/accounts/edit/'.$user_id);
		}
		
		
	}
	
	/* Save account group membership data from account access edit form
	 */
	public function account_edit_access_save() {
 		$this->verify_access('account_permissions');
		$id = User::organization_id_from_session();
		$cur_user=$this->usersmodel->get_user_id_from_org_id($id);
		$groups = $this->input->post('groups',TRUE);
		$action = $this->input->post('action',TRUE); //find out if we are adding or removing
		$user_id = $this->input->post('user_id',TRUE);
		if(!is_numeric($user_id)) { show_404(); } //don't waste time if they are manipulating user id
		
		$username = $this->usersmodel->get_username_from_id($user_id); //easy way to check if user exists
		if($username) {
			foreach($groups as $group) {
				if($action === 'add') { 
					$response = $this->usersmodel->change_group_membership($action,$user_id,$group);
					$this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Access added ".$group , time(), $response);
				}
				if($action === 'remove') {
					$response = $this->usersmodel->change_group_membership($action,$user_id,$group);
					$this->eventlog->create_event( 3,$user_id,3 ,$cur_user, "Access removed ".$group, time(), $response);
				}
			}
		}
		redirect('administration/manage/accounts/edit/access/'.$user_id);
	}
	
	/*
	 * Approve request is called when an admin approves a request and copies the request into the applications table. 
	 */
	public function approve_request()
	{
		$this->verify_access('manage_application_requests');
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$this->load->library('email');
		$permissions = $this->account_permissions;
		$user_id=$this->usersmodel->get_user_id_from_org_id($id);
		$request_id = $this->input->post('request_id', TRUE);
		
		//push back the page number and items per page from the attempt to approve an application to administration/application/requests
		$this->session->set_flashdata('pending_page_select_from_approve_button',$this->input->post('pending_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('pending_items_per_page_from_approve_button',$this->input->post('pending_items_per_page_from_approve_button',TRUE));
		$this->session->set_flashdata('approved_page_select_from_approve_button',$this->input->post('approved_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('approved_items_per_page_from_approve_button',$this->input->post('approved_items_per_page_from_approve_button',TRUE));
		$this->session->set_flashdata('denied_page_select_from_approve_button',$this->input->post('denied_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('denied_items_per_page_from_approve_button',$this->input->post('denied_items_per_page_from_approve_button',TRUE));
		
		//use permissions to determine whether to allow function call at all
						
			//make sure the id is specified
			if(!empty(trim($request_id))){
				
				//get app pocs/requestor emails
				$emails = $this->usersmodel->get_request_emails($request_id);
				
				//grab the request
				$request = Application_request::find_one($request_id);
				if(Application_request::is_an_entity($request)) {
					//pull the request fields to copy to application
					$request_array = $request->values();
					$name = $request_array['name'];
					$url = $request_array['url'];
					$desc = $request_array['description'];
					$poc_name = $request_array['poc_name'];
					$poc_email = $request_array['poc_email'];
					$poc_phone = $request_array['poc_phone'];
					$requestor = $request_array['requestor'];
					
					//create public and private keys
					$public_exist = true;
					$private_exist = true;
					
					//while the public key exists in db generate a new one
					while ($public_exist){
						$public = hash('sha256', openssl_random_pseudo_bytes(32));
						$query = $this->applicationmodel->get_application_from_public($public);
						if ($query !== false && $query->num_rows() === 0){
							$public_exist = false;
						}
					}
					
					//while the private key exists in the db generate a new one
					while ($private_exist){
						$private = hash('sha256', openssl_random_pseudo_bytes(32));
						$query = $this->applicationmodel->get_application_from_private($private);
						if ($query !== false && $query->num_rows() === 0){
							$private_exist = false;
						}
					}
				
					//create the application record
					
					if($this->applicationmodel->create_application($public, $private, $name, $requestor, $url, $desc, $poc_name, $poc_email, $poc_phone, $request_id)) {
						$application_request = Application_request::find_one($request_id);
						if($application_request->approve()){
							$message = 'Request for application "'.$application_request->name.'" has been approved.';
							$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Approve application", time(), 1);
						}else{
							$message = 'An error occured and application "'.$application_request->name.'" was not approved.  Please try again in a moment, and contact the site administrators if the problem persists.';
							$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Approve application", time(), 0);
						}
					}
					else { 
						$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Approve application", time(), 0);
						$error_message = 'Request for application "'.$name.'" approval failed to submit.'; 
						$this->session->set_flashdata('error_message',$error_message);
					}
				}
				//note that no request exists for the id
				else {
					$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Approve application", time(), 0);
					$message = 'No request exists for id "'.$request_id.'".';
				}
			}
			//id is a required field
			else {
				$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Approve application", time(), 0);
				$message = 'Request id is a required field.';
			}			
			
			if(!empty($message))
				$this->session->set_flashdata('success_message',$message);
			redirect('administration/application/requests');
	}
	
	/* Approve Account Request is called when an admin approves an account request.
     * It uses the Admin API to create a user account using the information provided in the request.
	 */
	public function approve_account_request() {
		$this->verify_access('manage_account_requests');
		$this->load->library('email');
		$this->load->model(array('accountrequestmodel', 'applicationaccountlinkmodel'));

		//NOTE TO FUTURE DEVELOPERS - Form data should be stored in POST - don't follow this method's example and refactor when we get a chance.  (Flashdata is not persistent by design, so POST is more reliable -- MG 2015-10-20)
		//push back the page number and items per page from the attempt to approve an account to administration/account/requests
		$this->session->set_flashdata('pending_page_select_from_approve_button',$this->input->post('pending_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('pending_items_per_page_from_approve_button',$this->input->post('pending_items_per_page_from_approve_button',TRUE));
		$this->session->set_flashdata('approved_page_select_from_approve_button',$this->input->post('approved_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('approved_items_per_page_from_approve_button',$this->input->post('approved_items_per_page_from_approve_button',TRUE));
		$this->session->set_flashdata('denied_page_select_from_approve_button',$this->input->post('denied_page_select_from_approve_button',TRUE));
		$this->session->set_flashdata('denied_items_per_page_from_approve_button',$this->input->post('denied_items_per_page_from_approve_button',TRUE));
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$user_id = $this->usersmodel->get_user_id_from_org_id($id);
		$request_id = $this->input->post('request_id', TRUE);
		//use permissions to determine whether to allow function call at all
			//make sure the id is specified
			if(!empty(trim($request_id))){
				//grab the request
				$request = $this->accountrequestmodel->get_request($request_id);
				if($request) {
					//pull the request fields to copy to account
					$request_array = $request->row_array();
					$username = (isset($request_array['username']) && Mailbox::name_is_available($request_array['username'])) ? $request_array['username'] : User::new_username($request_array['first_name'],$request_array['last_name']);
					$fields = array(
						'username' => $username,
						'first' => $request_array['first_name'],
						'middle' => $request_array['middle_name'],
						'last' => $request_array['last_name'],
						'mail' => $request_array['ext_mail'],
						'title' => $request_array['title'],
						'department' => $request_array['department'],
						'organization' => $request_array['organization'],
						'telephone' => $request_array['telephone'],
						'mobile' => $request_array['mobile'],
						'location' => $request_array['location'],
						'facility_id' => $request_array['facility_id'],
						'id' => $request_array['user_org_id'],
						'domain' => $request_array['domain'],
					);
					$emails = $request_array['ext_mail']; //set To line
					
					//mark request approved
					if($this->accountrequestmodel->approve_request($request_id)) {
						$response = $this->create_user($fields);
						
											
						$json = $this->json->decode($response['json']);
						if($response['status'] === 200) {
							$user = User::find_one(array('username' => $json->username));

							$mail_subject = 'Request for account has been approved.';

							$mail_message = "Hello,\r\n\r\nYour account has been approved for access.\r\n\r\n* Username: ".$user->username."\r\n* Address:  ".$user->email_address()."\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE;
							$this->external_email->to($emails);
							$this->external_email->subject($mail_subject); 
							$this->external_email->message($mail_message); 
							$this->external_email->send();
							
							//Adding Permission access to mail box
							$user_org_id_permission = $request_array['user_org_id'];
							$result_app_id = $this->applicationaccountlinkmodel->get_request_app_id($user_org_id_permission)->result();
							if($result_app_id) {
								$mailbox_id = $result_app_id[0]->id;
								$app_id = $result_app_id[0]->app_id;
								$value = "";
								$user_permissions = array();
								if(!empty($result_app_id[0]->system_permissions))
									$user_permissions = $this->json->decode($result_app_id[0]->system_permissions, true);
								foreach ($user_permissions as $key => $value ) {
									$web_service_id = $this->usersettingsmodel->get_web_service_id_by_name($key);
									$this->usersettingsmodel->save_mailbox_settings_entry($mailbox_id, $app_id, $web_service_id, $value);
								}
							}	
							$target_id = $this->usersmodel->get_user_id_from_org_id($request_array['user_org_id']);
							$this->eventlog->create_event( 3,$target_id ,3 ,$user_id, "Approve user", time(), 1);
							$this->session->set_flashdata('success_message',$json->message);
						}
						else {
							$this->eventlog->create_event( 4,$request_id ,3 ,$user_id, "Approve user", time(), 0);
							$this->accountrequestmodel->unapprove_request($request_id); //set request back to unapproved if create fails
							$this->session->set_flashdata('error_message',$json->message);
						}
					}
					else {
						$this->eventlog->create_event( 4,$request_id ,3 ,$user_id, "Approve user", time(), 0);
						$this->session->set_flashdata('error_message','Failed to approve request.');
					}
				}
				else{
					$message = 'No request exists for id "'.$request_id.'".';
					$this->eventlog->create_event( 4,$request_id ,3 ,$user_id, "Approve user", time(), 0);
				}
			}
			else{
				$this->session->set_flashdata('error_message','Request id is a required field.');
				$this->eventlog->create_event( 4,$request_id ,3 ,$user_id, "Approve user", time(), 0);
			}
			
			redirect('administration/account/requests');
	}
	
	/* This function is called when an admin creates an account manually.
	 * It uses the Admin API to create a user account using the information provided in the form.
	*/
	public function create_account() {
		$this->verify_access('create_account');
		$this->load->library('form_validation');
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$user_id=$this->usersmodel->get_user_id_from_org_id($id);
			
		//get field values from the form
		$first_name = $this->input->post('first_name', TRUE);
		$middle_name = $this->input->post('middle_name', TRUE);
		$last_name = $this->input->post('last_name', TRUE);
		$user_name = $this->input->post('user_name', TRUE);
		$mail = $this->input->post('ext_mail', TRUE);
		$account_title = $this->input->post('account_title', TRUE);
		$department = $this->input->post('department', TRUE);
		$organization = $this->input->post('organization', TRUE);
		$telephone = $this->input->post('telephone', TRUE);
		$mobile = $this->input->post('mobile', TRUE);
		$location = $this->input->post('location', TRUE);
		$user_org_id = $this->input->post('user_org_id', TRUE);
		$facility_id = $this->input->post('facility_select', TRUE);
		$domain = $this->input->post('domain_select', TRUE);

		//use permissions to determine whether to allow function call at all
			//set validation for the fields
			$this->form_validation->set_rules('user_name','Username','required|allowed_mailbox_characters|unique_username|max_length[50]');
			$this->form_validation->set_rules('user_org_id','ID','required|numeric|unique_user_org_id');
			$this->form_validation->set_rules('first_name','First Name','required');
			$this->form_validation->set_rules('last_name','Last Name','required');
			$this->form_validation->set_rules('facility_select','Facility','required|valid_facility');
			$this->form_validation->set_rules('ext_mail','Email','required|va_email');
			$this->form_validation->set_rules('telephone','Telehone','validate_phone');
			$this->form_validation->set_rules('mobile','Mobile','validate_phone');

			$allowed_domains = implode(',', valid_domains());
			$this->form_validation->set_rules('domain_select', 'Domain', "required|in_list[$allowed_domains]");

			if($this->form_validation->run() === TRUE) {
				$fields = array(
						'username' => $user_name,
						'first' => $first_name,
						'middle' => $middle_name,
						'last' => $last_name,
						'mail' => $mail,
						'title' => $account_title,
						'department' => $department,
						'organization' => $organization,
						'telephone' => $telephone,
						'mobile' => $mobile,
						'location' => $location,
						'id' => $user_org_id,
						'facility_id' => $facility_id,
						'domain' => $domain
				);

				//mark account created
				$response = $this->create_user($fields);
				$json = $this->json->decode($response['json']);
				if($response['status'] === 200) {
					$this->load->model('accountrequestmodel');
					$target_id = $this->usersmodel->get_user_id_from_org_id($user_org_id);
					$this->eventlog->create_event(3, $target_id, 3,$user_id, "Create account", time(), 1);
					$this->session->set_flashdata('success_message',$json->message);
					$message = 'Account Name, ' . $user_name . ', for ' . $first_name . ' ' . $last_name . ' has been created successfully.';
					$this->accountrequestmodel->create_request($first_name, $middle_name, $last_name, $mail, $account_title, $department, $organization, $telephone, $mobile, $location , $facility_id, $user_org_id,$user_name,$domain);
					$r_id=$this->accountrequestmodel->get_ids($user_org_id);
					if($r_id){
						$r_id = $r_id->result();
						$this->accountrequestmodel->approve_request($r_id[0]->id);
						//save facility
						$this->usersettingsmodel->update_facility_id_in_mailbox($user_name, false, $facility_id);
					}
					else{
						$this->session->set_flashdata('error_message','Failed to find request');
					}
				}
				else {
					$this->eventlog->create_event(3, 0, 3,$user_id, "Create account", time(), 0);
					$this->session->set_flashdata('error_message',$json->message);
				}
				
			}
			else {
				$this->session->set_flashdata('error_message',validation_errors());
				$this->session->set_flashdata('first_name', $first_name);
				$this->session->set_flashdata('middle_name', $middle_name);
				$this->session->set_flashdata('last_name', $last_name);
				$this->session->set_flashdata('user_name', $user_name);
				$this->session->set_flashdata('user_org_id', $user_org_id);
				$this->session->set_flashdata('ext_mail', $mail);
				$this->session->set_flashdata('account_title', $account_title);
				$this->session->set_flashdata('department', $department);
				$this->session->set_flashdata('organization', $organization);
				$this->session->set_flashdata('telephone', $telephone);
				$this->session->set_flashdata('mobile', $mobile);
				$this->session->set_flashdata('location', $location);
				$this->session->set_flashdata('facility_select', $facility_id);
				$this->session->set_flashdata('domain_select', $domain);
			}
		
		redirect('administration/manage/accounts/#create');
	}
	
	/*
	 * 
	 * Deny request is called when an admin denies an application.
	 * 
	 */
	public function deny_request()
	{
		$this->verify_access('manage_application_requests');
		$this->load->library('email');
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$request_id = $this->input->post('request_id', TRUE);
		$user_id=$this->usersmodel->get_user_id_from_org_id($id);
		
		//push back the page number and items per page from the attempt to deny an application to administration/application/requests
		$this->session->set_flashdata('pending_page_select_from_deny_button',$this->input->post('pending_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('pending_items_per_page_from_deny_button',$this->input->post('pending_items_per_page_from_deny_button',TRUE));
		$this->session->set_flashdata('approved_page_select_from_deny_button',$this->input->post('approved_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('approved_items_per_page_from_deny_button',$this->input->post('approved_items_per_page_from_deny_button',TRUE));
		$this->session->set_flashdata('denied_page_select_from_deny_button',$this->input->post('denied_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('denied_items_per_page_from_deny_button',$this->input->post('denied_items_per_page_from_deny_button',TRUE));
		
		//use permissions to determine whether to allow function call at all
		if(!empty(trim($request_id))){

			//grab the request
			$application_request = Application_request::find_one($request_id);
			if(Application_request::is_an_entity($application_request)) {
				$name = $application_request->name;
				$reason = $this->input->post('reason', TRUE);
				
				//process the denial, set a flag in the request table
				if($application_request->deny($reason)) {
					$message = 'Request for application "'.$name.'" has been denied.';
					$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Deny application", time(), 1);
				}
				else {
					$message = 'Failed to deny request for application "'.$name.'".';
					$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Deny application", time(), 0);
				}
			}
			//no request exists for the id
			else{
				$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Deny application", time(), 0);
				$message = 'No request exists for id "'.$request_id.'".';
			}
		}
		//must specify an id
		else{
			$this->eventlog->create_event( 1,$request_id ,3 ,$user_id, "Deny application", time(), 0);
			$message = 'Request id is a required field.';
		}
		$this->session->set_flashdata('message',$message);
		redirect('administration/application/requests');
		
	}
	
	/* Deny account request is called when an admin denies a user account.
	 * It set the denied flag for the given request to TRUE in the database.
	 */
	public function deny_account_request() {
		$this->verify_access('manage_account_requests');
		$this->load->library('email');
		$this->load->model('accountrequestmodel');
		
		//push back the page number and items per page from the attempt to deny an account request to administration/account/requests
		$this->session->set_flashdata('pending_page_select_from_deny_button',$this->input->post('pending_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('pending_items_per_page_from_deny_button',$this->input->post('pending_items_per_page_from_deny_button',TRUE));
		$this->session->set_flashdata('approved_page_select_from_deny_button',$this->input->post('approved_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('approved_items_per_page_from_deny_button',$this->input->post('approved_items_per_page_from_deny_button',TRUE));
		$this->session->set_flashdata('denied_page_select_from_deny_button',$this->input->post('denied_page_select_from_deny_button',TRUE));
		$this->session->set_flashdata('denied_items_per_page_from_deny_button',$this->input->post('denied_items_per_page_from_deny_button',TRUE));
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$user_id = $this->usersmodel->get_user_id_from_org_id($id);
		$request_id = $this->input->post('request_id', TRUE);
		$request = $this->accountrequestmodel->get_request($request_id)->result();
		//use permissions to determine whether to allow function call at all
		
			$justification = $this->input->post('reason',TRUE);
			
			$emails = $request[0]->ext_mail; //set To line

			//attempt to deny request
			if(!empty(trim($request_id))){
				if(!$this->accountrequestmodel->deny_request($request_id,$justification)) {
					$this->session->set_flashdata('error_message','Failed to deny account request');
					$this->eventlog->create_event(4, $request_id, 3, $user_id, "Deny user", time(), 0);
				}
				else{
					$name = $request[0]->first_name . ' ' . $request[0]->last_name;
					$message = 'Request for account "'.$name.'" has been denied.';
					
					$mail_subject = 'Request for account has been denied.';
					$mail_message = "Hello,\r\n\r\nYour account request has been denied for the following reason:\r\n".$justification."\r\n\r\nThank you,\r\n\r\n".EMAIL_SIGNATURE;
					
					$this->external_email->to($emails);
					$this->external_email->subject($mail_subject); 
					$this->external_email->message($mail_message); 
					$this->external_email->send();	

					$this->eventlog->create_event(4, $request_id, 3, $user_id, "Deny user", time(), 1);
				}
			}
			else{
				$this->session->set_flashdata('error_message','Request id is a required field');
				$this->eventlog->create_event(4, $request_id, 3, $user_id, "Deny user", time(), 0);
			}
		$this->session->set_flashdata('message',$message);
		redirect('administration/account/requests');
	}
	
	/* This function takes the provided user id from POST input and deactivates the user
	 * associated with it if permissions to do so are present for the current user.
	 */
	public function disable_account() {
		$this->verify_access('disable_account');
		//find the account that we're going to deactivate
		$user_id = $this->input->post('user_id',TRUE);
		if(!User::formatted_like_an_id($user_id)) return $this->error->should_be_a_user_id($user_id); //don't attempt to log this - if it's not a user id, then it isn't a valid db value and the query will just fail
		
		$user_to_deactivate = User::find_one($user_id);
		if(!$user_to_deactivate->active){
			$this->eventlog->create_event( 3, $user_id, 3, $this->user->id(), "Disable account", time(), 0);
			$this->session->set_flashdata('error_message', 'Account '.$user_to_deactivate->username.' has already been disabled.');
			redirect('administration/manage/accounts');
		}
				
		//push back the page number and items per page from the attempt to disable user to administration/manage/accounts
		$this->session->set_flashdata('accounts_page_select_from_disable_user_session',$this->input->post('accounts_page_select_from_disable_user_session',TRUE));
		$this->session->set_flashdata('accounts_items_per_page_from_disable_user_session',$this->input->post('accounts_items_per_page_from_disable_user_session',TRUE));
		$this->session->set_flashdata('deactivated_page_select_from_disable_user_session',$this->input->post('deactivated_page_select_from_disable_user_session',TRUE));
		$this->session->set_flashdata('deactivated_items_per_page_from_disable_user_session',$this->input->post('deactivated_items_per_page_from_disable_user_session',TRUE));
		
		//get org id of the user being acted upon to compare to the current user - a user can't disable their own account
		if($user_to_deactivate->user_org_id === $this->user->user_org_id) { 
			$this->eventlog->create_event( 3, $user_id, 3, $this->user->id(), "Disable account", time(), 0);
			$this->session->set_flashdata('error_message', 'Cannot disable the logged in account.');
			redirect('administration/manage/accounts');
		}
		else {
			$permissions = $this->user->permissions();
			
				if($user_to_deactivate->deactivate()) {
					$this->session->set_flashdata('message','Account '.$user_to_deactivate->username.' has been disabled.');
					$this->eventlog->create_event( 3,$user_id,3, $this->user->id(), "Disable account", time(), 1);
					redirect('administration/manage/accounts');
				}
				else { 
					$this->session->set_flashdata('error_message','Failed to disable account '.$user_to_deactivate->username); 
					$this->eventlog->create_event( 3, $user_id, 3, $this->user->id(), "Disable account", time(), 0);
					redirect('administration/manage/accounts');
				}
			
		}
	}
	
	/* This function takes the provided user id from POST input and activates the user
	 * associated with it if permissions to do so are present for the current user.
	 */
	public function enable_account() {
		$this->verify_access('enable_account');
		$user_id = $this->input->post('user_id',TRUE);
		if(!User::formatted_like_an_id($user_id)) return $this->error->should_be_a_user_id($user_id); //don't attempt to log this - if it's not a user id, then it isn't a valid db value and the query will just fail
		
		$user_to_activate = User::find_one($user_id);
		if($user_to_activate->is_active){
			$this->session->set_flashdata('success_message','Account '.$user_to_activate->username.' is already enabled.');
			$this->eventlog->create_event( 3,$user_id,3 ,$this->user->id(), "Enable account", time(), 0);
			redirect('administration/manage/accounts#deactivated');		
		}
		
		//push back the page number and items per page from the attempt to enable account to administration/manage/accounts
		$this->session->set_flashdata('deactivated_page_select_from_enable_user_session',$this->input->post('deactivated_page_select_from_enable_user_session',TRUE));
		$this->session->set_flashdata('deactivated_items_per_page_from_enable_user_session',$this->input->post('deactivated_items_per_page_from_enable_user_session',TRUE));
		$this->session->set_flashdata('accounts_page_select_from_enable_user_session',$this->input->post('accounts_page_select_from_enable_user_session',TRUE));
		$this->session->set_flashdata('accounts_items_per_page_from_enable_user_session',$this->input->post('accounts_items_per_page_from_enable_user_session',TRUE));
		
		$permissions = $this->user->permissions();
				
			if($user_to_activate->activate()) {
				$this->session->set_flashdata('success_message','Account '.$user_to_activate->username.' has been enabled.');
				$this->eventlog->create_event( 3,$user_id,3 ,$this->user->id(), "Enable account", time(), 1);
				redirect('administration/manage/accounts#deactivated');
			}
			else { $this->session->set_flashdata('error_message','Failed to enable disabled account '.$user_to_activate->username.'.'); $this->eventlog->create_event( 3,$user_id,3 ,$this->user->id(), "Enable account", time(), 0);}
		
	}

	/* This function loads the manage group view and provides it with the account data
	 */
	public function admin_manage_groups() {
		$this->verify_access('manage_groups');
		$permissions = $this->account_permissions;
 		require_model('group');
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		//SET UP THE CREATE FORM 
		if((isset($permissions['API']['admins']) && $permissions['API']['admins']) || $permissions['Role'][0] == "accountgroupmaintenance"){
			//find facility options
			$facility_options = array('' => '&nbsp;');
			foreach($this->facilitymodel->get_facilities(true)->result() as $facility){
				$facility_options[$facility->id] = $facility->name;
			}
			
			//set up markup generator to create a new group
			require_library('form_markup_generator');
			$markup_generator = new Form_markup_generator();
			$markup_generator->set_fields( array('group_name' => array('type' => 'text_input', 'required' => true, 'max_length' => 50),
												 'domain' => array('type' => 'dropdown', 'required' => true, 'options' => array_combine(valid_domains(), valid_domains())),
												 'display_name' => array('type' => 'text_input', 'required' => true, 'max_length' => 200),
												 'description' => array('type' => 'text_area', 'required' => true, 'max_length' => 4000),
												 'facility' => array('type' => 'dropdown', 'options' => $facility_options, 'required' => true, 'attributes' => array('data-placeholder' => 'Choose a Facility')),
										  ));
			
			//if there's $_POST data, validate
			if(array_key_exists('group_name', $_POST) && array_key_exists('domain', $_POST)){
				$markup_generator->set_values_from_post();		
				if(!$markup_generator->validates()){				
					$data['error_message'] = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages);
				}elseif(!Mailbox::name_is_available($markup_generator->field('group_name')->value)){
					$markup_generator->field('group_name')->has_error=true;
					$feedback_message = 'The specified '.$markup_generator->field('group_name')->link_to_field().' is not available. ';
					$feedback_message .= 'The '.$markup_generator->field('group_name')->link_to_field().' field may only contain alpha-numeric characters (A-Z, a-z, 0-9), underscores, periods, apostrophes, and dashes.';
					$data['error_message'] = '<strong>We need you to make a few changes to this form.</strong> '.$feedback_message;
				}else{
					$user = User::find_from_session();
					
					$this->load->library('api');
					$this->api->clear();
					$this->api->resource = '/admin/create_group/format/json';
					$this->api->http_method = 'post';
					$this->api->data = $markup_generator->values(); 
					
					if($this->api->call()){
						$group = Group::find_one(array('name' => $markup_generator->field('group_name')->value));
						if(Group::is_an_entity($group)){
							$this->eventlog->create_event(6, 0, 3,$user->user_org_id, "Create group: ".$group->name, time(), 1);
							$this->session->set_flashdata('success_message', 'Success!  The '.$group->name.' group has been created.');
							redirect('administration/manage/groups');						
						}
					}				

					$this->eventlog->create_event(6, 0, 3,$user->user_org_id, "Create group: ".$markup_generator->field('group_name')->value, time(), 0);
					$message = 'An unknown error occurred and the group was not created.  Please try again in a moment, and contact an administrator if the problem persists.';
					$data['error_message'] = $message;			
				}
			}
			$data['markup_generator'] = $markup_generator;
		}
		
		//SET UP THE PAGE
		$data['title'] = 'Direct API: Manage Groups';
		$data['view'] = 'group_list';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
 		$data['create_group_show'] = ((isset($permissions['API']['admins']) && $permissions['API']['admins']) || (isset($this->show['acct_group_maint']) && $this->show['acct_group_maint'] === true)); //only show create account to API admins
		$data['facilities'] = $this->facilitymodel->get_facilities(true)->result();
		
		//find the groups for the active groups tab
		Group::db()->order_by('name')->limit(ITEMS_PER_PAGE_DEFAULT);
		if($this->has_access('manage_groups_all') || $this->show['acct_group_maint']){
			$data['groups'] = Group::find(array('is_active' => true));
			$data['group_total'] = Group::count(array('is_active' => true)); //layering will have been cleared, pagination no longer applies
		}elseif($this->has_access('manage_groups_lead') || $this->show['acct_group_maint']){ 
 			$data['groups'] = User::find_from_session(array('is_active' => true))->groups(); 
			$data['group_total'] = count(User::find_from_session(array('is_active' => true))->groups());
		}
 
        //find the groups for the disabled groups tab
		Group::db()->order_by('name')->limit(ITEMS_PER_PAGE_DEFAULT);
		if($this->has_access('manage_groups_all') || $this->show['acct_group_maint']){
			$data['disabled_groups'] = Group::find(array('is_active' => false)); 
			$data['disabled_group_total'] = Group::count(array('is_active' => false)); //layering will have been cleared, pagination no longer applies
		}elseif($this->has_access('manage_groups_lead')){
			$data['disabled_groups'] = User::find_from_session()->groups(array('is_active' => false)); 
			$data['disabled_group_total'] = count(User::find_from_session()->groups(array('is_active' => false))); 
		}				

		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		
		$this->load->view('api/administration/manage_groups', $data);
	}
	
	//receive ajax request to return information of groups
	public function admin_group_search() {
		$active = $this->input->get('active',TRUE);
		$searchbox_input = trim($this->input->get('sSearch',TRUE));
		$display_start = $this->input->get('iDisplayStart',TRUE);
		$items_per_page = $this->input->get('iDisplayLength',TRUE);
		$sort_col = $this->input->get('iSortCol_0',TRUE);
		$echo = $this->input->get('sEcho',TRUE);
		$destination_page = floor($display_start / $items_per_page) + 1;
		
		
		$groups = array();
		$conditions = array('is_active' => ($active == 'true') ? true : false);
		Group::db()->order_by('name');
		if($this->has_access('manage_groups_all')){
			$groups = Group::find($conditions);	
		}elseif ($this->has_access('manage_groups_lead')){
			$groups = User::find_from_session()->groups($conditions); 		
		}

		if($searchbox_input) {
			$searchbox_input = strtolower($searchbox_input);
			$filtered_groups = array();
			foreach($groups as $key => $group) {
				if(string_contains($searchbox_input, $group->name) !== false || string_contains($searchbox_input, $group->display_name)  !== false || string_contains($searchbox_input, $group->description) !== false){
					$filtered_groups[$key] = $group;
				}
			}
			$groups = $filtered_groups;
		}
		
		$paginated_groups = array_slice($groups, ($destination_page - 1) * $items_per_page, $items_per_page, TRUE);
		$group_info_array = array();
		foreach($paginated_groups as $group) {
			$group_info = array(link_to('administration/manage/groups/edit/'.$group->name, $group->name), 
								$group->display_name, 
								$group->domain, 
								implode('<br>', $group->application_names), 
								$this->load->view('api/administration/manage_groups/_group_actions', compact('group'), TRUE));
			$group_info_array[] = $group_info;
		}
		$output = array (
				//"iDisplayStart" => 6,
				"sEcho" => $echo,
				"iTotalRecords" => count($groups),
				"iTotalDisplayRecords" => count($groups),
				"aaData" => $group_info_array
		);
		echo json_encode( $output );
	}
	
	
	public function disable_group() {
		$this->verify_access('disable_group');
		$group = $this->input->post('ou',TRUE);
		$this->can_edit_group($group);
		//get user org id from session to get permissions
		$current_user_org_id = User::organization_id_from_session();
		$cur_user = $this->usersmodel->get_user_id_from_org_id($current_user_org_id);
		$permissions = $this->account_permissions;
		if($this->groupsmodel->disable_group($group)) {
			$this->session->set_flashdata('message','Group '.$group.' has been disabled.');
			$this->eventlog->create_event(6, 0, 3, $cur_user, "Disable group: ".$group, time(), 1);
			//$_SESSION['flash'] = 'This is a simple flash message.';
			$this->session->set_flashdata('para','rrrrr');
			redirect('administration/manage/groups');
		}
		else { $this->session->set_flashdata('error_message','Failed to disable group.'); 
		$this->eventlog->create_event(6, 0, 3, $cur_user, "Disable group: ".$group, time(), 0); }
	}
	
	public function enable_group() {
		$this->verify_access('enable_group');
		
		$group = $this->input->post('ou',TRUE);
		$this->can_edit_group($group);
		//get user org id from session to get permissions
		$current_user_org_id = User::organization_id_from_session();
		$cur_user=$this->usersmodel->get_user_id_from_org_id($current_user_org_id);
		$permissions = $this->account_permissions;
		
		//push back the page number and items per page from the attempt to enable group to administration/manage/groups
		$this->session->set_flashdata('deactivated_page_select_from_enable_group_session',$this->input->post('deactivated_page_select_from_enable_group_session',TRUE));
		$this->session->set_flashdata('deactivated_items_per_page_from_enable_group_session',$this->input->post('deactivated_items_per_page_from_enable_group_session',TRUE));
		$this->session->set_flashdata('accounts_page_select_from_enable_group_session',$this->input->post('accounts_page_select_from_enable_group_session',TRUE));
		$this->session->set_flashdata('accounts_items_per_page_from_enable_group_session',$this->input->post('accounts_items_per_page_from_enable_group_session',TRUE));
		
		
			if($this->groupsmodel->enable_group($group)) {
				$this->session->set_flashdata('success_message','Group '.$group.' has been enabled.');
				$this->eventlog->create_event( 6,0,3 ,$cur_user, "Enable group: ".$group, time(), 1);
				redirect('administration/manage/groups#deactivated');
			}
			else { $this->session->set_flashdata('error_message','Failed to enable group.'); $this->eventlog->create_event( 6,0,3 ,$cur_user, "Enable group: ".$group, time(), 0);}
		
	}
	/* Save group membership data from group access edit form
	 */
	public function group_edit_access_save() {
		$this->verify_access('group_permissions');
		$id = User::organization_id_from_session();
		$cur_user=$this->usersmodel->get_user_id_from_org_id($id);
		$groups = $this->input->post('groups',TRUE);
		$action = $this->input->post('action',TRUE); //find out if we are adding or removing
		$group_name = $this->input->post('group_name',TRUE);
		$this->can_edit_group($group_name);
		$exist = $this->groupsmodel->group_exist($group_name); //easy way to check if group exists
		if($exist) {
			$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($group_name, true);
			foreach($groups as $group) {
				
				if($action === 'add') { 
					$response = $this->groupsmodel->change_group_membership($action,$group_name,$group);
					$this->eventlog->create_event( 6,0,3 ,$cur_user, "Access added for ".$group_name.": ".$group , time(), $response);
					//add mailbox settings
					$applications = $this->groupsmodel->get_applications($group_name);
					foreach($applications as $app_name) {
						$app_id = $this->applicationmodel->get_application_id_by_name($app_name);
						$this->usersettingsmodel->mailbox_settings_setup($mailbox_id, $app_id, $action);
					}
				}
				if($action === 'remove') {
					$response = $this->groupsmodel->change_group_membership($action,$group_name,$group);
					$this->eventlog->create_event( 6,0,3 ,$cur_user, "Access removed for ".$group_name.": ".$group, time(), $response);
					//delete inapplicable mailbox settings due to application(s) being removed from a group
					$applications = $this->groupsmodel->get_applications($group_name);
					$this->usersettingsmodel->delete_inapplicable_mailbox_settings($mailbox_id, $applications);
				}
			}
			
		}
		else{show_404();}
		redirect('administration/manage/groups/edit/access/'.$group_name);
	}
	public function admin_edit_group_access($group_name) {
		$this->can_edit_group($group_name);
		$this->verify_access('group_permissions');
		$data['title'] = 'Direct API: Manage Groups';
		$data['view'] = 'group_edit_access';
		$data['active_tab'] = array('administration'=>true);
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->account_permissions;
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$group = $this->groupsmodel->get_group_from_groupname($group_name);
		if(count($group) === 0){
			$group = $this->groupsmodel->get_group_from_groupname($group_name, false);
		}
		$data['group'] = $group[0];
		$accessible_groups = $group[0]['access'];
		$available_groups = array();
        $allowed_groups_for_access = $this->groupsmodel->get_allowed_groups_for_access($permissions);
        foreach($allowed_groups_for_access as $agc) {
			if(!in_array($agc, $accessible_groups)) {
				array_push($available_groups, $agc);
			}
		}
		
		natcasesort($accessible_groups);
		natcasesort($available_groups);
		
		$data['accessible_groups'] = $accessible_groups;
		$data['available_groups'] = $available_groups;
        $this->load->view('api/administration/manage_groups', $data);
	}
	
	public function admin_edit_group($group_name) {
		$this->can_edit_group($group_name);
		
		$group = Group::find_one(array('name' => $group_name));
		if(!Group::is_an_entity($group)){
			$this->session->set_flashdata('error_message','Group does not exist');
			redirect('administration/manage/groups');
		}
		
		$data['title'] = 'Direct API: Manage Groups';
		$data['view'] = 'group_edit';
		$data['active_tab'] = array('administration'=>true);
		$data['show'] = $this->show;
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($this->account_permissions);
				
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
		
		//find facility options
		$facility_options = array('' => '', ' ' => '&nbsp;');
		foreach($this->facilitymodel->get_facilities(true)->result() as $facility){
			$facility_options[$facility->id] = $facility->name;
		}
		
		require_library('form_markup_generator');
		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields( array(/*'name' => array('type' => 'hidden', 'required' => true, 'max_length' => 50),
											 'domain' => array('type' => 'hidden', 'required' => true, 'options' => array_combine(valid_domains(), valid_domains())), */
											 'display_name' => array('type' => 'text_input', 'required' => true, 'max_length' => 200),
											 'description' => array('type' => 'text_area', 'required' => true, 'max_length' => 4000),
											 'facility_id' => array('type' => 'dropdown', 'options' => $facility_options, 'required' => true, 'attributes' => array('data-placeholder' => 'Choose a Facility')),
									  ));
		
		if(empty($_POST) || !array_key_exists('display_name', $_POST)){ //set up values from db/ldap if form data hasn't been submitted
			$markup_generator->set_values(array('display_name' => $group->display_name, 'description' => $group->description, 'facility_id' => (string)$group->facility_id));
		}else{
			$markup_generator->set_values_from_post();		
			if(!$markup_generator->validates()){				
				$data['error_message'] = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages);
			}else{
				$user = User::find_from_session();
				$success = $this->groupsmodel->update_group($group->name, $markup_generator->field('display_name')->value, $markup_generator->field('description')->value);
				$group->facility_id = (!$markup_generator->field('facility_id')->property_is_empty('value')) ? $markup_generator->field('facility_id')->value : null;
				
				if($success && $group->save()){
					$this->session->set_flashdata('success_message', 'Success! Your changes have been saved.');  
					$this->eventlog->create_event( 6,0,3 ,$user->user_org_id, "Edit group: ".$group->name, time(), 1);
					redirect(current_url());
				}else{
					$data['error_message'] = 'An error occurred and your changes were not saved.  Please try again in a moment, or contact an administrator if the problem persists.';	
					$this->eventlog->create_event( 6,0,3 ,$user->org_id, "Edit group: ".$group->name, time(), 0);
				}
			}
		}							  
		
		$data['group'] = $group;
		$data['markup_generator'] = $markup_generator;
		
		$this->load->view('api/administration/manage_groups', $data);
	}
	
	public function admin_manage_facilities()
	{		
		$data['title'] = 'Direct API: Manage Facilities';
		$data['view'] = 'facility_list';
		$data['active_tab'] = array('administration'=>true);
		
		//grab flash data to display to the user
		if(!empty($this->session->flashdata('message'))) { $data['message'] = $this->session->flashdata('message'); }
		if(!empty($this->session->flashdata('error_message'))) { $data['error_message'] = $this->session->flashdata('error_message'); }
		if(!empty($this->session->flashdata('success_message'))) { $data['success_message'] = $this->session->flashdata('success_message'); }
	
		
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$user_id = $this->usersmodel->get_user_id_from_org_id($id);
		$permissions = $this->permissions->get_user_permissions($id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);

		$prefix = 'active_';
		//push back the page number and items per page on the active tab from the attempt to edit and save an facility
		$active_page_select_from_facility_save = $this->session->flashdata('active_page_select_from_facility_save');
		$active_items_per_page_from_facility_save = $this->session->flashdata('active_items_per_page_from_facility_save');
		if($active_page_select_from_facility_save) {
			$active_destination_page = $active_page_select_from_facility_save;
		}
		if($active_items_per_page_from_facility_save) {
			$active_items_per_page = $active_items_per_page_from_facility_save;
		}
		
		$active_pages = new Paginator($prefix);
		$active_pages->page_setup($active_bar_page, $active_jump_page, $active_items_per_page, $active_destination_page);
		
		if($permissions['API']['admins']) {
			$facility_list = $this->facilitymodel->get_facilities_by_page_number(($active_destination_page - 1) * $active_items_per_page + 1, $active_items_per_page);
			$facility_list_size = $this->facilitymodel->get_facility_list_size()->result();
		}
		
		//the active facilities list
		if ($facility_list) {
			
			$data['facility_list'] = $facility_list->result();
			//pagination setup
			$data['active_items_per_page'] = $active_items_per_page;
			$facility_list_size = $facility_list_size[0]->count;
			$data['active_num_pages'] = ceil($facility_list_size / $active_items_per_page);
			$data['active_cur_page'] = $active_destination_page;
			$active_pages->items_total = $facility_list_size;
			$active_pages->current_page = $active_destination_page;
			$active_pages->paginate();
			$data['active_pagination_bar'] = $active_pages->display_pages();
			$data['active_items_per_page_dropdown'] = $active_pages->display_items_per_page();
			$data['active_size'] = $facility_list_size;
		}
		else {
			$data['active_list'] = array();
		}
		
		if(isset($_POST['prefix'])) {
			$data['anchor'] = $_POST['prefix'] . 'link';
		}
		//assign form values
		$form_values = array();
		$form_values['active_page_select'] = $active_destination_page;
		$form_values['active_items_per_page'] = $active_items_per_page;
		$data['form_values'] = $form_values;
		
		if($data['show']['administration']) { $this->load->view('api/administration/manage_facilities', $data); }
		else { show_error('Forbidden',403); }
	}
	
	//receive ajax request to return information of facilities
	public function admin_facility_search() {
		$active = $this->input->get('active',TRUE);
		$searchbox_input = $this->input->get('sSearch',TRUE);
		$display_start = $this->input->get('iDisplayStart',TRUE);
		$items_per_page = $this->input->get('iDisplayLength',TRUE);
		$sort_col = $this->input->get('iSortCol_0',TRUE);
		$echo = $this->input->get('sEcho',TRUE);
		$destination_page = floor($display_start / $items_per_page) + 1;
	
		$id = User::organization_id_from_session();
		$user_id = $this->usersmodel->get_user_id_from_org_id($id);
		$permissions = $this->permissions->get_user_permissions($id);
		
		if($permissions['API']['admins']) {
			$facility_list = $this->facilitymodel->get_facilities_by_page_number(($destination_page - 1) * $items_per_page + 1, $items_per_page, $searchbox_input)->result();
		}
		else {
			$facility_list = array();
		}
	
		$facility_info_array = array();
		foreach($facility_list as $facility) {
			$facility_info = array();
			if($facility->active) {
				$active = 'Yes';
			}
			else {
				$active = 'No';
			}
		  	 
			$action = '<div class="center">' .
					  '<a href="/administration/manage/facilities/edit/' . $facility->id . '/1/'; 
		
			if($items_per_page) {
				$action .= $items_per_page;
			}
			else {
				$action .= $ITEMS_PER_PAGE_DEFAULT;
			}
		
			$action .= '" title="Edit Facility: ' .  $facility->name . '"><img src="/images/icons/application_edit.png" alt="Edit Facility: ' . $facility->name . '" /></a>' .
					   '</div>';
		
			 $facility_info = array($facility->name, $active, $action);
		  	 array_push($facility_info_array, $facility_info);
		}
			
		$full_filtered_facility_list_size = $this->facilitymodel->get_size_of_facility_list(null, $searchbox_input)->result()[0]->count;
		$output = array (
				"sEcho" => $echo,
				"iTotalRecords" => $full_filtered_facility_list_size,
				"iTotalDisplayRecords" => $full_filtered_facility_list_size,
				"aaData" => $facility_info_array
		);
		echo json_encode( $output );
	}
	
	/* 
	 * Facility edit is the edit page for changing meta-data about the facility. 
	 */
	public function facility_edit($id = null, $active_cur_page = null, $active_items_per_page = null){
		//set current page and items per page on the sub-tabs
		$data['active_cur_page'] = $active_cur_page;
		$data['active_items_per_page'] = $active_items_per_page;
		
		//if(is_null($id)) { return $this->facility_list(); } //if no id is set, go back to facility list
		$data['title'] = 'Direct API: Facility Edit';
		$data['view'] = 'facility_edit';
		$data['active_tab'] = array('administration'=>true);
		//get user id from session to get permissions
		$user_id = User::organization_id_from_session();
		$permissions = $this->permissions->get_user_permissions($user_id);
		$data['show'] = $this->permissions->set_tab_access_from_permissions($permissions);
		$data['admin_show'] = $this->permissions->set_admin_access_from_permissions($permissions);
		$data['api_admins'] = $permissions['API']['admins'];
		if($permissions['API']['admins']) {
			//add the validation errors
			if(!empty($this->session->flashdata('error_message'))) { 
				$data['error_message'] = $this->session->flashdata('error_message'); 
				$data = array_merge($data, $this->session->flashdata('post_data_from_last_request')); //add post data to $data from flashdata
			}
			
			if($data['show']['administration']) {
				if (isset($id) && is_numeric($id)){ //make sure its a valid id
					$fac = $this->facilitymodel->get_facility($id)->result();
					if($fac) { //if there is a result, load the view
						$data['fac'] = $fac[0];
						$this->load->view('api/administration/manage_facilities', $data);
					}
					else { show_404(); } //if not valid id or no result, show 404
				}
				else { 
					//show_404(); 
					$this->load->view('api/administration/manage_facilities', $data);
				}
			}
			else { show_error('Forbidden',403); }
		}else { show_error('Forbidden',403); }
	}	
	
	/* 
	 * Facility save handles the storing of values into the database. 
	 */
	public function facility_save(){
		$this->load->library('form_validation');
		
		//push back the page number and items per page from the attempt to edit an facility
		$this->session->set_flashdata('active_page_select_from_facility_save',$this->input->post('active_page_select_from_facility_save',TRUE));
		$this->session->set_flashdata('active_items_per_page_from_facility_save',$this->input->post('active_items_per_page_from_facility_save',TRUE));
		
		//retrieve the facility id
		$id = $this->input->post('fac_id',TRUE);
		//use permissions to determine whether to allow function call at all
		$user_id = User::organization_id_from_session();
		$cur_id=$this->usersmodel->get_user_id_from_org_id($user_id);
		$permissions = $this->permissions->get_user_permissions($user_id);
		$message = '';
		if($permissions['API']['admins']) {
			//test if the id has been passed and if it is a valid number
			if(empty($id) || !$this->is->nonzero_unsigned_integer($id)){
				$this->session->set_flashdata('error_message', 'No facility id specified. To create a new facility, please click on the Create New Facility button.'); 
				redirect('administration/manage/facilities/edit');
			}
			else {
				//retrieve the facility from the database from its id
				$fac_arr = $this->facilitymodel->get_facility($id)->result();
				//if the facility exists
				if($fac_arr) {
					$fac = $fac_arr[0];
					$existing_name = $fac->name;
					//grab the other form values that have been passed
					$name = $this->input->post('fac_name',TRUE);
					$active = $this->input->post('active',TRUE);
					
					//set required fields for validation
					if ($existing_name === $name)
						$this->form_validation->set_rules('fac_name','Facility Name','required|max_length[400]');
					else
						$this->form_validation->set_rules('fac_name','Facility Name','required|is_unique[facility.name]|max_length[400]');
					
					if($this->form_validation->run() === TRUE) {
						if($this->facilitymodel->save_facility($id, $name, $active)) {
							$message = 'Facility "'.$name.'" has been saved successfully.';
							$this->eventlog->create_event(7, $id ,3 ,$cur_id, "Edit facility", time(), 1);
						}
						else { 
							$error_message = 'Facility "'.$name.'" failed to save.'; 
							$this->eventlog->create_event(7, $id, 3 ,$cur_id, "Edit facility", time(), 0);
						}
					}
					else {
						$this->session->set_flashdata('error_message',validation_errors());
						$this->session->set_flashdata('post_data_from_last_request', $this->input->post());
						if(!empty(trim($id))){ 
							redirect('administration/manage/facilities/edit/'.$id); 
						}else{
							$this->session->set_flashdata('message', 'No facility id specified. To request a new facility please follow the link on the onboarding tab.'); 
							redirect('administration/manage/facilities/edit'); 
						}
					}
				}
				//if no facility exists in the database return to the edit screen
				else {
					$this->session->set_flashdata('error_message', 'No facility exists for id '.$id.'. Please select another facility to edit.'); 
					redirect('administration/manage/facilities/edit');
				}
			}
			$this->session->set_flashdata('success_message',$message);
			if(isset($error_message)) { $this->session->set_flashdata('error_message',$error_message); }
			redirect('administration/manage/facilities');
			
		}
		else { show_error('Forbidden', 403); }
	}
	
	public function facility_create() {
		$this->load->library('form_validation');
		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->permissions->get_user_permissions($id);
		$user_id=$this->usersmodel->get_user_id_from_org_id($id);
			
		//get field values from the form
		$fac_name = $this->input->post('fac_name', TRUE);
		$active = $this->input->post('is_active', TRUE);
		$is_facility_created_successfully = FALSE;
		//use permissions to determine whether to allow function call at all
		if(isset($permissions['API']['admins']) && $permissions['API']['admins']) {
			//set validation for the fields
			$this->form_validation->set_rules('fac_name','Facility Name','required|is_unique[facility.name]|max_length[400]');
				
			if($this->form_validation->run() === TRUE) {
				$is_facility_created_successfully = TRUE;
				if($this->facilitymodel->save_facility(null, $fac_name, $active)) {
					$this->eventlog->create_event(7, 0, 3,$user_id, "Create Facility: ".$fac_name, time(), 1);
					$message = 'Facility, ' . $fac_name . ', has been created successfully.';
					$this->session->set_flashdata('success_message', $message);
				}
				else {
					$this->eventlog->create_event(7, 0, 3,$user_id, "Create Facility: ".$fac_name, time(), 0);
					$this->session->set_flashdata('error_message', 'Failed to create Facility, ' . $fac_name . '.');
				}
	
			}
			else {
				$this->session->set_flashdata('error_message',validation_errors());
				$this->session->set_flashdata('fac_name', $fac_name);
				$this->session->set_flashdata('is_active', $active);
			}
		}
		else {
			$this->eventlog->create_event(7, 0, 3 ,$user_id, "Create Facility: ".$fac_name, time(), 2);
			show_error(403,'Unauthorized');
		}
		if($is_facility_created_successfully === TRUE) {
			redirect('administration/manage/facilities');
		}
		else {
			redirect('administration/manage/facilities#create');
		}
		
	}
	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	
	protected function create_user($fields) {				
		$resource = '/admin/create_user/format/json';
		$url = WEBSERVICE_URL . $resource;
		
		$post = '';
		$content_type = "application/x-www-form-urlencoded";
		foreach($fields as $key=>$value) { $post .= $key.'='.urlencode($value).'&'; } //url-ify the data for the POST
		$post = rtrim($post, '&');
		$headers = array(
			'Authorization: DAAS ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"POST\n" . date('U'). "\n". md5($post) . "\n" . $content_type . "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
			'Date: ' . date('U'),
			'Content-Type: '. $content_type,
			'Content-Md5: ' . base64_encode(md5($post)),
		);
		
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		return array('status'=>$http_status,'json'=>$server_output);
	}
	
	protected function can_edit_group($group_name){
		if($this->has_access('manage_groups_all')){
			return;
		}
		elseif($this->has_access('manage_groups_lead')){
			if(!$this->groupsmodel->user_is_member($group_name,$this->user->dn())){
				show_404();
			}else{
				return;
			}
		}
		else{
			show_404();
		}
	}
	
}

