<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
require_once APPPATH.'/libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Authorize extends DaaS_REST_Controller
{
	public function __construct(){
		parent::__construct();

		require_model('application');
		require_model('application_account');

		//there are methods in this controller which can be accessed out of the API.
		//this is a poor choice.  all front-end activity should inherit from the DAAS_Controller, not the REST controller
		//for now, we don't have time to pull all of this out, but no new front-end functionality shold be added to this controller
		if(!in_api_context()){
			if(!User::log_in())
				show_error('Unauthorized',401);
		}
	}

	public function request_get() {
		$app_id = $this->get('id');
		$action = $this->get('action');
		$redirect_url = $this->get('redirect_url');
		if(isset($app_id)) {
			if(isset($_SERVER['HTTP_CERT']) || isset($_SERVER['HTTP_COOKIE'])) { //save some time and check if the server cert was even passed at all, if not assume its from API domain and give response
				$this->load->helper('form');
				$this->load->model('applicationmodel');
				if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
					$org_id = User::organization_id_from_session();
					$permissions = $this->permissions->get_user_permissions($org_id);
					$app = $this->applicationmodel->get_application($app_id);
					if($app->num_rows() === 1) {
						$app_attributes = $app->result();
						$data['app_id'] = $app_attributes[0]->id;
						$data['app_name'] = $app_attributes[0]->name;
						$data['action'] = $action;
						$data['redirect_url'] = rawurldecode($redirect_url);
						$this->load->view('api/authorize/request',$data);
					}
				}
			}
			else {
				$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
				$is_authorized = $this->request->direct_api_authorized; //authorize request
				if($is_authenticated && $is_authorized) {
					$this->load->model('applicationmodel');
					$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
					$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/request/id/' . $app_id;
					if(trim($action)) { $url .= '/action/'.$action; }
					$response = array(
						'authorize_url' => $url,
					);
					$this->response($response,404);
				}
			}
		}
		else { show_404(); }
	}

	public function register_get() {
		if(!in_api_context()) $this->error->notice('This method is no longer intended to be accessed outside of an API service');

		require_model('application');
		require_model('application_account');

		foreach(array('unique'/*, 'redirect_url' */) as $required_field){
			if(!array_key_exists($required_field, $_GET))
				$this->missing_required_fields[] = $required_field;
		}
		$this->respond_with_error_if_fields_are_missing();

		$app_id = $this->application_id;
		$org_id = $this->get('unique');
		$destination_after_save = $this->get('redirect_url');

		$application = Application::find_one($app_id);
		if(!Application::is_an_entity($application))
			$this->invalid_fields[] = 'id';

		$this->respond_with_error_if_fields_are_invalid();

		$account = $application->find_account_by_organization_id($org_id);
		if(!Application_account::is_an_entity($account)){
			$account = Application_account::create(compact('app_id', 'org_id'));
		}

		if(!Application_account::is_an_entity($account) || empty($account->status()))
			return $this->response(array_merge($account->values_for_api, array('status' => 'error', 'message' => 'An error occurred while checking the status of this account request')), 400);

		return $this->response($account->values_for_api($destination_after_save), 200);
	}

	public function username_get(){
		$app_id = $this->get('id');
		if(isset($app_id)){
			$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
			$is_authorized = $this->request->direct_api_authorized; //authorize request
			if($is_authenticated && $is_authorized) {
				$this->load->model('applicationmodel');
				$app_id = $this->applicationmodel->get_application_id_from_public($this->request->public_key);
				$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/request/id/' . $app_id;
				if(trim($action)) { $url .= 'action/'.$action; }
				$response = array(
					'authorize_url' => $url,
				);
				$this->response($response,404);
			}
		}
		show_404();
	}

	public function submit_post() {
		$this->load->library(array('session','encrypt','permissions'));
		$this->load->model('applicationmodel');
		$this->load->model('usersettingsmodel');
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		$redirect_url = $this->post('redirect_url',TRUE);

		if(isset($_SERVER['HTTP_CERT']) || ($is_authenticated && $is_authorized)) {
			if($this->session->userdata('user_id')) {
				//add user settings entries
				$app_id = $this->post('app_id',TRUE);
				$web_service_name = $this->post('action',TRUE);
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$web_service_id = $this->usersettingsmodel->get_web_service_id_by_name($web_service_name);
				$this->usersettingsmodel->save_user_settings_entry($user_id, $app_id, $web_service_id, 'on');
			}
		}
		$app = $this->applicationmodel->get_application($app_id)->result();

		$this->load->helper('url');
		//check redirect URL to make sure it is under the app's domain
		$app_url = $app[0]->url;
		if(string_contains(parse_url($app_url, PHP_URL_HOST), parse_url($redirect_url, PHP_URL_HOST))) {
			redirect($redirect_url);
		}
		else {
			show_404();
		}
	}

	public function get_webservice_permission_get() {

		$is_authenticated = $this->request->hmac_authenticated;
		$is_authorized = $this->request->direct_api_authorized;

		if($is_authenticated && $is_authorized) {
			$this->load->model('applicationmodel');
			$this->load->model('usersettingsmodel');

			//todo - just reference $this->application_id
			$query = $this->applicationmodel->get_application_from_public($this->request->public_key);
			$query_array = $query->row_array();
			$app_id = $query_array['id'];
			$redirect_url = $this->get('redirect_url');
			$mailbox_name = $this->get('mailbox_name');
			$is_group = $this->get('is_group');
			$response = array(
					'permission_url' => 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/edit_webservice_permission/id/' . $app_id . '/mailbox_name/' . $mailbox_name . '/is_group/' . $is_group . '/redirect_url/' . $redirect_url,
			);
			$this->response($response,200);
		}
	}


	public function save_webservice_permission_post() {
		$this->load->model('usersettingsmodel');
		$this->load->model('usersmodel');
		$is_authenticated = $this->request->hmac_authenticated; //check if authenticated request
		$is_authorized = $this->request->direct_api_authorized; //authorize request
		$redirect_url = $this->post('redirect_url',TRUE);

		if(isset($_SERVER['HTTP_CERT']) || isset($_SERVER['HTTP_COOKIE'])) {

			if($this->session->userdata('user_id')) { //if this has been set we know they are logged in
				//add user settings entries
				$org_id = User::organization_id_from_session();
				$user_id = $this->usersmodel->get_user_id_from_org_id($org_id);
				$app_id = $this->post('id',TRUE);
				$user_name = $this->usersmodel->get_username_from_id($user_id);
				$mailbox_name = $this->post('mailbox_name',TRUE);
				$is_group = $this->post('is_group',TRUE);
				$mailbox_id = $this->usersettingsmodel->get_mailbox_id_by_name($mailbox_name, $is_group);
				$mailbox_settings = $this->usersettingsmodel->get_mailbox_settings_by_application($mailbox_id, $app_id)->result();
				foreach($mailbox_settings as $setting) {
					$authorized =  $this->post($setting->web_service_name,TRUE);
					$this->usersettingsmodel->save_mailbox_settings_entry($mailbox_id, $app_id, $setting->web_service_id, $authorized);
				}
			}
			$this->load->helper('url');
			redirect($redirect_url);
		}
	}

}
