function assignToMe() {
	assign_selected($('#current_user').attr('value'),$('#display_name').attr('value'));
	$('#assign_menu').attr({style:""});
	$('#assign_menu').remove();
}

$().ready(function() {
	$('#assign_message_btn').disabled = true;
	//token input event handlers
	if($('textarea[name="assign_message"]').length) {
		var assign_message_text = $('textarea[name="assign_message"]').text();
		$('textarea[name="assign_message"]').ready(function(){
			$("#assign_message").tokenInput('/inbox/search_group_members/',
			{
				theme: "dpii",
				searchDelay: 500,
				hintText: "Enter a group member's name",
				tokenDelimiter: ";",
				tokenLimit: 1,
				onAdd: function(e) {
						$('#assign_btn').attr('onclick','assign_selected(' + e.id + ',\'' + e.name + '\');$(\'#assign_menu\').attr({style:""}); $(\'#assign_menu\').remove();');
						$('#assign_btn').html('Assign');
						$('#assign_btn').css('margin-top','5px');
				},
				onDelete: function(e) {
					$('#assign_btn').html('Assign To Me');
					$('#assign_btn').attr('onclick','assignToMe();');
					$('#assign_btn').css('margin-top','2px');
				},
				noResultsText: "No other group member meets search criteria",
				resultsFormatter: function(item){ 
					return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.cn + "</div></div></li>" 
				},
				tokenFormatter: function(item) { 
					return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.id+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.cn + "</p></li>" 
				}
			});
			
			if(assign_message_text.length) {
				var data_array = html_entity_decode(assign_message_text).split(';');
				for(var i = 0; i < data_array.length; i++) {
					if($.trim(data_array[i]).length) {
						var address = $.trim(data_array[i]);
						$('textarea[name="assign_message"]').tokenInput('add',{ name : htmlentities(address,'ENT_NOQUOTES'), id : address, uid: uniqid() });
					}
				}
			}
		});
	}
});