<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
*/

$CI = get_instance();

echo form_open_multipart('inbox/search/advanced', array('id' => 'advanced_search_form'));
?>
		<table role="presentation">
	    	<tr>
	    		<td><label for="from">From</label></td>
	    		<td><?PHP echo form_input(array('name' => 'from','id' => 'from', 'style' => '')); ?></td>
			</tr>
			<tr>
	    		<td><label for="recipient">To</label></td>
	    		<td><?PHP echo form_input(array('name' => 'recipient', 'id' => 'recipient', 'style' => '')); ?></td>
			</tr>
			<tr>
	    		<td><label for="subject_title">Subject</label></td>
	    		<td><?PHP echo form_input(array('name' => 'subject_title','id' => 'subject_title', 'style' => '')); ?></td>
			</tr>
			<tr>
	    		<td><label for="plain_message">Message Body</label></td>
	    		<td><?PHP echo form_input(array('name' => 'plain_message','id' => 'plain_message', 'style' => '')); ?></td>
			</tr>
			<tr>
	    		<td><label for="priority_search">Priority</label></td>
	    		<td>
					<div class="select-style">
						<select class="seachselect" id="priority_search" name="priority" >
							<option value="all" selected>All</option>
							<option value="1" >High</option>
							<option value="3" >Normal</option>
							<option value="5" >Low</option>
						</select>
					</div>
	    		</td>
			</tr>
			<tr>
	    		<td><label for="time_frame">Time Frame</label></td>
	    		<td > 
					<div class="select-style">
						<select  id="time_frame" name="time_frame">
							<option value="all" selected>All</option>
							<option value="0">Today</option>
							<option value="7">7 days</option>
							<option value="30">30 days</option>
							<option value="90">90 days</option>
						</select>
					</div>
				</td>
			</tr>
		</table>
	<?php if($CI->session->mailbox_location() == 'archived'):?>
		<div role="group" aria-labelledby="original_folder">
			<table role="presentation">
				<tr><td colspan=2><p id="original_folder">Original Folders</p></td></tr>
				<tr>
					<td><span><label for="checkInbox" >Inbox </label></span></td>
					<td><input type="checkbox" id="checkInbox"  name="original_folder[]" value="inbox" checked/></td>
				</tr>
				<tr>	
					<td><span><label for="checkSent">Sent</label></span></td>
					<td><input type="checkbox" id="checkSent" name="original_folder[]" value="sent" checked/></td>
				</tr>
				<tr>	
					<td><span><label for="checkDraft">Draft</label></span></td>
					<td><input type="checkbox" id="checkDraft"  name="original_folder[]" value="draft" checked/></td>
				</tr>
			</table>
		</div>			
	<?php endif?><br />
	
		<label for="folder_search_select">Select one or more folders to search:</label>
		<p class="hidden_context" style="display:none;" id="advanced_search_help">Use Shift + Click or Control + Click to select multiple options. Keyboard options for multiple select may vary.</p>
		<select class="tt-focus tt-top-hover" aria-describedby="advanced_search_help" title="Use Shift + Click or Control + Click to select multiple options." id="folder_search_select" name="folder_search_select[]" multiple style="height:250px; width: 100%; margin-top: 10px; ">
		<?php foreach(get_instance()->mailbox->folders_in_hierarchical_order() as $id => $folder): ?>
			<option value="<?php echo $folder->id ?><?php if(is_numeric($folder->id)) echo '_'.$folder->name_for_display() ?>" <?php if($folder->id == $CI->mailbox->current_folder->id ) echo 'selected="selected"'?> ><?php echo $folder->indented_name_for_display() ?></option>
		<?php endforeach ?>
		</select>
<?php echo form_close(); ?>