<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/* NOTE - While this model will extend some methods from its parent in order to provide additional checks/functionality, it is not currently slated to have
   any public methods that are not present in its parent.  Logging will take place in extensions of create_for_message, update_for_message, and remove_for_message,
   and will not require any additional actions in the controller. */

/** */
require_model('api_custom_flag_model');

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Workflow_model extends API_custom_flag_model {
	protected $table_name = 'workflow_items';
	protected $primary_key = 'id';
	const CUSTOM_FLAG_PREFIX = 'workflow';
		
	function __construct() {
        parent::__construct();
		
		$this->mailbox_group = $this->session->userdata('mailbox_group');
		$mailbox_group_info = $this->user_model->find_one(array('user_name' => $this->mailbox_group));
		if(empty($mailbox_group_info) || !$mailbox_group_info['user_is_group']) 
			throw new Exception ('The workflow model may only be loaded for group mailboxes, but '.$this->error->describe($this->mailbox_group).' is not a group');
		
    }	
	
	///////////////////
	// SEARCH
	///////////////////
	
	/* Extends parent to enforce that users can only view flags that they've created */
	function find($id_or_conditions = array(), $key_by = null){
		$this->db->where('mailbox_group', $this->mailbox_group);
		return parent::find($id_or_conditions, $key_by);
	}
	
	
	///////////////////
	// DATA MANGEMENT
	///////////////////
	
	protected function _run_before_create(&$values){
		if(!parent::_run_before_create($values)) return false;
		if(empty($values['mailbox_group']))
			$values['mailbox_group'] = $this->mailbox_group;
		return true;
	}
	
	/* Extends parent to enforce that users may only edit their own flags */
	protected function _run_before_update($id, &$values){ 
		if(!parent::_run_before_update($id, $values)) return false;
		
		//make sure that the mailbox_group we're currently in matches the mailbox_group for the flag
		//this should ensure that only people with access to this mailbox are able to edit flags.
		if(!$this->exists(array($this->primary_key => $id, 'mailbox_group' => $this->mailbox_group))){
			return $this->error->warning( $this->model_alias.'#'.$id.' does not belong to the '.$this->error->describe($this->mailbox_group).' mailbox group' );
		}
		
		return true; 
	}
	
	/* Extends parent to enforce that assigned_to is required */
	function _values_are_valid_for_create($values){
		if(!parent::_values_are_valid_for_create($values)) return false;
		if(!array_key_exists('assigned_to', $values) || empty($values['assigned_to'])) return $this->error->warning( $this->table_name.'.assigned_to is required');			
		return true;
	}
	
	/* Extends parent to enforce that assigned_to cannot be set to null if complete is set */
	function _values_are_valid_for_update($id, $values){ 
		
		//we need to know the value of both assigned_to and complete, so look it up if they're not both in $values
		if(!array_key_exists('assigned_to', $values) || !array_key_exists('complete', $values) ){
			$record = $this->find_one($id);
			foreach(array('assigned_to', 'complete') as $column){
				if(!array_key_exists($column, $values)) $values[$column] = $record[$column];
			}
		}
	
		if(array_key_exists('assigned_to', $values) && empty($values['assigned_to']) && !empty($values['complete'])){
			return $this->error->warning($this->table_name.'.assigned_to is required if '.$this->table_name.'.complete is set');
		}
	
	
		if(array_key_exists('complete', $values)){
			$complete = $values['complete'];
		}else{
			$complete = element('complete', $this->find_one($id));
		}	
	
		return true;	
	}
	
	
	/* Extends parent to enforce that that workflow items are only created in the current mailbox */
	function _values_are_valid_for_create_and_update($values){ 
		if(!parent::_values_are_valid_for_create_and_update($values)) return false;
		if(array_key_exists('complete', $values) && (int)$values['complete'] > 0){
			
		}
		if(array_key_exists('mailbox_group', $values) && $this->mailbox_group != $values['mailbox_group']){
			return $this->error->warning( 'The mailbox group for '.$this->model_alias.'#'.$id.' must match the current mailbox_group ('.
										  $this->error->describe($this->mailbox_group).'), but you gave me '.$this->error->describe($values['mailbox_group']));
		}	
		
		return true;
	}
	
	protected function _clear_record($record_id){
		if(!$this->is->nonzero_unsigned_integer($record_id)) return $this->error->should_be_a_nonzero_unsigned_integer($record_id);
		$values = array('assigned_to' => null, 'complete' => 0);
		
		//since this is the only occasion that we can set a color null, we'll circumvent the normal validation in update() 
		//just run the methods to auto-generate values as necessary
		$this->_run_before_update($record_id, $values);
		$this->_run_before_create_and_update($values, $record_id);
		return $this->_update($record_id, $values);
	}
	
}