<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_library('object');
 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Video extends Object{        
    protected $_name; //a slug of the title - this is how we'll refer to it in the config file
	protected $_title; //the title of the video, as displayed on the intro of the video
	protected $_external_url; //youtube URL, including http
	protected $_high_res; //filename for our high resolution local copy of this video
	protected $_medium_res; //filename for our medium resolution local copy of this video
	protected $_low_res; //filename for our low resolution local copy of this video
	protected $_video_path = VIDEO_PATH;
	protected $_resolutions = array('high_res', 'medium_res', 'low_res');
	
 	
	function __construct($name, $values = array()){
		parent::__construct($values);
			
		$config = static::config($name);
		if(!is_array($config) || empty($config)) return $this->error->fatal('There is no video named '.$this->error->describe($name));
	
		$this->_name = $name;
		
		if(!$this->is->nonempty_string($config['title']))
			$this->error->warning('The title for '.$this->describe().' is not a nonempty string: '.$this->error->describe($config['title']));
		else
			$this->_title = $config['title'];
	
		if(!empty($config['external_url'])){ 
			if(!$this->is->string_like_a_url($config['external_url']))
				$this->error->warning('The external url for '.$this->describe().' is not a URL: '.$this->error->describe(element('external_url', $config)));
			else
				$this->_external_url = $config['external_url'];	
		}
		
		foreach($this->resolutions as $resolution){
			if(empty($config[$resolution])) continue; 
			
			if(!$this->is->nonempty_string($config[$resolution]) || !file_exists($this->video_path.$config[$resolution]))
				$this->error->warning('The '.$resolution.' video for '.$this->describe().' does not exist: '.$this->error->describe($this->video_path.$config[$resolution]));
			else{
				$var = '_'.$resolution;
				$this->$var = $config[$resolution];
			}
		}
		
		if(!isset($this->external_url, $this->high_res, $this->medium_res, $this->low_res)) throw new Exception('No video url available for video#'.$name);
	}
	
	public function local_url($resolution = null){
		if(!is_null($resolution))
			return site_url('videos/'.$this->$resolution);
		
		//if no resolution was specified, give the highest resolution available
		foreach($this->resolutions as $resolution){
			if(isset($this->$resolution))
				return site_url('videos/'.$this->$resolution);
		}
	}
	
	public function links(){
		$links = array();
		foreach($this->resolutions as $resolution){
			$url_method = 'url_for_'.$resolution.'_view';
			$url = $this->$url_method();
			if(!empty($url) && !string_begins_with($url, current_url()))
				$links[$resolution] = link_to($url, str_replace('Res', 'Resolution', humanize($resolution)));
		}
		if(isset($this->external_url))
			$links['external'] = link_to($this->url_for_view(), 'YouTube');
		return $links;
	}
	
    
	//describe this attachment for error messages - analogous to Entity::describe()
	function describe(){
		return get_class($this).'#'.$this->name;
	}	
	
	function url_for_view(){
		if(!$this->property_is_empty('name'))
			return site_url('help/videos/'.$this->name);
	}
    
	function url_for_high_res_view(){
		if(!$this->property_is_empty('high_res'))
			return site_url('help/videos/'.$this->name.'/high-res');
	}	
	
	function url_for_medium_res_view(){
		if(!$this->property_is_empty('medium_res'))
			return site_url('help/videos/'.$this->name.'/medium-res');
	}
	
	function url_for_low_res_view(){
		if(!$this->property_is_empty('low_res'))
			return site_url('help/videos/'.$this->name.'/low-res');
	}
	

	function values(){
        $properties = array_keys(get_object_vars($this));
	
        foreach($properties as &$property)
            $property = strip_from_beginning('_', $property);
                
        $properties_to_exclude = array('is', 'validator', 'error', 'property_validation_rules');
		
		$values = array();
		foreach(array_diff($properties, $properties_to_exclude) as $property){
			$values[$property] = $this->$property;
		}
		return $values;
	}
	
	function tooltip_link($attributes = array()){
		$attributes = array_merge(array('class' => 'help-icon-container bootstrap', 'title' => 'Help Video: '.$this->title, 'target' => '_blank'), $attributes);
		return link_to($this->url_for_view(), '<span class="glyphicon glyphicon-question-sign" aria-hidden="true"></span>', $attributes );
	}

/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function config($name){
		$CI = get_instance();
		$CI->config->load('videos', TRUE);
		return $CI->config->item($name, 'videos');
	}
	
	public static function exists($name){
		return !empty(static::config($name));
	}
	
	public static function all(){
		$CI = get_instance();
		$videos = array();
		foreach($CI->config->item('videos') as $name => $config){
			$videos[$name] = new Video($name);
		}
		return $videos;
	}

 
}
?>