<?php 
/**
* @package direct-project-innovation-initiative
* @subpackage hooks
*/

/**
* Runs any system-wide code based on the constants file.
* For example, the timezone needs to be set to the default timezone for this instance of Direct.
*/
function set_system_defaults(){
	date_default_timezone_set(ENVIRONMENT_TIMEZONE); //this instance of Direct will be configured with a default timezone, we want it set as early as possible
}

function set_up_session(){
	//at this point, the controller has not been instantiated yet, but the core/Codeigniter bootstrap script has determined which controller and method will be called
	global $class; //the name of the controller class
	global $method; //the method of the controller class which CI will call
	
	$class = strtolower($class);
	$method = strtolower($method); 

	
#TODO - WOULD THIS WORK BETTER IF WE SET IT TO /?  IT LOOKS LIKE THE SECOND PARAM IS MEANT TO BE THE PATH, WHICH IS NOT ALWAYS THE SAME AS THE CONTROLLER CLASS NAME	
	session_set_cookie_params(0,'/'/*.$class*/, CLINICAL_DOMAIN, TRUE, TRUE);
	session_cache_limiter('none'); //this was included in the restricted controller, but doesn't appear to be a valid value for cache_limiter - should be nocache if we're doing this
#	session_start();

}

/**
* Check to see if there's a theme set for this user and set it as a controller class var if there is.
*/
function set_user_theme(){
	if(is_cli() || defined('PHPUNIT_TEST')) return; //this hook only applies to HTML output
	
	$hooks_disabled = array('install', 'unit_test_controller');
	$CI = get_instance();
	if(is_object($CI)){
		$controller = strtolower(get_class($CI));
		if(!in_array($controller, $hooks_disabled)) {
			require_model('theme'); 
			$theme = Theme::find_from_session();
			if(Theme::is_an_entity($theme))
				$CI->user_theme = $theme->values;
		}
	}
}

function set_up_authentication(){
	$CI = get_instance();
	
	if (USE_PIV_AUTH === TRUE){
		$CI->load->library('authentication/PIV_authentication', array(), 'authentication');
	}elseif(USE_CAC_AUTH === TRUE){
		$CI->load->library('authenticatios/CAC_authentication', array(), 'authentication');
	}else{
		$CI->error->warning('No form of authentication is currently configured.');
	}
	
}
 

/* End of file hook_functions.php */
/* Location: ./application/hooks/hook_functions.php */
