<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/adminpanel.php';

/**
* Contact list page within the Adminpanel.
* This page is used to store functions related to the Global Contacts stored in the database.
* Routing is handled using CI routing functionality instead so that each action can be separated into a child function.
*
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Global_contact_controller extends AdminPanel {

	public $title = PORTAL_TITLE_PREFIX . 'Admin Panel';

	function __construct() {
		parent::__construct();
		#TODO - Need to verify that the permission needs to be "manage_users"
		$this->verify_permission('manage_users');
		//not sure if this is needed
		//$this->verify_permission('global_contact');

		require_model('global_contact');
		require_library('form_markup_generator');

	}

	/**
	* Displays a list of all global contacts
	*/
	function index(){

		$global_contacts = array();
		$total_global_contacts = Global_contact::count();
		if(!empty($total_global_contacts)) $global_contacts = Global_contact::find();
		$title = $this->title.' Global Contact List';
		$this->load->view('adminpanel/manage_contact_lists/index', compact('global_contacts', 'total_global_contacts','title'));
	}

	function create(){
		$this->title .= ' Create Global Contact';
		return $this->create_update();
	}

	//import a large number of contacts via csv
	function import(){
		require_library('attachment');
		$headers_for_import = array('first_name','middle_name','last_name','title','department','organization','telephone','mobile','direct_address');

		$form = new Form_markup_generator();
		$form->set_fields( array('file_to_import' => array('type' => 'file', 'required' => true), /* 'has_headers'=> array('type' => 'checkbox', 'label_text' => 'My data has headers' ) */));

		if(!empty($_POST)){
			$form->set_values_from_post();
			if(!$form->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($form->validation_messages);
			}else{
				$file = Attachment::from_session_cache($form->field('file_to_import')->value_full_path);
				if(!is_a($file, 'Attachment'))
					$error_message = $this->lang->line('generic_error');
				elseif(!is_a($file, 'CSV_Attachment')){
					$error_message = '<strong>We need you to make a few changes to this form.</strong>  The uploaded file must be in Comma Separated Value (CSV) format.';
					$form->field('file_to_import')->has_error = true;
				}else{
					$rows = str_getcsv($file->binary_string, "\n");
					$headers = str_getcsv(first_element($rows));
					$missing_headers = array_diff($headers_for_import,$headers);
					if(!empty($missing_headers)){
						$error_message = '<strong>The following headers are missing from your CSV file: </strong> '.ul_if_multiple($missing_headers);
					}else{
						//validate each row
						$global_contact = new Global_contact();
						array_shift($rows); // remove the headers

						foreach ($rows as $row_count => &$row){
							$row = array_combine($headers,str_getcsv($row)); //parse the items in rows
							foreach ($row as $field => $value){
								if ($global_contact->property_has_validation($field) && !$global_contact->value_is_valid_for_property($field, $value)){
									$invalid_rows[] = 'Row #'. ($row_count+2) . ': '. $field. ' entry should be a '. element($field, $global_contact->property_validation_rules());
								}
							}
						}
						if(!empty($invalid_rows)){
							$error_message = '<strong>We need you to make a few changes to the CSV file.</strong> '.ul_if_multiple($invalid_rows);
							$form->field('file_to_import')->has_error = true;
						}else{
							Global_contact::db()->insert_batch('admin_contact_list', $rows);
							$success_message = '<strong>Success!</strong> '.ucfirst(number_as_text(count($rows))).' global contact'.((count($rows) == 1) ? ' was ' : 's were').' imported.';
						}
					}
				}
			}
		}

		$title = $this->title.' Import Contacts';
	 	$this->load->view('adminpanel/manage_contact_lists/import', compact('title', 'success_message', 'error_message', 'form', 'headers_for_import'));
	}

	function update($contact_id){
		$this->title .= ' Update Global Contact';
		if(!Global_contact::formatted_like_an_id($contact_id)) show_404();
		return $this->create_update($contact_id);
	}

	protected function create_update($contact_id=null){

		//set up the form generator so that we can validate existing data or provide the form to populate new data

		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields( array( 'first_name' => array('type' => 'text_input', 'required' => true),
										      'middle_name' => array('type' => 'text_input'),
										      'last_name' => array('type' => 'text_input', 'required' => true),
											  'title' => array('type' => 'text_input'),
										      'department' => array('type' => 'text_input'),
										      'organization' => array('type' => 'text_input'),
										      'telephone' => array('type' => 'text_input',
															 'attributes' => array('size' => 12),
															 'validation_method' => 'string_like_a_phone_number',
															 'feedback_invalid_input' => "Please enter a valid telephone number for the %s field.",
															 'max_length' => 50
															 ),
											  'mobile' => array('type' => 'text_input',
														  'attributes' => array('size' => 12),
														  'label_text' => 'Mobile Phone',
														  'validation_method' => 'string_like_a_phone_number',
														  'feedback_invalid_input' => "Please enter a valid telephone number for the %s field.",
														  'max_length' => 50),
											  'direct_address' => array('type' => 'email',
																		'required' => true,
																		'validation_method' => 'string_like_a_direct_address',
																		'feedback_invalid_input' => "Please enter a Direct email address for the %s field."
															 ),
											  'shared_with' => array('type' => 'dropdown', 'attributes' => array('multiple' => 'multiple'), 'options' => $this->user_options()),

									));

		$title = $this->title;

		$global_contact = Global_contact::find_one(array('contact_id' => $contact_id));

		if(empty($_POST) && Global_contact::is_an_entity($global_contact)){
			$markup_generator->set_values($global_contact->values_for_display());
			$markup_generator->field('shared_with')->value = array_keys($global_contact->users);
		}elseif(!empty($_POST)){
			$markup_generator->set_values_from_post();

			if(!$markup_generator->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages);
			}else{
				if(!Global_contact::is_an_entity($global_contact)) $global_contact = new Global_contact();
				$global_contact->set_values($markup_generator->values(array_intersect($markup_generator->field_names(), $global_contact->fields())));
				if($global_contact->save() && $global_contact->set_users($markup_generator->value('shared_with'))){
					$this->session->set_flashdata('success_message', '<strong>Success!</strong>&nbsp;&nbsp;The Global Contact has been saved.');
					redirect('adminpanel/global_contacts/update/'.$global_contact->id);
				}
				$error_message = $this->lang->line('error_generic');
			}
		}

		$success_message = element('success_message', $_SESSION);
		$this->load->view('adminpanel/manage_contact_lists/global_contact', compact('error_message', 'success_message', 'markup_generator','title','global_contact'));
	}

	function remove($contact_id){
		if(!Global_contact::formatted_like_an_id($contact_id)) show_404();
		Global_contact::delete($contact_id);
		redirect('/adminpanel/global_contacts/');
	}

	/**
	 * Returns an array of shared global contacts
	 * key = user id
	 * value = user name
	 *
	 * @return array
	 */
	protected function user_options($global_contact = null){
		if(!is_null($global_contact) && !Global_contact::is_an_entity($global_contact)) return $this->error->should_be_a_global_contact($global_contact);
		$options = array();

		User::db()->order_by('user_name', 'ASC');
		$users = (is_null($global_contact)) ? User::find() : $global_contact->users;
		foreach($users as $id => $user){
			$options[$id] = $user->username;
			if($user->is_group())
				$options[$id] .= ' (Group)';
		}

		return $options;
	}

}