<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Install extends CI_Controller {
	var $title = 'Configuration Script';
	var $ldap_ous_to_add = array( 'distribution lists' => LDAP_DISTRUBUTION_LIST_DN,
							      'deleted distribution lists' => LDAP_DELETED_DISTRUBUTION_LIST_DN );
	
	//these are set in the constructor
	var $database_schema = array();
	var $database_queries = array();
	var $database_table_queries = array();
	var $ldap_schema = array();
	
	//we pull our database configuration from constants and use it like CI would,
	//but we don't use the CI Database class in this install script due to the difficulty
	//in getting useful error messages when running multiple queries, which is necessary for creating the tables
	var $db_required_permissions = array('db_datareader' => FALSE, 'db_datawriter' => FALSE);
	var $database_servername = DATABASE_HOSTNAME;
	var $database_config = array (
									'UID'				=> DATABASE_USERNAME,
									'PWD'				=> DATABASE_PASSWORD,
									'Database'			=> 'master',
									'ConnectionPooling' => 0,
									'ReturnDatesAsStrings' => 1,
									'LoginTimeout' => 5,
								  );
								  
	public function __construct(){
		global $installer;
		$installer = TRUE;
		parent::__construct();
		$this->config->set_item('sess_use_database', FALSE);
		$this->config->set_item('sess_encrypt_cookie', FALSE);
		
		require_library('validator');
		$this->load->helper(array('loader','url'));
		$this->load->library(array('session','encrypt'));
		
		//for now the tables will be created in the order they are put in this array,
		//keep that in mind when setting up foreign key relations, etc.
		//TO-DO: Include array sorting function for preferred creation order
		$this->database_schema =  array( 
									'users' =>	array(
													'user_id' => 'bigint',
													'user_edipi' => 'bigint',
													'user_piv_id' => 'bigint',
													'user_name' => 'nvarchar(50)',
													'user_mail' => 'nvarchar(50)',
													'user_theme' => 'bigint',
													'user_ep' => 'nvarchar(max)',
													'user_created_by' => 'bigint',
													'user_created_date' => 'bigint',
													'user_ext_notify_flag' => 'tinyint',
													'user_ext_group_notify_flag' => 'tinyint',
													'user_deleted_flag' => 'tinyint',
													'user_locale' => 'nvarchar(max)',
													'user_is_group' => 'tinyint',
													'default_mailbox' => 'nvarchar(100)',
												),
									'contacts' => array(
															'contact_id' => 'bigint', 
															'user_id' => 'bigint',
															'first_name' => 'varchar(max)',
															'middle_name' => 'varchar(max)',
															'last_name' => 'varchar(max)',
															'organization' => 'nvarchar(max)',
															'department' => 'nvarchar(max)',
															'telephone' => 'nvarchar(50)',
															'mail' => 'nvarchar(50)',
															'title' => 'nvarchar(max)',
														  ),
									'distribution_lists' => array(
															'id' => 'bigint', 
															'name' => 'varchar(max)',
															'description' => 'varchar(max)',
															'created_by' => 'bigint',
															'created_at' => 'bigint',
															'modified_at' => 'bigint',
															'addresses' => 'varchar(max)',
														  ),
									'edit_log' => array(
													'edit_id' => 'bigint',
													'target_user_id' => 'bigint',
													'actor_user_id' => 'bigint',
													'edit_action' => 'text',
													'edit_datetime' => 'bigint',
												),
									'feedback' => array(
													'feedback_id' => 'bigint',
													'user_id' => 'bigint',
													'feedback_type' => 'nvarchar(50)',
													'feedback_comments' => 'text',
													'feedback_datetime' => 'bigint',
												),
									'flags' => array(
													'id' => 'bigint',
													'message_id' => 'bigint',
													'color' => 'varchar(50)',
													'content' => 'varchar(max)',
													'mailbox_group' => 'nvarchar(50)',
													'created_by' => 'bigint',
													'modified_by' => 'bigint',
													'created_at' => 'bigint',
													'modified_at' => 'bigint',
												),
									'logins' => array(
													'id' => 'bigint',
													'session_id' => 'nvarchar(50)',
													'username' => 'varchar(50)',
													'ip_address' => 'nvarchar(50)',
													'login_time' => 'bigint',
													'success' => 'tinyint',
													'error_msg' => 'nvarchar(max)',
												),
									'mail_log' => array(
													'id' => 'bigint',
													'time' => 'bigint',
													'size' => 'bigint',
													'sender' => 'varchar(max)',
													'recipient' => 'varchar(max)',
													'attachment_types' => 'nvarchar(max)',
													'success' => 'tinyint',
													'inbound_outbound' => 'tinyint',
												),
									'requests' => array(
													'request_id' => 'bigint',
													'user_name' => 'nvarchar(max)',
													'user_edipi' => 'bigint',
													'user_piv_id' => 'bigint',
													'request_date' => 'bigint',
													'first_name' => 'varchar(max)',
													'middle_name' => 'varchar(max)',
													'last_name' => 'varchar(max)',
													'organization' => 'nvarchar(max)',
													'department' => 'nvarchar(max)',
													'telephone' => 'nvarchar(50)',
													'mail' => 'nvarchar(max)',
													'title' => 'nvarchar(max)',
													'approved_flag' => 'tinyint',
													'created_flag' => 'tinyint',
													'denied_flag' => 'tinyint',
												),
									'sessions' => array(
													'session_id' => 'varchar(50)',
													'ip_address' => 'varchar(50)',
													'user_agent' => 'varchar(max)',
													'last_activity' => 'int',
													'user_data' => 'text',
													'last_session_id' => 'varchar(50)'
												),
									'themes' => 	array(
													'theme_id' => 'bigint',
													'theme_css_name' => 'nvarchar(50)',
													'theme_display_name' => 'text',
													'theme_preview_bg' => 'nvarchar(max)',
													'theme_banner_img' => 'nvarchar(max)',
													'theme_banner_alt_text' => 'nvarchar(max)',
													'theme_is_default' => 'tinyint',
												),
									'workflow_items' => 	array(
															'id' => 'bigint',
															'message_id' => 'bigint',
															'mailbox_group' => 'nvarchar(50)',
															'assigned_to' => 'bigint',
															'complete' => 'tinyint',
															'created_by' => 'bigint',
															'modified_by' => 'bigint',
															'created_at' => 'bigint',
															'modified_at' => 'bigint',
														),
									'admin_contact_list' => 	array(
																	'contact_id' => 'bigint',
																	'first_name' => 'nvarchar(max)',
																	'middle_name' => 'nvarchar(max)',
																	'last_name' => 'nvarchar(max)',
																	'title' => 'nvarchar(max)',
																	'department' => 'nvarchar(max)',
																	'organization' => 'nvarchar(max)',
																	'telephone' => 'nvarchar(50)',
																	'sharing' => 'nvarchar(max)',
																	'direct_address' => 'nvarchar(max)',
																	'mobile' => 'nvarchar(50)',
																	'modified_by' => 'bigint',
																	'modified_at' => 'bigint',
																),
									'das_results' =>	array(
															'id' => 'bigint',
															'created_by' => 'nvarchar(max)',
															'saved_date' => 'bigint',
															'result_status' => 'nchar(10)',
															'attachment_name' => 'nvarchar(max)',
															'hash_attachment_name' => 'nvarchar(512)',
															'das_document_id' => 'nvarchar(max)',
															'message_id' => 'bigint',
														),
									'archive_settings' =>	array(
																'id' => 'bigint',
																'frequency' => 'varchar(200)',
																'archive_age' => 'int',
																'last_execution_time' => 'bigint',
																'archive_age_unit' => 'nvarchar(200)',
															),
									'response' =>	array(
																	'id' => 'bigint',
																	'message_id' => 'bigint',
																	'parent_id' => 'bigint',
																	'type' => 'nvarchar(10)',
															),
									'announcements' => array(
																	'id' => 'bigint',
																	'content' => 'nvarchar(1000)',
																	'enabled' => 'bit',
																	'updated_at' => 'bigint',
																	'updated_by' => 'bigint',
															),
									'global_contacts_shared' => array(
																	'contact_id' => 'bigint',
																	'user_id' => 'bigint',
															),

								);
		$this->database_queries = array(
									'create_' . DATABASE_NAME => 	"
																	USE [master];
																	IF NOT EXISTS(SELECT name FROM master.sys.databases WHERE name = N'direct')
																	BEGIN
																	CREATE DATABASE [direct]
																	ALTER DATABASE [direct] SET COMPATIBILITY_LEVEL = 100

																	IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
																	BEGIN
																	EXEC [direct].[dbo].[sp_fulltext_database] @action = 'enable'
																	END
																	ALTER DATABASE [direct] SET ANSI_NULL_DEFAULT OFF 
																	ALTER DATABASE [direct] SET ANSI_NULLS OFF 
																	ALTER DATABASE [direct] SET ANSI_PADDING OFF 
																	ALTER DATABASE [direct] SET ANSI_WARNINGS OFF 
																	ALTER DATABASE [direct] SET ARITHABORT OFF 
																	ALTER DATABASE [direct] SET AUTO_CLOSE OFF 
																	ALTER DATABASE [direct] SET AUTO_CREATE_STATISTICS ON 
																	ALTER DATABASE [direct] SET AUTO_SHRINK OFF 
																	ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS ON 
																	ALTER DATABASE [direct] SET CURSOR_CLOSE_ON_COMMIT OFF 
																	ALTER DATABASE [direct] SET CURSOR_DEFAULT  GLOBAL 
																	ALTER DATABASE [direct] SET CONCAT_NULL_YIELDS_NULL OFF 
																	ALTER DATABASE [direct] SET NUMERIC_ROUNDABORT OFF 
																	ALTER DATABASE [direct] SET QUOTED_IDENTIFIER OFF 
																	ALTER DATABASE [direct] SET RECURSIVE_TRIGGERS OFF 
																	ALTER DATABASE [direct] SET  DISABLE_BROKER 
																	ALTER DATABASE [direct] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
																	ALTER DATABASE [direct] SET DATE_CORRELATION_OPTIMIZATION OFF 
																	ALTER DATABASE [direct] SET TRUSTWORTHY OFF 
																	ALTER DATABASE [direct] SET ALLOW_SNAPSHOT_ISOLATION OFF 
																	ALTER DATABASE [direct] SET PARAMETERIZATION SIMPLE 
																	ALTER DATABASE [direct] SET READ_COMMITTED_SNAPSHOT OFF 
																	ALTER DATABASE [direct] SET HONOR_BROKER_PRIORITY OFF 
																	ALTER DATABASE [direct] SET  READ_WRITE 
																	ALTER DATABASE [direct] SET RECOVERY FULL 
																	ALTER DATABASE [direct] SET  MULTI_USER
																	ALTER DATABASE [direct] SET PAGE_VERIFY CHECKSUM  
																	ALTER DATABASE [direct] SET DB_CHAINING OFF
																	END
																	",
								 );
		$this->database_table_queries = array(
									'create_contacts' => "
														USE [".DATABASE_NAME."]
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON
														SET ANSI_PADDING ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND type in (N'U'))
														BEGIN
														USE [".DATABASE_NAME."]
														CREATE TABLE [dbo].[contacts](
															[contact_id] [bigint] IDENTITY(1,1) NOT NULL,
															[user_id] [bigint] NOT NULL,
															[first_name] [varchar](max) NOT NULL,
															[middle_name] [varchar](max) NULL,
															[last_name] [varchar](max) NULL,
															[organization] [nvarchar](max) NULL,
															[department] [nvarchar](max) NULL,
															[telephone] [nvarchar](50) NULL,
															[mail] [nvarchar](50) NOT NULL,
															[title] [nvarchar](max) NULL,
														 CONSTRAINT [PK_contacts] PRIMARY KEY NONCLUSTERED ([contact_id] ASC) 
														 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
														 ON [PRIMARY]
														END

														SET ANSI_PADDING OFF

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_contacts_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[contacts]'))
														BEGIN
														ALTER TABLE [dbo].[contacts]  WITH CHECK ADD  CONSTRAINT [FK_contacts_users] FOREIGN KEY([user_id])
														REFERENCES [dbo].[users] ([user_id])
														END

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_contacts_users]') AND parent_object_id = OBJECT_ID(N'[dbo].[contacts]'))
														BEGIN
														ALTER TABLE [dbo].[contacts] CHECK CONSTRAINT [FK_contacts_users]
														END

														IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND name = N'PK_contacts')
														ALTER TABLE [dbo].[contacts] DROP CONSTRAINT [PK_contacts]
														/****** Object:  Index [PK_contacts]    Script Date: 11/15/2013 07:17:11 ******/
														ALTER TABLE [dbo].[contacts] ADD  CONSTRAINT [PK_contacts] PRIMARY KEY NONCLUSTERED 
														([contact_id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]

														IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[contacts]') AND name = N'IX_contact_user')
														CREATE CLUSTERED INDEX [IX_contact_user] ON [dbo].[contacts] 
														([user_id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
														",
									'create_distribution_lists' => "
																	USE [".DATABASE_NAME."];
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[distribution_lists]') AND type in (N'U'))
																	BEGIN
																	CREATE TABLE [dbo].[distribution_lists](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[name] [varchar](max) NOT NULL,
																		[description] [varchar](max) NULL,
																		[created_by] [bigint] NOT NULL,
																		[created_at] [bigint] NOT NULL,
																		[modified_at] [bigint] NOT NULL,
																		[addresses] [varchar](max) NOT NULL default '',
																	 CONSTRAINT [PK_distribution_lists] PRIMARY KEY NONCLUSTERED ([id] ASC)
																	 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
																	 ON [PRIMARY]
																	END
																	SET ANSI_PADDING OFF

																	IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_user]') AND parent_object_id = OBJECT_ID(N'[dbo].[distribution_lists]'))
																	BEGIN
																	ALTER TABLE [dbo].[distribution_lists]  WITH CHECK ADD  CONSTRAINT [FK_user] FOREIGN KEY([created_by])
																	REFERENCES [dbo].[users] ([user_id])
																	END

																	IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_user]') AND parent_object_id = OBJECT_ID(N'[dbo].[distribution_lists]'))
																	BEGIN
																	ALTER TABLE [dbo].[distribution_lists] CHECK CONSTRAINT [FK_user]
																	END

																	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[distribution_lists]') AND name = N'IX_distribution_lists')
																	BEGIN
																	CREATE CLUSTERED INDEX [IX_distribution_lists] ON [dbo].[distribution_lists] ([created_by] ASC)
																	WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
																	END
																",
									'create_edit_log'	=>		"
																USE [".DATABASE_NAME."];
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[edit_log]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[edit_log](
																	[edit_id] [bigint] IDENTITY(1,1) NOT NULL,
																	[target_user_id] [bigint] NOT NULL,
																	[actor_user_id] [bigint] NOT NULL,
																	[edit_action] [text] NOT NULL,
																	[edit_datetime] [bigint] NOT NULL,
																CONSTRAINT [PK_edit_log] PRIMARY KEY CLUSTERED ([edit_id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																",
									'create_feedback'	=>		"
																USE [".DATABASE_NAME."];
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON
																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[feedback]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[feedback](
																	[feedback_id] [bigint] IDENTITY(1,1) NOT NULL,
																	[user_id] [bigint] NOT NULL,
																	[feedback_type] [nvarchar](50) NOT NULL,
																	[feedback_comments] [text] NOT NULL,
																	[feedback_datetime] [bigint] NOT NULL,
																CONSTRAINT [PK_feedback] PRIMARY KEY CLUSTERED ([feedback_id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																",
									'create_flags' => "
														USE [".DATABASE_NAME."];
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON
														SET ANSI_PADDING ON
														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[flags]') AND type in (N'U'))
														BEGIN
														CREATE TABLE [dbo].[flags](
															[id] [bigint] IDENTITY(1,1) NOT NULL,
															[message_id] [bigint] NOT NULL,
															[color] [varchar](50) NULL,
															[content] [varchar](max) NULL,
															[mailbox_group] [nvarchar](50) NOT NULL,
															[created_by] [bigint] NOT NULL,
															[modified_by] [bigint] NOT NULL,
															[created_at] [bigint] NOT NULL,
															[modified_at] [bigint] NOT NULL,
														CONSTRAINT [PK_flag] PRIMARY KEY NONCLUSTERED 
														([id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
														END

														SET ANSI_PADDING OFF

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
														BEGIN
														ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_created_by] FOREIGN KEY([created_by])
														REFERENCES [dbo].[users] ([user_id])
														END

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
														BEGIN
														ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_created_by]
														END

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
														BEGIN
														ALTER TABLE [dbo].[flags]  WITH CHECK ADD CONSTRAINT [FK_modified_by] FOREIGN KEY([modified_by])
														REFERENCES [dbo].[users] ([user_id])
														END

														IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[flags]'))
														BEGIN
														ALTER TABLE [dbo].[flags] CHECK CONSTRAINT [FK_modified_by]
														END

														IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[flags]') AND name = N'IX_flags')
														BEGIN
														CREATE CLUSTERED INDEX [IX_flags] ON [dbo].[flags] ([created_by] ASC) 
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
														END
														",
									'create_logins' => "
														USE [".DATABASE_NAME."];
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON
														SET ANSI_PADDING ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[logins]') AND type in (N'U'))
														BEGIN
														CREATE TABLE [dbo].[logins](
															[id] [bigint] IDENTITY(1,1) NOT NULL,
															[session_id] [nvarchar](50) NULL,
															[username] [varchar](50) NULL,
															[ip_address] [nvarchar](50) NULL,
															[login_time] [bigint] NULL,
															[success] [tinyint] NOT NULL,
															[error_msg] [nvarchar](max) NULL,
														 CONSTRAINT [PK_logins] PRIMARY KEY CLUSTERED ([id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
														SET ANSI_PADDING OFF
														END
														",
									'create_mail_log' =>	"
															USE [".DATABASE_NAME."];
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															SET ANSI_PADDING ON

															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mail_log]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[mail_log](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[time] [bigint] NULL,
																[size] [bigint] NULL,
																[sender] [varchar](max) NULL,
																[recipient] [varchar](max) NULL,
																[attachment_types] [nvarchar](max) NULL,
																[success] [tinyint] NOT NULL,
																[inbound_outbound] [tinyint] NOT NULL,
															 CONSTRAINT [PK_mail_log] PRIMARY KEY CLUSTERED ([id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															SET ANSI_PADDING OFF
															END
															",
									'create_requests' =>	"
															USE [".DATABASE_NAME."];
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															SET ANSI_PADDING ON

															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[requests]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[requests](
																[request_id] [bigint] IDENTITY(1,1) NOT NULL,
																[user_name] [nvarchar](max) NOT NULL,
																[user_edipi] [bigint] NULL,
																[request_date] [bigint] NOT NULL,
																[first_name] [varchar](max) NULL,
																[middle_name] [varchar](max) NULL,
																[last_name] [varchar](max) NULL,
																[organization] [nvarchar](max) NULL,
																[department] [nvarchar](max) NULL,
																[telephone] [nvarchar](50) NULL,
																[mail] [nvarchar](max) NOT NULL,
																[title] [nvarchar](max) NULL,
																[approved_flag] [tinyint] NOT NULL,
																[created_flag] [tinyint] NOT NULL,
																[denied_flag] [tinyint] NOT NULL,
																[user_piv_id] [bigint] NULL,
															 CONSTRAINT [PK_requests] PRIMARY KEY CLUSTERED ([request_id] ASC)
															WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															END
															SET ANSI_PADDING OFF
															",
									'create_sessions' =>	"
															USE [".DATABASE_NAME."];
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															SET ANSI_PADDING ON

															IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sessions]') AND type in (N'U'))
															BEGIN
															CREATE TABLE [dbo].[sessions](
																[session_id] [varchar](50) NOT NULL,
																[ip_address] [varchar](50) NOT NULL,
																[user_agent] [varchar](max) NOT NULL,
																[last_activity] [int] NOT NULL,
																[user_data] [text] NULL,
															 CONSTRAINT [PK_sessions] PRIMARY KEY CLUSTERED ([session_id] ASC)
															 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
															END
															SET ANSI_PADDING OFF
															",
									'create_themes' =>	"
														USE [".DATABASE_NAME."];
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[themes]') AND type in (N'U'))
														BEGIN
														CREATE TABLE [dbo].[themes](
															[theme_id] [bigint] IDENTITY(1,1) NOT NULL,
															[theme_css_name] [nvarchar](50) NOT NULL,
															[theme_display_name] [text] NOT NULL,
															[theme_preview_bg] [nvarchar](max) NOT NULL,
															[theme_banner_img] [nvarchar](max) NOT NULL,
															[theme_banner_alt_text] [nvarchar](max) NOT NULL,
															[theme_is_default] [tinyint] NULL,
														 CONSTRAINT [PK_themes] PRIMARY KEY CLUSTERED ([theme_id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
														SET IDENTITY_INSERT [dbo].[themes] ON
														INSERT [dbo].[themes] ([theme_id], [theme_css_name], [theme_display_name], [theme_preview_bg], [theme_banner_img], [theme_banner_alt_text], [theme_is_default]) VALUES (1, N'va', N'VA direct Project', N'#1174AB', N'banner_va.png', N'VA Direct- Simple, Secure Health Messaging', 1)
														SET IDENTITY_INSERT [dbo].[themes] OFF
														END
														",
									'create_users' =>	"
														USE [".DATABASE_NAME."];
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[users]') AND type in (N'U'))
														BEGIN
														CREATE TABLE [dbo].[users](
															[user_id] [bigint] IDENTITY(1,1) NOT NULL,
															[user_edipi] [bigint] NULL,
															[user_name] [nvarchar](50) NOT NULL,
															[user_mail] [nvarchar](50) NULL,
															[user_theme] [bigint] NOT NULL,
															[user_ep] [nvarchar](max) NOT NULL,
															[user_created_by] [bigint] NOT NULL,
															[user_created_date] [bigint] NOT NULL,
															[user_ext_notify_flag] [tinyint] NOT NULL,
															[user_ext_group_notify_flag] [tinyint] NOT NULL,
															[user_deleted_flag] [tinyint] NOT NULL,
															[user_locale] [nvarchar](max) NULL,
															[user_is_group] [tinyint] NOT NULL,
															[user_piv_id] [bigint] NULL,
															[default_mailbox] [nvarchar] (100) NULL,
														 CONSTRAINT [PK_users2] PRIMARY KEY CLUSTERED ([user_id] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY], 
														 UNIQUE NONCLUSTERED ([user_name] ASC)
														WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
														ALTER TABLE users ADD UNIQUE (user_name)
														END
														",
									'create_workflow_items' =>	"
																USE [".DATABASE_NAME."];
																SET ANSI_NULLS ON
																SET QUOTED_IDENTIFIER ON
																SET ANSI_PADDING ON

																IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[workflow_items]') AND type in (N'U'))
																BEGIN
																CREATE TABLE [dbo].[workflow_items](
																	[id] [bigint] IDENTITY(1,1) NOT NULL,
																	[message_id] [bigint] NOT NULL,
																	[mailbox_group] [nvarchar](50) NOT NULL,
																	[assigned_to] [bigint],
																	[complete] [tinyint] NOT NULL DEFAULT 0,
																	[created_by] [bigint] NOT NULL,
																	[modified_by] [bigint] NOT NULL,
																	[created_at] [bigint] NOT NULL,
																	[modified_at] [bigint] NOT NULL,
																 CONSTRAINT [PK_workflow_flag] PRIMARY KEY NONCLUSTERED ([id] ASC)
																WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																END
																SET ANSI_PADDING OFF

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_mailbox_group]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
																BEGIN
																ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_mailbox_group] 	
																	FOREIGN KEY([mailbox_group])
																	REFERENCES [dbo].[users] ([user_name])
																ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_mailbox_group]
																END

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_assigned_to]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
																BEGIN
																ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_assigned_to] 	
																	FOREIGN KEY([assigned_to])
																	REFERENCES [dbo].[users] ([user_id])
																ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_assigned_to]
																END
																	

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_created_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
																BEGIN
																ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_created_by] 	
																	FOREIGN KEY([created_by])
																	REFERENCES [dbo].[users] ([user_id])
																ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_created_by]
																END

																IF  NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_workflow_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[workflow_items]'))
																BEGIN
																ALTER TABLE [dbo].[workflow_items]  WITH CHECK ADD CONSTRAINT [FK_workflow_modified_by] 
																	FOREIGN KEY([modified_by])
																	REFERENCES [dbo].[users] ([user_id])
																	
																ALTER TABLE [dbo].[workflow_items] CHECK CONSTRAINT [FK_workflow_modified_by]
																END
																",
									'create_admin_contact_list' => 	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	CREATE TABLE [dbo].[admin_contact_list](
																		[contact_id] [bigint] IDENTITY(1,1) NOT NULL,
																		[first_name] [nvarchar](max) NOT NULL,
																		[middle_name] [nvarchar](max) NULL,
																		[last_name] [nvarchar](max) NOT NULL,
																		[title] [nvarchar](max) NULL,
																		[department] [nvarchar](max) NULL,
																		[organization] [nvarchar](max) NULL,
																		[telephone] [nvarchar](50) NULL,
																		[sharing] [nvarchar](max) NULL,
																		[direct_address] [nvarchar](max) NOT NULL,
																		[mobile] [nvarchar](50) NULL,
																		[modified_by] [bigint] NULL,
																		[modified_at] [bigint] NULL,
																	 CONSTRAINT [PK_admin_contact_list] PRIMARY KEY CLUSTERED ([contact_id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	SET ANSI_PADDING OFF
																	IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_modified_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[admin_contact_list]'))
																	BEGIN
																	ALTER TABLE [dbo].[admin_contact_list]  WITH CHECK ADD  CONSTRAINT [FK_modified_by_users] FOREIGN KEY([modified_by])
																		REFERENCES [dbo].[users] ([user_id])
																	END
																	",
									'create_das_results' =>	"
															USE [".DATABASE_NAME."]
															SET ANSI_NULLS ON
															SET QUOTED_IDENTIFIER ON
															CREATE TABLE [dbo].[das_results](
																[id] [bigint] IDENTITY(1,1) NOT NULL,
																[created_by] [nvarchar](max) NULL,
																[saved_date] [bigint] NULL,
																[result_status] [nchar](10) NULL,
																[attachment_name] [nvarchar](max) NULL,
																[hash_attachment_name] [nvarchar](512) NULL,
																[das_document_id] [nvarchar](max) NULL,
																[message_id] [bigint] NULL,
																CONSTRAINT [PK_das_results] PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
															",
									'create_archive_settings' =>	"
																	USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	SET ANSI_PADDING ON
																	CREATE TABLE [dbo].[archive_settings](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[frequency] [varchar](200) NOT NULL,
																		[archive_age] [int] NOT NULL,
																		[last_execution_time] [bigint] NOT NULL,
																		[archive_age_unit] [nvarchar](200) NOT NULL,
																	CONSTRAINT [PK_archive_settings] PRIMARY KEY CLUSTERED ([id] ASC) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]) ON [PRIMARY]
																	SET ANSI_PADDING OFF
																	SET IDENTITY_INSERT [dbo].[archive_settings] ON
																	INSERT [dbo].[archive_settings] ([id], [frequency], [archive_age], [last_execution_time]) VALUES (1, N'daily', 1, 1406180060)
																	SET IDENTITY_INSERT [dbo].[archive_settings] OFF
																	",
									'create_response' => "USE [".DATABASE_NAME."]
																	SET ANSI_NULLS ON
																	SET QUOTED_IDENTIFIER ON
																	CREATE TABLE [dbo].[response](
																		[id] [bigint] IDENTITY(1,1) NOT NULL,
																		[message_id] [bigint] NOT NULL,
																		[parent_id] [bigint] NOT NULL,
																		[type] [nvarchar](10) NOT NULL,
																	 CONSTRAINT [PK_response] PRIMARY KEY CLUSTERED 
																	(
																		[id] ASC
																	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
																	) ON [PRIMARY]
																	
																					",
									'create_announcements' => " 
														USE [".DATABASE_NAME."]
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON
														SET ANSI_PADDING ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[announcements]') AND type in (N'U'))
														BEGIN
														USE [".DATABASE_NAME."]
														CREATE TABLE [dbo].[announcements](
															[id] [bigint] IDENTITY(1,1) NOT NULL,
															[enabled] [bit] NULL,
															[content] [nvarchar](1000) NULL,
															[updated_at] [bigint] NULL,
															[updated_by] [bigint] NULL,
														 CONSTRAINT [PK_announcements] PRIMARY KEY NONCLUSTERED ([id] ASC) 
														 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
														 ON [PRIMARY]
														END
														SET ANSI_PADDING OFF
														SET IDENTITY_INSERT [dbo].[announcements] ON
														INSERT [dbo].[announcements] ([id], [content], [enabled], [updated_at], [updated_by]) VALUES (1,NULL,0,NULL,NULL)
														SET IDENTITY_INSERT [dbo].[announcements] OFF
														IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_updated_by]') AND parent_object_id = OBJECT_ID(N'[dbo].[announcements]'))
														BEGIN
														ALTER TABLE [dbo].[announcements]  WITH CHECK ADD  CONSTRAINT [FK_updated_by_users] FOREIGN KEY([updated_by])
														REFERENCES [dbo].[users] ([user_id])
														END
								",
								'create_global_contacts_shared' => " 
														USE [".DATABASE_NAME."]
														SET ANSI_NULLS ON
														SET QUOTED_IDENTIFIER ON
														SET ANSI_PADDING ON

														IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[global_contacts_shared]') AND type in (N'U'))
														BEGIN
														USE [".DATABASE_NAME."]
														CREATE TABLE [dbo].[global_contacts_shared](
															[contact_id] [bigint] NOT NULL CONSTRAINT FK_shared_global_contacts FOREIGN KEY references dbo.admin_contact_list (contact_id),
															[user_id] [bigint] NOT NULL CONSTRAINT FK_global_contacts_shared_with_users FOREIGN KEY references dbo.users (user_id),	

														 CONSTRAINT shared_global_contacts_unique UNIQUE(contact_id, user_id)
														 WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY])
														 ON [PRIMARY]
														END
														SET ANSI_PADDING OFF
				",
								);
			$this->ldap_schema = array(
									LDAP_BASE_DOMAIN => array('objectClass' => array('dcObject','organization','top'),'dc'=>'','o'=>'nodomain'),
									'cn=admin,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalRole','simpleSecurityObject'),'cn'=>'admin','userPassword' => '', 'description' => 'LDAP Administrator'),
									'cn=domains,'.LDAP_BASE_DOMAIN => array('objectClass' => 'organizationalRole', 'cn' => 'domains'),
									'cn=webmailsearch,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalRole','simpleSecurityObject'),'cn'=>'webmailsearch','userPassword' => '', 'description' => 'System account for anonymous LDAP search'),
									'ou=admins,'.LDAP_BASE_DOMAIN => array('objectClass' => 'groupOfNames', 'cn' => 'admins', 'member' => 'cn=admin,'.LDAP_BASE_DOMAIN, 'ou' => 'admins'),
									'ou=deletedaccounts,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'deletedaccounts'),
									'ou=deleteddistributionlists,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'deleteddistributionlists'),
									'ou=deletedgroups,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'deletedgroups'),
									'ou=accounts,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'accounts'),
									'ou=distributionlists,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'distributionlists'),
									'ou=groups,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'groups'),
									'ou=pwpolicies,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => array('policies','pwpolicies')),
									'cn=default,ou=pwpolicies,'.LDAP_BASE_DOMAIN => array('objectClass' => array('device','pwdPolicy'), 'cn' => 'default', 'pwdAttribute' => '2.5.4.35', 'pwdAllowUserChange' => 'FALSE', 'pwdExpireWarning' => '3600', 'pwdInHistory' => '5', 'pwdLockout' => 'TRUE', 'pwdLockoutDuration' => '3600', 'pwdMaxAge' => '5184000', 'pwdMinLength' => '15', 'pwdMustChange' => 'TRUE', 'pwdSafeModify' => 'FALSE'),
									'ou=roles,'.LDAP_BASE_DOMAIN => array('objectClass' => array('organizationalUnit','top'),'ou' => 'roles'),
									'ou=facilityleader,ou=roles,'.LDAP_BASE_DOMAIN =>  array('objectClass' => 'groupOfNames','cn' => 'Facility Leader', 'member' => 'cn=admin,'.LDAP_BASE_DOMAIN, 'ou' => 'groupleader'),
									'ou=groupleader,ou=roles,'.LDAP_BASE_DOMAIN => array('objectClass' => 'groupOfNames','cn' => 'Group Leader', 'member' => 'cn=admin,'.LDAP_BASE_DOMAIN, 'ou' => 'facilityleader'),
								);
	}
	
	public function index() {
		$this->load_install_view();
	}
	public function ldap() {
		$this->load_install_view('ldap');
	}
	public function database() {
		$this->load_install_view('database');
	}
	public function create_user() {
		$this->load_install_view('create_user');
	}
	
	public function create_db() {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$query = $this->database_queries['create_'.DATABASE_NAME];
			$stmt = sqlsrv_query($conn, $query);
			$errors = array();
			if($stmt) {
				//check the entire query for errors, since it has multiple parts
				while(!is_null(sqlsrv_next_result($stmt))) {
					$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
					if(is_array($sql_errors)) {
						foreach($sql_errors as $error) {
							array_push($errors, $error);
						}
					}
				}
			}
			else { $errors = sqlsrv_errors(SQLSRV_ERR_ERRORS); }
			$this->session->set_flashdata('create_db_errors', $errors);
		}
		if($conn && $stmt && empty($errors)) {
			foreach($this->database_schema as $table => $columns) {
				$this->_create_db_table($table);
			}
		}
		redirect('install/database');
	}
	public function create_db_table($table) {
		$this->_create_db_table($table);
		redirect('install/database');
	}
	
	public function regenerate_passwords(){
		$this->load->database();
		$query = $this->db->get('users');
		if($query){
			$users = $query->result();
			echo "<h3>Regenerate Passwords</h3>";
			foreach ($users as $user){
				$uid = $user->user_name;
				$ep = $this->random_password();
				
				echo "<br/>$uid: ";
				if($this->is_ascii($ep)){
					echo "Updating Database";
					$query = $this->db->query("UPDATE users SET user_ep=".$this->db->escape($this->encrypt->encode($ep))." WHERE user_name=" . $this->db->escape($uid));
					echo "...";
					if($query) {
						echo '<span style="color:green">OK</span>';
						echo '...Updating LDAP...';
						$ldap_conn = $this->prepare_ldap_conn();
						$ldap_bind = @ldap_bind($ldap_conn, LDAP_ADMIN_USERNAME, LDAP_ADMIN_PASSWORD);
						if($ldap_bind) {
							$dn = 'uid='.$uid.','.LDAP_ACCOUNTS_DN;
							if($this->ldap_entry_exists($ldap_conn, $dn)) {
								$success = ldap_modify($ldap_conn, $dn, array('userPassword' => $this->encrypt->ssha256_encode($ep)));
								if($success) {
									echo '<span style="color:green">OK</span>';
								}
								else {
									echo '<span style="color:red">Error: Unable to modify LDAP account</span>';
								}
							}
							else {
								echo '<span style="color:red">Error: Unable to locate LDAP account</span>';
							}
						}
						else {
							echo '<span style="color:red">Error: Unable to bind to LDAP</span>';
						}
					}
					else {
						echo '<span style="color:red">Error: Unable to find user in database</span>';
					}
				}
			}
		}
		else{
			echo "Could not get users";
		}
		echo '<br/><a href="/install">Back</a>';
	}
	
	private function _create_db_table($table) {
		if($this->input->post('sa_name') && $this->input->post('sa_pwd')) {
			$sa_name = $this->input->post('sa_name',TRUE);
			$sa_pwd = $this->input->post('sa_pwd',TRUE);
			$this->database_config['UID'] = $sa_name;
			$this->database_config['PWD'] = $sa_pwd;
		}
		if(array_key_exists($table, $this->database_schema)) {
			$conn = sqlsrv_connect($this->database_servername, $this->database_config);
			if($conn) {
				$query = $this->database_table_queries['create_'.$table];
				$stmt = sqlsrv_query($conn, $query);
				$errors = array();
				if($stmt) {
					//check the entire query for errors, since it has multiple parts
					while(!is_null(sqlsrv_next_result($stmt))) {
						$sql_errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
						if(is_array($sql_errors)) {
							foreach($sql_errors as $error) {
								array_push($errors, $error);
							}
						}
					}
				}
				else {
					$errors = sqlsrv_errors(SQLSRV_ERR_ERRORS);
				}
				//if we found errors
				if(!empty($errors)) {
					$this->session->set_flashdata($table.'_errors',$errors);
					$this->session->set_flashdata($table.'_query',$query);
				}
			}
			else {
				$this->session->set_flashdata($table.'_errors',sqlsrv_errors());
				$this->session->set_flashdata($table.'_query',$query);
			}
		}
		else {
			$this->session->set_flashdata($table.'_errors','This table does not exist in the configured schema.');
			$this->session->set_flashdata($table.'_query',$query);
		}
	}
	
	private function load_install_view($page = 'database') {
		$this->load->helper('form_helper');
		$this->output->append_output('
			<!doctype html>
			<html>
				<head>
					<title>'.$this->title.'</title>
				</head>
				<body>
					<div class="wrapper">
						<div class="nav">
							<a href="/install/database">Database</a>
							<a href="/install/ldap">LDAP</a>
							<a href="/install/create_user">Create User</a>
							<a href="/install/regenerate_passwords">Regenerate Passwords</a>
							<a href="/install/apply_default_mailbox">Set Default Mailboxes</a>
							<a href="/install/update_shared_global_contacts">Update Shared Global Contacts</a>
						</div>
						<div>
		');
		if($page === 'database') { 
			$this->output->append_output('<h2>Database</h2>');
			$this->output->append_output($this->db_configuration_table());
		}
		else if($page === 'ldap') {
			$this->output->append_output('<h2>LDAP</h2>');
			$this->output->append_output($this->ldap_configuration_table());
		}
		else if($page === 'create_user') {
			$this->output->append_output('<h2>Create User</h2>');
			$this->output->append_output($this->create_user_form());
		}
		$this->output->append_output('
						</div>
					</div>
				</body>
			</html>
		');
	}
	
	private function ldap_configuration_table() {
		$this->load->helper('form');
		$output = '';
		$ldap_dns = array();
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_SEARCH_USERNAME, LDAP_SEARCH_PASSWORD);
		if($ldap_bind) {
			$search = @ldap_list($ldap_conn, $base_dn, '(objectClass=*)');
			$result = @ldap_get_entries($ldap_conn, $search);
			$output .= '<table style="border: solid black 1px;">';
			$output .= '<tr><th>Required LDAP Schema</th><th>Status</th></tr>';
			foreach($this->ldap_schema as $dn => $values) {
				if($this->ldap_entry_exists($ldap_conn, $dn)) {
					$output .= '<tr><td style="color: green;">'.$dn.'<td><td style="color: green;">&#x2714;</td></tr>';
				}
				else { $output .= '<tr><td style="color: red;">'.$dn.'<td><td style="color: red;">&#x2717;</td><td>'.form_open('/install/create_ldap_entry/'.rawurlencode(base64_encode($dn))).form_submit('create','Create').form_close().'</td></tr>'; }
			}
			$output .= '</table>';
		}
		else { $output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.ldap_error($ldap_conn).'</div>'; }
		return $output;
	}
	
	public function create_user_submit() {
		require_model('user');
		
		$user_name = $this->input->post('username', TRUE);
		
		$first_name = $this->input->post('first_name', TRUE);
		$last_name = $this->input->post('last_name', TRUE);
		$user_mail = $this->input->post('user_email', TRUE);
		
		if(USE_PIV_AUTH)
			$user_piv_id = $this->input->post('user_id', TRUE);
		if(USE_CAC_AUTH)
			$user_edipi =  $this->input->post('user_id', TRUE);
		
		$user = User::create(compact('user_name', 'user_mail', 'user_piv_id', 'user_edipi'));
		
		if(User::is_an_entity($user)) {
			$this->session->set_flashdata('messages','Successfully created user.');
		}
		else {
			$this->session->set_flashdata('errors','Failed to create user.');
		}
		redirect('install');
	}
	
	private function create_user_form() {
		$output = '';
		$this->load->helper('form');
		$output .= form_open('install/create_user_submit');
		$output .= '<table>';
		$output .= '<tr><td>'.form_label('Username','username').'</td>';
		$output .= '<td>'.form_input(array('id'=>'username','name'=>'username')).'</td>';
		$output .= '<td>'.form_label('ID','user_id').'</td>';
		$output .= '<td>'.form_input(array('id'=>'user_id','name'=>'user_id')).'</td></tr>';
		$output .= '<tr><td>'.form_label('First Name','first_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'first_name','name'=>'first_name')).'</td>';
		$output .= '<td>'.form_label('Last Name','last_name').'</td>';
		$output .= '<td>'.form_input(array('id'=>'last_name','name'=>'last_name')).'</td></tr>';
		$output .= '<tr><td>'.form_label('Email Address','user_email').'</td>';
		$output .= '<td>'.form_input(array('id'=>'user_email','name'=>'user_email')).'</td></tr>';
		$output .= '</table>';
		$output .= form_submit('create_user_submit','Create User');
		$output .= form_close();
		return $output;
	}
	
	private function _db_connects() {
		$connects = FALSE;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) { 
			$connects = TRUE; 
			sqlsrv_close($conn);
		}
		else {
			if(sqlsrv_errors()) {
				$this->session->set_flashdata('db_connects_errors', sqlsrv_errors());
			}
		}
		return $connects;
	}
	
	private function _db_exists() {
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$db_exist_query = "SELECT name FROM master.sys.databases WHERE name = N'".DATABASE_NAME."'";
			$stmt = sqlsrv_query($conn, $db_exist_query, array(), array('Scrollable'=>'buffered'));
			if($stmt) {
				$num_rows = sqlsrv_num_rows($stmt);
				if($num_rows && ($num_rows > 0)) { return TRUE; }
				//db does not exist yet, or possibly we don't have permissions to see it
				else { return FALSE; }
			}
			else {
				$errors = array();
				foreach(sqlsrv_errors() as $error) {
					array_push($errors, $error);
				}
				$this->session->set_flashdata('db_exists_errors', $errors);
			}
		}
		return FALSE;
	}
	
	private function _db_permissions_set($database = DATABASE_NAME, $user = DATABASE_USERNAME, $permissions = NULL) {
		//if permissions to check are not provided by the function call, set them from defaults
		$required_permissions = empty($permissions) ? $this->db_required_permissions : $permissions;
		$conn = sqlsrv_connect($this->database_servername, $this->database_config);
		if($conn) {
			$permission_query = "USE [".$database."]; EXEC sp_helprolemember";
			$stmt = sqlsrv_query($conn, $permission_query);
			if($stmt) {
				do {
					while($row = sqlsrv_fetch_array($stmt)) {
						if($row['MemberName'] === $user) {
							if(array_key_exists($row['DbRole'], $required_permissions)) {
								$required_permissions[$row['DbRole']] = TRUE;
							}
						}
					}
				}
				while(sqlsrv_next_result($stmt));
			}
			else {
				$this->session->set_flashdata('db_permissions_set_errors', sqlsrv_errors());
			}
		}
		//if permissions are missing, set which ones are missing in flashdata to display
		if((in_array(FALSE, $required_permissions))) {
			$missing_permissions = array();
			foreach($required_permissions as $key => $permission) {
				if(!$permission) { array_push($missing_permissions, $key); }
			}
			$this->session->set_flashdata('db_permissions_missing', $missing_permissions);
		}
		return !(in_array(FALSE, $required_permissions));
	}
	
	public function db_configuration_table() {
		$this->load->helper('form');
		$output = '';
		//check database permissions / connection / database existence
		$db_connected = $this->_db_connects();
		$db_exists = $this->_db_exists();
		$permissions_set = $this->_db_permissions_set(DATABASE_NAME);
	
		//if connection calls fails
		if(!$db_connected) {
			$errors = $this->session->flashdata('db_connects_errors');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('is not able to access the database "master" under the current security context', $error['message']) >= 0) { $permission_issue = TRUE; }
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Connection errors encountered. Refresh page for more details.</div>';
			}
			//if there is a permissions error with the master db, we can't do anything really, give all the 
			//queries necessary to set up the database as raw text for manual set-up
			if(isset($permission_issue) && $permission_issue) {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
							A permissions issue is preventing retrieval of information from the master database that will allow this script to determine if the required database, tables, and permissions
							exist for the configured user. This is most likely due to security restrictions that have been purposefully set in place. 
							However, it is not possible for this script to proceed with automated set-up of the database. The queries required to set up
							the database have been provided below for a database administrator to set up manually.
							</div>';
				$output .= '<h3>Create required databases</h3>';
				foreach($this->database_queries as $key => $query) {
					if(strpos('create',$key) >= 0) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
				$output .= '<h3>Create required tables</h3>';
				foreach($this->database_table_queries as $key => $query) {
					if(strpos('create',$key) >= 0) {
						$output .= '<pre>'.preg_replace('/[\t]+/',' ',$query).'</pre>';
					}
				}
			}
		}
		//if db existence call fails
		if($db_connected && !$db_exists) {
			$errors = $this->session->flashdata('db_exists_errors') ? $this->session->flashdata('db_exists_errors') : array();
			$create_errors = $this->session->flashdata('create_db_errors') ? $this->session->flashdata('create_db_errors') : array();
			$errors = array_merge($errors, $create_errors);
			$errors = empty($errors) ? FALSE : $errors;
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('permission_denied',strtolower($error['message'])) >= 0) {
							$permissions_issue = TRUE;
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
					}
				}
			}
			//if there was a permissions issue when creating the database, allow user to try other credentials
			if(isset($permissions_issue) && $permissions_issue) {
				$output .= form_open('install/create_db')
							.form_label('Privileged SQL User: ','sa_name')
							.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
							.form_label('Privileged SQL User Password: ','sa_pwd')
							.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
							.form_submit('create_db','Create Database')
							.form_close();
				$output .= '<div>To manually create database <span style="font-weight: bold;">'.DATABASE_NAME.'</span> run the following query: <br />';
				$output .= '<pre>'.preg_replace('/[\t]+/',' ',$this->database_queries['create_'.DATABASE_NAME]).'</pre></div>';
			}
			else {
				$output .= form_open('install/create_db').form_submit('create_db','Create Database').form_close();
			}
		}
		//if the database server connects, we know the database exists, but the permissions the configured user has
		//aren't configured correctly
		if($db_connected && $db_exists && !$permissions_set) {
			$errors = $this->session->flashdata('db_permissions_set_errors');
			$missing_permissions = $this->session->flashdata('db_permissions_missing');
			if($errors) {
				if(is_array($errors)) {
					foreach($errors as $error) {
						if(strpos('not able to access database "'.DATABASE_NAME.'"',$error['message']) >= 0) {
							$add_user_query = 'USE ['.DATABASE_NAME.']; CREATE USER ['.DATABASE_USERNAME.'] FROM LOGIN ['.DATABASE_USERNAME.'] WITH DEFAULT_SCHEMA=[dbo];';
						}
						$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						if(isset($add_user_query)) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'
										.'An error has been detected that may indicate the configured user login has not yet been added to the ' . DATABASE_NAME . ' as a user. '
										.'Use the following query to add the configured login user to the database: <br/>'
										.'<pre>'.$add_user_query.'</pre>'
										.'</div>';
						}
					}
				}
			}
			//if errors are missing (and there had to be some if we are here), flashdata is full
			else {
				$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">Permissions errors encountered. Refresh page for more details.</div>';
			}
			if(!empty($missing_permissions) && $missing_permissions) {
				foreach($missing_permissions as $permission) {
					$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">
								The configured user: '.DATABASE_USERNAME.' is missing the '.$permission.' role.
								Use the following query to grant the required role to this user:<br/>
								<pre>USE ['.DATABASE_NAME.']; EXEC sp_addrolemember \'db_datareader\', \''.DATABASE_USERNAME.'\';</pre>
								</div>';
				}
			}
		}
		//if the database already exists, and the configured user has permissions needed for running the app 
		//NOTE: permissions checking checks roles only, not all permissions, user may still not be able to create tables
		if($db_connected && $db_exists && $permissions_set) {
			$this->load->database();
			foreach($this->database_schema as $table => $columns) {
				$errors = $this->session->flashdata($table.'_errors');
				$query = $this->session->flashdata($table.'_query');
				if($errors) {
					if(is_array($errors)) {
						foreach($errors as $error) {
							$output .= '<div style="max-width: 1000px; background: #fef1ec; border: solid 1px #900; border-radius: 5px; padding: 5px; margin-bottom: 5px;">'.$error['message'].'</div>';
						}
					}
				}
				//TABLE START
				$output .= '<table style="border: solid black 1px; border-collapse: collapse; margin-right: 15px; margin-bottom: 15px; width: 400px;">';
				
				$tbl_check_query = 'SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE='.$this->db->escape('BASE TABLE').' AND TABLE_NAME='.$this->db->escape($table);
				$tbl_check = $this->db->query($tbl_check_query);
				//query to check table existence works
				if($tbl_check) {
					//if the table does not exist
					if($tbl_check->num_rows() <= 0) {
						//check for errors from a previously run query
						if($errors) {
							$permission_issue = FALSE;
							foreach($errors as $error) {
								if(strpos('permission denied', $error['message']) >= 0) { $permission_issue = TRUE; }
							}
							//if there was a permissions issue, offer a way to enter better credentials
							if($permission_issue) {
								$output .= '<tr><td>A permissions issue was detected with the query, if more privileged credentials are available, enter them below.'
												.form_open('install/create_db_table/'.$table)
												.form_label('Privileged SQL User: ','sa_name')
												.form_input(array('name'=>'sa_name','id'=>'sa_name')).'<br/>'
												.form_label('Privileged SQL User Password: ','sa_pwd')
												.form_password(array('name'=>'sa_pwd','id'=>'sa_pwd')).'<br/>'
												.form_submit('create_'.$table,'Create '.$table)
												.form_close().'</td></tr>';
							}
							//but also give the query to run manually through SQL Management Studio
							//should pull query from flashdata if possible to ensure it is the right one, but if that isn't possible use the hardcoded one for create table
							if(!isset($query) || !$query) {
								$query = $this->database_table_queries['create_'.$table];
							}
							$output .= '<tr><td>To manually create table <span style="font-weight: bold;">' . $table . '</span> table use the following query:</td></tr>';
							$output .= '<tr><td><pre style="background: #eee; width: 1000px; word-wrap: break-word;">' . preg_replace('/[\t]+/',' ',$query) . '</pre></td></tr>';
						}
						else {
							$output .= '<tr><th title="'.$table.' does not exist" style="color: red;">' . $table . '</th></tr>';
							$output .= '<tr><td style="text-align: center;">'.form_open('install/create_db_table/'.$table).form_submit('create_'.$table,'Create '.$table).form_close().'</td></tr>';
						}
					}
					//if it does exist
					else {
						$output .= '<tr><th style="color: green;">' . $table . '</th><th>Status</th></tr>';
						foreach($columns as $column => $type) {
							$col_check_query = 'SELECT * FROM sys.columns WHERE [name] = '.$this->db->escape($column).' AND object_id = OBJECT_ID('.$this->db->escape($table).')';
							$col_check = $this->db->query($col_check_query);
							if($col_check) {
								$output .= '<tr>';
								if($col_check->num_rows() <= 0) {
									$output .= '<td style="color: red;">'.$column.' ['.$type.']</td>';
									$output .= '<td style="color: red; text-align: center;">&#x2717;</td>';
								}
								else {
									$output .= '<td style="color: green;">'.$column.' ['.$type.']</td>';
									$data_type_query = 'SELECT DATA_TYPE, CHARACTER_MAXIMUM_LENGTH FROM INFORMATION_SCHEMA.COLUMNS IC WHERE TABLE_NAME='.$this->db->escape($table).' AND COLUMN_NAME='.$this->db->escape($column);
									$data_type_check = $this->db->query($data_type_query);
									if($data_type_check) {
										if($col_check->num_rows() <= 0) {
										
										}
										else {
											$result = $data_type_check->result_array(0);
											$data_type = $result[0]['DATA_TYPE'];
											$max_length = ($result[0]['CHARACTER_MAXIMUM_LENGTH'] === -1) ? 'max' : $result[0]['CHARACTER_MAXIMUM_LENGTH'];
											if($data_type === $type || $data_type.'('.$max_length.')' === $type) {
												$output .= '<td style="color: green; text-align: center;">&#x2713;</td>';
											}
											else {
												$fix_col_query = 'ALTER TABLE '.$table.' ALTER COLUMN '.$column.' '.$type;
												$output .= '<td title="Data Type Mismatch. Click for alter column query." onclick="alert(&quot;'.$fix_col_query.'&quot;);" style="text-align: center; background: #fee; border: solid #f00 1px;"><span style="color: red;">&#x2717;</span></td>';
											}
										}
									}
								}
							}
							else { 
								$output .= '<td style="color: gold;">'.$column.' ['.$type.']</td>';
								$output .= '<td title="Click for manual column existence check query." onclick="alert(&quot;'.$col_check_query.'&quot;);" style="text-align: center; cursor: pointer;"><span style="color: gold;">&#x26a0;</span> Query Failed</td>'; 
							}
							$output .= '</tr>';
						}
					}
				}
				//if query fails, may not have the proper permissions
				else {
					$output .= '<tr><th style="color: gold; text-align: center;">&#x26a0; Database Check Failed</th></tr>';
					$output .= '<tr><td>Manually execute query below to check existence of <span style="font-weight: bold;">'.$table.'</span> table:</td></tr>';
					$output .= '<tr><td><pre>'.$tbl_check_query.'</pre></td></tr>';
				}
				//TABLE END
				$output .= '</table>';
			}
		}
		return $output;
	}
	
	public function create_ldap() {
		
	}
	
	public function create_ldap_entry($dn) {
		$dn = base64_decode(rawurldecode($dn));
		if(array_key_exists($dn, $this->ldap_schema)) {
			$this->_create_ldap_entry($dn);
		}
		redirect('install/ldap');
	}
	
	private function _create_ldap_entry($dn) {
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = @ldap_bind($ldap_conn, LDAP_ADMIN_USERNAME, LDAP_ADMIN_PASSWORD);
		if($ldap_bind) {
			ldap_add($ldap_conn, $dn, $this->ldap_schema[$dn]);
		}
		else {
		
		}
	}
	 
	private function ldap_entry_exists($ldap_conn,$dn) {
		$search = @ldap_search($ldap_conn, $dn, '(objectClass=*)');
		$result = @ldap_get_entries($ldap_conn,$search);
		if($result['count'] > 0) { return TRUE; }
		return FALSE;
	}
	
	private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}

	private function decode_sha256($data, $config_key = null) {
		$data = base64_decode($data);
		if(empty($config_key)) {
			$key = hash('sha256', config_item('encryption_key'), true);
		}
		else {
			$key = hash('sha256', $config_key, true);
		}

		$data = $this->encrypt->remove_cipher_noise($data,$key);
		
		$init_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC);
		if ($init_size > strlen($data))
		{
			return FALSE;
		}
		$init_vect = substr($data, 0, $init_size);
		$data = substr($data, $init_size);
		return mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $data, MCRYPT_MODE_CBC, $init_vect);
	}

	private function  is_ascii( $string = '' ) {
        $num = 0;
        while( isset( $string[$num] ) ) {
            if( ord( $string[$num] ) & 0x80 ) {
                return false;
            }
            $num++;
        }
        return true;
    }
	
	/* This function generates a 32 character random string for use as a password,
	 * utilizing a mix of lower and upper case, numbers, and special characters.
	 */
	private function random_password() {
		$chars = array("a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","1","2","3","4","5","6","7","8","9","0","!","@","#","$","%","^","&","*","(",")","{","}","?");
		$pass = "";
		$count = count($chars);
		for($i = 0; $i < 32; $i++) {
			$pass .= $chars[abs(hexdec(bin2hex(openssl_random_pseudo_bytes(6)))%$count)];
		}
		return $pass;
	}
	
	
	public function apply_default_mailbox(){
		$this->load->library('ldap', array('user'=> LDAP_SEARCH_USERNAME, 'pwd'=>LDAP_SEARCH_PASSWORD));
		$this->load->library('validator', array(), 'is');
		$this->load->library('error');
		$this->load->database();
		$this->load->helper('debug');
		
		require_model('user');
		
		echo '<h1>Apply Default Mailbox</h1>';
		echo '<p>This script checks for any users whose personal mailbox is hidden and who do not have a default mailbox set.  Where possible, this script will set the default mailbox.</p>';
		
		$users = User::find(array('default_mailbox' => null));
		echo '<p>Beginning checks for '.count($users).' users who do not have a default mailbox set ...</p>';
		
		$success_count = 0;
		$error_count = 0;
		foreach($users as $user){
			if($user->hide_personal_mailbox()){
				if(empty($user->mailbox_names())){
					$this->error->warning('Could not set default mailbox for '.$user->describe().': User does not belong to any mailboxes');
					$error_count++;
				}else{
					$user->default_mailbox = first_element($user->mailbox_names());
					if($user->save())
						$success_count++;
					else{
						$this->error->warning('Cold not save default mailbox for '.$user->describe().': an error occurred while saving');
						$error_count++;
					}
				}
			}
		}
		
		$unchanged_count = count($users) - $success_count - $error_count;
		
		$message = '';
		if(!empty($success_count))
			$message = 'Successfully changed the default mailbox for '.number_as_text($success_count).' '.pluralize_if_necessary('user', $success_count);
		
		if(!empty($error_count))
			$message .= 'Errors occurred for '.number_as_text($error_count).' '.pluralize_if_necessary('user', $error_count).'.  Check the log for further details.  ';

		$message .= $unchanged_count.'/'.count($users).' users did not need any changes.';
		
		echo '<p>Done!  '.$message.'</p>';				
	}


	public function update_shared_global_contacts(){
		$this->load->database();
		$this->load->library('validator', array(), 'is');
		$this->load->helper('debug');
		
		require_models('user', 'global_contact');
		
		echo '<h1>Update Shared Global Contacts</h1>';
		echo '<p>This script checks for any global contacts that are currently shared among users, and places the existing values into the admin_contact_list table.</p>';

		Global_contact::db()->where('sharing !=', null);
		$global_contacts = Global_contact::find();
				
		foreach($global_contacts as $global_contact){

			// based on the fact that the sharing column was string of comma-seperated usernames
			$shared_users = explode(',', strip_from_beginning(',', $global_contact->sharing));

			echo '<p>Updating shared contact information for '.$global_contact->describe().' .</p>';
			$success = true;
			foreach ($shared_users as $shared_user) {
				if(empty($shared_user)) continue; //some of the fields just have a comma in it for some reason
				$user = User::find_one(array('user_name' => $shared_user));
				if (User::is_an_entity($user)){
					if($global_contact->add_to_user_contact_list($user)){
						echo '<p>Successfully added shared relationship with User: '.$user->user_name.'</p>';
					}else{
						$success = false;
						echo '<p>Error occured while trying to update Global Contact: '. $global_contact->contact_id. ' that is shared with User: ' . $user->user_name. ' </p>';
					}
				}
			}
			if($success){						
				$global_contact->sharing = null;
				$global_contact->save();
			}
		}
		
		echo '<p>Done! '.Global_contact::count('sharing IS NOT NULL').' contacts in the database still have a value for admin_contact_list.sharing and should be corrected manually.</p>';
	}
		
		
			

	
}
