<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers

*/ /** */

require_once APPPATH.'controllers/restricted_controller.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class AddressBook extends Restricted_controller {
	
	function __construct() {
		parent::__construct();
		if(!IS_AJAX) show_404(); //all of the methods on this controller may only be accessed via AJAX
		require_models('contact', 'global_contact');
	}
	
	public function index(){
		$data['title'] = PORTAL_TITLE_PREFIX . 'Address Book';
		$data['initial_json'] = $this->_ajax_search();
		$this->load->view('addressbook/index',$data);
	}
	
	public function mainindex(){
		$data['title'] = PORTAL_TITLE_PREFIX . 'Address Book';
		$data['initial_json'] = $this->_ajax_search();
		$this->load->view('addressbook/mainindex',$data);
	}
	
	public function contacts() {
		$data['title'] = PORTAL_TITLE_PREFIX . 'Contacts List';
		$data['initial_json'] = $this->_ajax_contact_search();
		$this->load->view('addressbook/contacts',$data);
	}
	
	public function mainContacts() {
		$data['title'] = PORTAL_TITLE_PREFIX . 'Contacts List';
		$data['initial_json'] = $this->_ajax_contact_search();
		$this->load->view('addressbook/mainContacts',$data);
	}
	
	public function add_contact() {
		$this->form_validation->set_rules('first_name','First Name','required','xss_clean');
		$this->form_validation->set_rules('last_name','Last Name','required','xss_clean');		
		$this->form_validation->set_rules('mail','Direct Address','required|valid_email|max_length[50]|callback_valid_trusted_address','xss_clean');
		$this->form_validation->set_rules('telephone','Telephone Number','max_length[50]','xss_clean');	
		
		$this->form_validation->set_message('valid_email', 'The Direct Address field must contain a valid Direct email address.');
		
		$data['title'] = PORTAL_TITLE_PREFIX . 'Add Contact';
		if($this->form_validation->run() === TRUE) {
	
			//load the view as soon as possible so the ajax form get the data response back in time
			$this->load->view('addressbook/contacts',$data);

			$user_id = $this->user->id;
			$first_name = $this->input->post('first_name',TRUE);
			$middle_name = $this->input->post('middle_name',TRUE);
			$last_name = $this->input->post('last_name',TRUE);
			$department = $this->input->post('department',TRUE);
			$organization = $this->input->post('organization',TRUE);
			$telephone = $this->input->post('telephone',TRUE);
			$mail = $this->input->post('mail',TRUE);		
			$title = $this->input->post('title',TRUE);		
	
			$contact = Contact::create(compact('user_id', 'first_name', 'middle_name', 'last_name', 'department', 'organization', 'telephone', 'mail', 'title'));

		}
		else {

			$form_data = $this->input->post(NULL, TRUE);
			
			$validation_errors = array();
			if(is_array($form_data)) {
				foreach($form_data as $key => $input) {
					if(strlen(form_error($key)) > 0) { $validation_errors[$key] = form_error($key); }
				}
				$data['validation_errors'] = $validation_errors;
			}
			$data['form_data'] = $form_data;
			$this->load->view('addressbook/add_contact',$data);
		}
	}
		
	public function edit_contact($contact_id) {
		if(!Contact::formatted_like_an_id($contact_id)) show_404();
		$contact = Contact::find_one(array('contact_id' => $contact_id, 'user_id' => $this->user->id));
		if(!Contact::is_an_entity($contact)) show_404();
		
		$property = $this->input->post('id',TRUE);
		$value = $this->input->post('value',TRUE);
		
		if(!in_array($property, array('first_name', 'middle_name', 'last_name', 'department', 'organization', 'telephone', 'mail', 'title')))
			return $this->error->should_be_a_known_property($property);
			
		$contact->$property = $value;
		if($contact->save()) echo htmlentities($value); 
	}
	
	public function delete_contact($contact_id) {
		if(!Contact::formatted_like_an_id($contact_id)) show_404();
		Contact::db()->where('user_id', $this->user->id);
		Contact::delete($contact_id);
	}
	
	public function add_distribution_list() {
		$this->load->view('addressbook/add_distribution_list');
	}
	
	public function ajax_contact_search($search_for = '', $limit = NULL) {
		echo $this->_ajax_contact_search($search_for, $limit);
	}
	
	public function ajax_search($search_for = NULL, $limit = NULL) {
		echo $this->_ajax_search($search_for, $limit);
	}

	public function valid_trusted_address($str) {
		//have to urlencode / base64 encode the address to send to the web service
		$str = rawurlencode(base64_encode($str));
		$resource = '/direct/validate/address/'.$str.'/format/json';
		$url = WEBSERVICE_URL . $resource;
		
		$headers = array(
			'Authorization: DPII ' . WEBSERVICE_PUBLIC_KEY . ':'. base64_encode(hash_hmac('sha256',"GET\n" . date('U'). "\n" . $resource, WEBSERVICE_PRIVATE_KEY)),
			'Date: ' . date('U'),
			);
		$ch = curl_init();
		curl_setopt($ch,CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER,$headers);
		$server_output = curl_exec($ch);
		if($server_output === false)
			trigger_error( curl_error($ch), E_USER_WARNING);
		$http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$response = json_decode($server_output);
		if(isset($response->valid)) {
			$valid = $response->valid;
			if(!$valid) { $this->form_validation->set_message('valid_trusted_address', 'The %s field must be a trusted Direct Address'); }
			return $valid;
		}
		else { $this->form_validation->set_message('valid_trusted_address', 'The %s field must be a trusted Direct Address'); return FALSE; }
	}
	
//////////////////////////////
// PROTECTED METHODS
//////////////////////////////	
	
	protected function _ajax_contact_search($search_for = '', $limit=NULL) {
		if(!is_string($search_for)) return $this->error->should_be_a_string($search_for);
		if(!is_null($limit) && !$this->is->nonzero_unsigned_integer($limit)) return $this->error->should_be_a_nonzero_unsigned_integer($limit);
		
		$search_for = rawurldecode($search_for);
		
		//find the logged-in user's contacts
		Contact::db()->group_start()->like('last_name', $search_for, 'after')->or_like('mail', $search_for, 'after')->group_end();
		if(!empty($limit)) Contact::db()->limit($limit);
		$contacts = collect('values_for_search', $this->user->contacts);
	
		//find the logged-in user's private distribution lists
		$this->db->order_by('name');
		$this->db->like('name', $search_for, 'after');
		$distros = array_map(array($this->private_distribution_list_model, 'values_for_search'), $this->private_distribution_list_model->find());
		
		$admin_contacts = array();
		Global_contact::db()->group_start()->like('last_name', $search_for, 'after')->or_like('direct_address', $search_for, 'after')->group_end();
		if(!empty($limit)) Global_contact::db()->limit($limit);
		$admin_contacts = collect('values_for_search', $this->user->global_contacts);		
		
		$all_contacts = array_merge($contacts, $distros, $admin_contacts);
		
		//sort result array (natural order, case insensitive) and protect the values through htmlentities
		usort($all_contacts, function($a, $b) { return strnatcasecmp( $a['displayname'], $b['displayname']); });
		array_walk_recursive($all_contacts, function (&$value) { $value = htmlentities($value); });
		
		return $this->json->encode($all_contacts);
	}	
	
	protected function _ajax_search($search_for = NULL, $limit = NULL) {
		$properties = null;
		if(is_null($limit)){ 
			$properties = array('displayname','objectclass','mail','uid','givenname','initials','sn','physicaldeliveryofficename','o','departmentnumber','mobile','telephonenumber','title');
		}
		
		$results = $this->ldap->search(rawurldecode($search_for),$limit,$properties);
		
		//find public distribution lists that match this data
		$results = array_merge($results, array_map(array($this->public_distribution_list_model, 'values_for_search'), $this->public_distribution_list_model->find(array('cn'=>$search_for.'*'))));
		
		//sort result array (natural order, case insensitive) and protect the values through htmlentities
		usort($results, function($el1, $el2) { return strnatcasecmp( (isset($el1['displayname']) ? $el1['displayname'] : $el1['name']), (isset($el2['displayname']) ? $el2['displayname'] : $el2['name'])); });
		array_walk_recursive($results, function (&$value) { $value = htmlentities($value); });		
		
		return $this->json->encode($results); 
	}
	
	
}
